/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.uiDesigner.compiler;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.java.CopyResourcesUtil;
import org.jetbrains.jps.incremental.java.FormsParsing;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.uiDesigner.compiler.FormsBuilder;
import org.jetbrains.jps.uiDesigner.model.JpsUiDesignerConfiguration;
import org.jetbrains.jps.uiDesigner.model.JpsUiDesignerExtensionService;

public class FormsBindingManager
extends FormsBuilder {
    private static final String JAVA_EXTENSION = ".java";
    private static final Key<Boolean> FORCE_FORMS_REBUILD_FLAG = Key.create((String)"_forms_rebuild_flag_");
    private static final Key<Boolean> FORMS_REBUILD_FORCED = Key.create((String)"_forms_rebuild_forced_flag_");

    public FormsBindingManager() {
        super(BuilderCategory.SOURCE_PROCESSOR, "form-bindings");
    }

    public void buildStarted(CompileContext context) {
        FORCE_FORMS_REBUILD_FLAG.set((UserDataHolder)context, (Object)FormsBindingManager.getMarkerFile(context).exists());
    }

    public void chunkBuildFinished(CompileContext context, ModuleChunk chunk) {
        FORMS_REBUILD_FORCED.set((UserDataHolder)context, null);
        super.chunkBuildFinished(context, chunk);
    }

    public void buildFinished(CompileContext context) {
        boolean currentRebuildValue;
        boolean previousValue = (Boolean)FORCE_FORMS_REBUILD_FLAG.get((UserDataHolder)context, (Object)Boolean.FALSE);
        JpsUiDesignerConfiguration config = JpsUiDesignerExtensionService.getInstance().getUiDesignerConfiguration(context.getProjectDescriptor().getProject());
        boolean bl = currentRebuildValue = config != null && !config.isInstrumentClasses();
        if (previousValue != currentRebuildValue) {
            File marker = FormsBindingManager.getMarkerFile(context);
            if (currentRebuildValue) {
                FileUtil.createIfDoesntExist((File)marker);
            } else {
                FileUtil.delete((File)marker);
            }
        }
    }

    @NotNull
    private static File getMarkerFile(CompileContext context) {
        return new File(context.getProjectDescriptor().dataManager.getDataPaths().getDataStorageRoot(), "forms_rebuild_required");
    }

    public List<String> getCompilableFileExtensions() {
        return Collections.singletonList("form");
    }

    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        ModuleLevelBuilder.ExitCode exitCode = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        JpsProject project2 = context.getProjectDescriptor().getProject();
        JpsUiDesignerConfiguration config = JpsUiDesignerExtensionService.getInstance().getOrCreateUiDesignerConfiguration(project2);
        if (!config.isInstrumentClasses() && !config.isCopyFormsRuntimeToOutput()) {
            return exitCode;
        }
        THashMap filesToCompile = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
        THashMap formsToCompile = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
        THashMap srcToForms = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
        if (!JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context) && config.isInstrumentClasses() && ((Boolean)FORCE_FORMS_REBUILD_FLAG.get((UserDataHolder)context, (Object)Boolean.FALSE)).booleanValue() && !((Boolean)FORMS_REBUILD_FORCED.get((UserDataHolder)context, (Object)Boolean.FALSE)).booleanValue()) {
            FORMS_REBUILD_FORCED.set((UserDataHolder)context, (Object)Boolean.TRUE);
            FSOperations.markDirty((CompileContext)context, (CompilationRound)CompilationRound.CURRENT, (ModuleChunk)chunk, (FileFilter)FORM_SOURCES_FILTER);
        }
        dirtyFilesHolder.processDirtyFiles((FileProcessor)new FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget>((Map)filesToCompile, (Map)formsToCompile){
            final /* synthetic */ Map val$filesToCompile;
            final /* synthetic */ Map val$formsToCompile;
            {
                this.val$filesToCompile = map2;
                this.val$formsToCompile = map3;
            }

            public boolean apply(ModuleBuildTarget target, File file2, JavaSourceRootDescriptor descriptor) throws IOException {
                if (FormsBuilder.JAVA_SOURCES_FILTER.accept(file2)) {
                    this.val$filesToCompile.put(file2, target);
                } else if (FormsBuilder.FORM_SOURCES_FILTER.accept(file2)) {
                    this.val$formsToCompile.put(file2, target);
                }
                return true;
            }
        });
        if (config.isInstrumentClasses()) {
            JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project2);
            JpsCompilerExcludes excludes = configuration.getCompilerExcludes();
            for (Map.Entry entry : formsToCompile.entrySet()) {
                File file2 = (File)entry.getKey();
                ModuleBuildTarget target = (ModuleBuildTarget)entry.getValue();
                Collection<File> sources = FormsBindingManager.findBoundSourceCandidates(context, target, file2);
                for (File boundSource : sources) {
                    if (excludes.isExcluded(boundSource)) continue;
                    FormsBindingManager.addBinding(boundSource, file2, (Map<File, Collection<File>>)srcToForms);
                    FSOperations.markDirty((CompileContext)context, (CompilationRound)CompilationRound.CURRENT, (File)boundSource);
                    filesToCompile.put(boundSource, target);
                    exitCode = ModuleLevelBuilder.ExitCode.OK;
                }
            }
            OneToManyPathsMapping sourceToFormMap = context.getProjectDescriptor().dataManager.getSourceToFormMap();
            for (Map.Entry entry : filesToCompile.entrySet()) {
                File srcFile = (File)entry.getKey();
                ModuleBuildTarget target = (ModuleBuildTarget)entry.getValue();
                Collection boundForms = sourceToFormMap.getState(srcFile.getPath());
                if (boundForms == null) continue;
                for (String formPath : boundForms) {
                    File formFile = new File(formPath);
                    if (excludes.isExcluded(formFile) || !formFile.exists()) continue;
                    FormsBindingManager.addBinding(srcFile, formFile, (Map<File, Collection<File>>)srcToForms);
                    FSOperations.markDirty((CompileContext)context, (CompilationRound)CompilationRound.CURRENT, (File)formFile);
                    formsToCompile.put(formFile, target);
                    exitCode = ModuleLevelBuilder.ExitCode.OK;
                }
            }
        }
        FORMS_TO_COMPILE.set((UserDataHolder)context, (Object)(srcToForms.isEmpty() ? null : srcToForms));
        if (config.isCopyFormsRuntimeToOutput() && FormsBindingManager.containsValidForm(formsToCompile.keySet())) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                String string;
                List list;
                File outputDir;
                if (target.isTests() || (outputDir = target.getOutputDir()) == null || (list = CopyResourcesUtil.copyFormsRuntime((String)(string = FileUtil.toSystemIndependentName((String)outputDir.getPath())), (boolean)false)).isEmpty()) continue;
                exitCode = ModuleLevelBuilder.ExitCode.OK;
                for (File file2 : list) {
                    outputConsumer.registerOutputFile((BuildTarget)target, file2, Collections.emptyList());
                }
            }
        }
        return exitCode;
    }

    private static boolean containsValidForm(Set<File> files) {
        for (File file2 : files) {
            try {
                if (FormsParsing.readBoundClassName((File)file2) == null) continue;
                return true;
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    @NotNull
    private static Collection<File> findBoundSourceCandidates(CompileContext context, ModuleBuildTarget target, File form) throws IOException {
        List targetRoots = context.getProjectDescriptor().getBuildRootIndex().getTargetRoots((BuildTarget)target, context);
        if (targetRoots.isEmpty()) {
            return Collections.emptyList();
        }
        String className = FormsParsing.readBoundClassName((File)form);
        if (className == null) {
            return Collections.emptyList();
        }
        for (JavaSourceRootDescriptor rd : targetRoots) {
            File boundSource = FormsBindingManager.findSourceForClass(rd, className);
            if (boundSource == null) continue;
            return Collections.singleton(boundSource);
        }
        THashSet candidates = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (JavaSourceRootDescriptor rd : targetRoots) {
            candidates.addAll(FormsBindingManager.findPossibleSourcesForClass(rd, className));
        }
        return candidates;
    }

    @Nullable
    private static File findSourceForClass(JavaSourceRootDescriptor rd, @Nullable String boundClassName) throws IOException {
        if (boundClassName == null) {
            return null;
        }
        String relPath = FormsBindingManager.suggestRelativePath(rd, boundClassName);
        File candidate;
        while (!(candidate = new File(rd.getRootFile(), relPath)).exists()) {
            int index = relPath.lastIndexOf(47);
            if (index <= 0) {
                return null;
            }
            relPath = relPath.substring(0, index) + JAVA_EXTENSION;
        }
        return candidate.isFile() ? candidate : null;
    }

    @NotNull
    private static Collection<File> findPossibleSourcesForClass(JavaSourceRootDescriptor rd, @Nullable String boundClassName) throws IOException {
        if (boundClassName == null) {
            return Collections.emptyList();
        }
        String relPath = FormsBindingManager.suggestRelativePath(rd, boundClassName);
        File containingDirectory = new File(rd.getRootFile(), relPath).getParentFile();
        if (containingDirectory == null) {
            return Collections.emptyList();
        }
        File[] files = containingDirectory.listFiles(FileFilters.withExtension((String)"java"));
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    @NotNull
    private static String suggestRelativePath(@NotNull JavaSourceRootDescriptor rd, @NotNull String className) {
        String clsName = className;
        String prefix = rd.getPackagePrefix();
        if (!StringUtil.isEmpty((String)prefix)) {
            if (!StringUtil.endsWith((CharSequence)prefix, (CharSequence)".")) {
                prefix = prefix + ".";
            }
            if (SystemInfo.isFileSystemCaseSensitive ? StringUtil.startsWith((CharSequence)clsName, (CharSequence)prefix) : StringUtil.startsWithIgnoreCase((String)clsName, (String)prefix)) {
                clsName = clsName.substring(prefix.length());
            }
        }
        return clsName.replace('.', '/') + JAVA_EXTENSION;
    }
}

