/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.uiDesigner.model.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.uiDesigner.model.JpsUiDesignerConfiguration;

public class JpsUiDesignerConfigurationImpl
extends JpsElementBase<JpsUiDesignerConfigurationImpl>
implements JpsUiDesignerConfiguration {
    public static final JpsElementChildRole<JpsUiDesignerConfiguration> ROLE = JpsElementChildRoleBase.create((String)"ui designer configuration");
    private final UiDesignerConfigurationState myState = new UiDesignerConfigurationState();

    public JpsUiDesignerConfigurationImpl() {
    }

    public JpsUiDesignerConfigurationImpl(UiDesignerConfigurationState state) {
        this.myState.INSTRUMENT_CLASSES = state.INSTRUMENT_CLASSES;
        this.myState.COPY_FORMS_RUNTIME_TO_OUTPUT = state.COPY_FORMS_RUNTIME_TO_OUTPUT;
    }

    public UiDesignerConfigurationState getState() {
        return this.myState;
    }

    @NotNull
    public JpsUiDesignerConfigurationImpl createCopy() {
        return new JpsUiDesignerConfigurationImpl(this.myState);
    }

    @Override
    public boolean isCopyFormsRuntimeToOutput() {
        return this.myState.COPY_FORMS_RUNTIME_TO_OUTPUT;
    }

    @Override
    public void setCopyFormsRuntimeToOutput(boolean value2) {
        if (this.myState.COPY_FORMS_RUNTIME_TO_OUTPUT != value2) {
            this.myState.COPY_FORMS_RUNTIME_TO_OUTPUT = value2;
            this.fireElementChanged();
        }
    }

    @Override
    public boolean isInstrumentClasses() {
        return this.myState.INSTRUMENT_CLASSES;
    }

    @Override
    public void setInstrumentClasses(boolean value2) {
        if (this.myState.INSTRUMENT_CLASSES != value2) {
            this.myState.INSTRUMENT_CLASSES = value2;
            this.fireElementChanged();
        }
    }

    public void applyChanges(@NotNull JpsUiDesignerConfigurationImpl modified) {
        this.setCopyFormsRuntimeToOutput(modified.isCopyFormsRuntimeToOutput());
        this.setInstrumentClasses(modified.isInstrumentClasses());
    }

    public static class UiDesignerConfigurationState {
        public boolean INSTRUMENT_CLASSES = true;
        public boolean COPY_FORMS_RUNTIME_TO_OUTPUT = true;
    }
}

