/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestLanguage;
import org.jetbrains.lang.manifest.header.HeaderParserRepository;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;

public class ManifestCompletionContributor
extends CompletionContributor {
    private static final InsertHandler<LookupElement> HEADER_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            context.setAddCompletionChar(false);
            EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)": ");
            context.commitDocument();
        }
    };

    public ManifestCompletionContributor(final @NotNull HeaderParserRepository repository) {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)ManifestTokenType.HEADER_NAME).withLanguage((Language)ManifestLanguage.INSTANCE), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, @NotNull CompletionResultSet resultSet) {
                for (String header : repository.getAllHeaderNames()) {
                    resultSet.addElement((LookupElement)LookupElementBuilder.create((String)header).withInsertHandler(HEADER_INSERT_HANDLER));
                }
            }
        });
    }
}

