/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gradle.model.JpsGradleExtensionService;
import org.jetbrains.jps.gradle.model.JpsGradleModuleExtension;
import org.jetbrains.jps.model.java.impl.JpsJavaDependenciesEnumerationHandler;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsGradleDependenciesEnumerationHandler
extends JpsJavaDependenciesEnumerationHandler {
    private static final JpsGradleDependenciesEnumerationHandler SOURCE_SET_TYPE_INSTANCE = new JpsGradleDependenciesEnumerationHandler(true);
    private static final JpsGradleDependenciesEnumerationHandler NON_SOURCE_SET_TYPE_INSTANCE = new JpsGradleDependenciesEnumerationHandler(false);
    private final boolean myResolveModulePerSourceSet;

    public JpsGradleDependenciesEnumerationHandler(boolean resolveModulePerSourceSet) {
        this.myResolveModulePerSourceSet = resolveModulePerSourceSet;
    }

    public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        return this.myResolveModulePerSourceSet;
    }

    public boolean isProductionOnTestsDependency(JpsDependencyElement element) {
        return JpsGradleExtensionService.getInstance().isProductionOnTestDependency(element);
    }

    public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        return !this.myResolveModulePerSourceSet;
    }

    public boolean shouldProcessDependenciesRecursively() {
        return !this.myResolveModulePerSourceSet;
    }

    public static class GradleFactory
    extends JpsJavaDependenciesEnumerationHandler.Factory {
        @Nullable
        public JpsJavaDependenciesEnumerationHandler createHandler(@NotNull Collection<JpsModule> modules) {
            JpsGradleExtensionService service = JpsGradleExtensionService.getInstance();
            JpsGradleDependenciesEnumerationHandler handler = null;
            for (JpsModule module : modules) {
                JpsGradleModuleExtension gradleModuleExtension = service.getExtension(module);
                if (gradleModuleExtension == null) continue;
                if ("sourceSet".equals(gradleModuleExtension.getModuleType())) {
                    handler = SOURCE_SET_TYPE_INSTANCE;
                    break;
                }
                handler = NON_SOURCE_SET_TYPE_INSTANCE;
            }
            return handler;
        }
    }
}

