/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import com.intellij.openapi.Disposable;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;
import org.jetbrains.kotlin.utils.StringsKt;

public abstract class CLICompiler<A extends CommonCompilerArguments>
extends CLITool<A> {
    @NotNull
    public ExitCode execAndOutputXml(@NotNull PrintStream errStream, @NotNull Services services, String ... args) {
        if (errStream == null) {
            CLICompiler.$$$reportNull$$$0(0);
        }
        if (services == null) {
            CLICompiler.$$$reportNull$$$0(1);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(2);
        }
        ExitCode exitCode2 = this.exec(errStream, services, MessageRenderer.XML, args);
        if (exitCode2 == null) {
            CLICompiler.$$$reportNull$$$0(3);
        }
        return exitCode2;
    }

    @NotNull
    public ExitCode execFullPathsInMessages(@NotNull PrintStream errStream, @NotNull String[] args) {
        if (errStream == null) {
            CLICompiler.$$$reportNull$$$0(4);
        }
        if (args == null) {
            CLICompiler.$$$reportNull$$$0(5);
        }
        ExitCode exitCode2 = this.exec(errStream, Services.EMPTY, MessageRenderer.PLAIN_FULL_PATHS, args);
        if (exitCode2 == null) {
            CLICompiler.$$$reportNull$$$0(6);
        }
        return exitCode2;
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public ExitCode execImpl(@NotNull MessageCollector messageCollector, @NotNull Services services, @NotNull A arguments) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setupCommonArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull A arguments2, @NotNull Services services) {
        CompilerJarLocator locator;
        if (configuration == null) {
            CLICompiler.$$$reportNull$$$0(15);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(16);
        }
        if (services == null) {
            CLICompiler.$$$reportNull$$$0(17);
        }
        if (((CommonCompilerArguments)arguments2).getNoInline()) {
            configuration.put(CommonConfigurationKeys.DISABLE_INLINE, true);
        }
        if (((CommonCompilerArguments)arguments2).getIntellijPluginRoot() != null) {
            configuration.put(CLIConfigurationKeys.INTELLIJ_PLUGIN_ROOT, ((CommonCompilerArguments)arguments2).getIntellijPluginRoot());
        }
        if (((CommonCompilerArguments)arguments2).getReportOutputFiles()) {
            configuration.put(CommonConfigurationKeys.REPORT_OUTPUT_FILES, true);
        }
        if ((locator = services.get(CompilerJarLocator.class)) != null) {
            configuration.put(CLIConfigurationKeys.COMPILER_JAR_LOCATOR, locator);
        }
        this.setupLanguageVersionSettings(configuration, arguments2);
    }

    private void setupLanguageVersionSettings(@NotNull CompilerConfiguration configuration, @NotNull A arguments2) {
        LanguageFeature.State coroutinesState;
        if (configuration == null) {
            CLICompiler.$$$reportNull$$$0(18);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(19);
        }
        LanguageVersion languageVersion = CLICompiler.parseVersion(configuration, ((CommonCompilerArguments)arguments2).getLanguageVersion(), "language");
        LanguageVersion apiVersion = CLICompiler.parseVersion(configuration, ((CommonCompilerArguments)arguments2).getApiVersion(), "API");
        if (languageVersion == null) {
            languageVersion = LanguageVersion.LATEST_STABLE;
        }
        if (apiVersion == null) {
            apiVersion = languageVersion;
        } else {
            configuration.put(CLIConfigurationKeys.IS_API_VERSION_EXPLICIT, true);
        }
        if (apiVersion.compareTo(languageVersion) > 0) {
            configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.ERROR, "-api-version (" + apiVersion.getVersionString() + ") cannot be greater than -language-version (" + languageVersion.getVersionString() + ")", null);
        }
        if (!languageVersion.isStable()) {
            configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.STRONG_WARNING, "Language version " + languageVersion.getVersionString() + " is experimental, there are no backwards compatibility guarantees for new language and library features", null);
        }
        HashMap<LanguageFeature, LanguageFeature.State> extraLanguageFeatures = new HashMap<LanguageFeature, LanguageFeature.State>(0);
        if (((CommonCompilerArguments)arguments2).getMultiPlatform()) {
            extraLanguageFeatures.put(LanguageFeature.MultiPlatformProjects, LanguageFeature.State.ENABLED);
        }
        if ((coroutinesState = CLICompiler.chooseCoroutinesApplicabilityLevel(configuration, arguments2)) != null) {
            extraLanguageFeatures.put(LanguageFeature.Coroutines, coroutinesState);
        }
        CommonConfigurationKeysKt.setLanguageVersionSettings(configuration, new LanguageVersionSettingsImpl(languageVersion, ApiVersion.createByLanguageVersion(apiVersion), ((CommonCompilerArguments)arguments2).configureAnalysisFlags(configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY)), extraLanguageFeatures));
    }

    @Nullable
    private static KotlinPaths computeKotlinPaths(@NotNull MessageCollector messageCollector2, @NotNull CommonCompilerArguments arguments2) {
        KotlinPaths paths;
        if (messageCollector2 == null) {
            CLICompiler.$$$reportNull$$$0(20);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(21);
        }
        if (arguments2.getKotlinHome() != null) {
            File kotlinHome = new File(arguments2.getKotlinHome());
            if (kotlinHome.isDirectory()) {
                paths = new KotlinPathsFromHomeDir(kotlinHome);
            } else {
                messageCollector2.report(CompilerMessageSeverity.ERROR, "Kotlin home does not exist or is not a directory: " + kotlinHome, null);
                paths = null;
            }
        } else {
            paths = PathUtil.getKotlinPathsForCompiler();
        }
        if (paths != null) {
            messageCollector2.report(CompilerMessageSeverity.LOGGING, "Using Kotlin home directory " + paths.getHomePath(), null);
        }
        return paths;
    }

    @Nullable
    public static File getLibraryFromHome(@Nullable KotlinPaths paths, @NotNull Function1<KotlinPaths, File> getLibrary, @NotNull String libraryName, @NotNull MessageCollector messageCollector2, @NotNull String noLibraryArgument) {
        File stdlibJar;
        if (getLibrary == null) {
            CLICompiler.$$$reportNull$$$0(22);
        }
        if (libraryName == null) {
            CLICompiler.$$$reportNull$$$0(23);
        }
        if (messageCollector2 == null) {
            CLICompiler.$$$reportNull$$$0(24);
        }
        if (noLibraryArgument == null) {
            CLICompiler.$$$reportNull$$$0(25);
        }
        if (paths != null && (stdlibJar = getLibrary.invoke(paths)).exists()) {
            return stdlibJar;
        }
        messageCollector2.report(CompilerMessageSeverity.STRONG_WARNING, "Unable to find " + libraryName + " in the Kotlin home directory. Pass either " + noLibraryArgument + " to prevent adding it to the classpath, or the correct '-kotlin-home'", null);
        return null;
    }

    @Nullable
    private static LanguageFeature.State chooseCoroutinesApplicabilityLevel(@NotNull CompilerConfiguration configuration, @NotNull CommonCompilerArguments arguments2) {
        if (configuration == null) {
            CLICompiler.$$$reportNull$$$0(26);
        }
        if (arguments2 == null) {
            CLICompiler.$$$reportNull$$$0(27);
        }
        switch (arguments2.getCoroutinesState()) {
            case "error": {
                return LanguageFeature.State.ENABLED_WITH_ERROR;
            }
            case "enable": {
                return LanguageFeature.State.ENABLED;
            }
            case "warn": {
                return null;
            }
        }
        String message = "Invalid value of -Xcoroutines (should be: enable, warn or error): " + arguments2.getCoroutinesState();
        configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.ERROR, message, null);
        return null;
    }

    @Nullable
    private static LanguageVersion parseVersion(@NotNull CompilerConfiguration configuration, @Nullable String value, @NotNull String versionOf) {
        if (configuration == null) {
            CLICompiler.$$$reportNull$$$0(28);
        }
        if (versionOf == null) {
            CLICompiler.$$$reportNull$$$0(29);
        }
        if (value == null) {
            return null;
        }
        LanguageVersion version = LanguageVersion.fromVersionString(value);
        if (version != null) {
            return version;
        }
        List<String> versionStrings = ArraysKt.map(LanguageVersion.values(), LanguageVersion::getDescription);
        String message = "Unknown " + versionOf + " version: " + value + "\nSupported " + versionOf + " versions: " + StringsKt.join(versionStrings, ", ");
        configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.ERROR, message, null);
        return null;
    }

    protected abstract void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration var1, @NotNull A var2, @NotNull Services var3);

    @NotNull
    protected abstract ExitCode doExecute(@NotNull A var1, @NotNull CompilerConfiguration var2, @NotNull Disposable var3, @Nullable KotlinPaths var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errStream";
                break;
            }
            case 1: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/CLICompiler";
                break;
            }
            case 7: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageCollector";
                break;
            }
            case 9: 
            case 16: 
            case 19: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 15: 
            case 18: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getLibrary";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noLibraryArgument";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/CLICompiler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execAndOutputXml";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "execFullPathsInMessages";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "execImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execAndOutputXml";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execFullPathsInMessages";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "execImpl";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setupCommonArgumentsAndServices";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupLanguageVersionSettings";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeKotlinPaths";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryFromHome";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "chooseCoroutinesApplicabilityLevel";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

