/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.MissingDependencyClassChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "collectDiagnostics", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "diagnosticFor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "incompatibilityDiagnosticFor", "source", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "ClassifierUsage", "kotlin-compiler"})
public final class MissingDependencyClassChecker
implements CallChecker {
    public static final MissingDependencyClassChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        block2: {
            Object resultingDescriptor;
            Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
            Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
            Intrinsics.checkParameterIsNotNull(context, "context");
            Object obj = resultingDescriptor = resolvedCall2.getResultingDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(obj, "resultingDescriptor");
            for (Diagnostic diagnostic : this.collectDiagnostics(reportOn, (CallableDescriptor)obj)) {
                context.getTrace().report(diagnostic);
            }
            Object obj2 = resultingDescriptor;
            if (!(obj2 instanceof DeserializedMemberDescriptor)) {
                obj2 = null;
            }
            DeserializedMemberDescriptor deserializedMemberDescriptor = (DeserializedMemberDescriptor)obj2;
            DeserializedContainerSource containerSource = deserializedMemberDescriptor != null ? deserializedMemberDescriptor.getContainerSource() : null;
            Diagnostic diagnostic = this.incompatibilityDiagnosticFor(containerSource, reportOn);
            if (diagnostic == null) break block2;
            Diagnostic diagnostic2 = diagnostic;
            BindingTrace bindingTrace = context.getTrace();
            Object p1 = diagnostic2;
            bindingTrace.report((Diagnostic)p1);
        }
    }

    private final Diagnostic diagnosticFor(ClassifierDescriptor descriptor2, PsiElement reportOn) {
        if (descriptor2 instanceof NotFoundClasses.MockClassDescriptor) {
            return Errors.MISSING_DEPENDENCY_CLASS.on(reportOn, DescriptorUtilsKt.getFqNameSafe(descriptor2));
        }
        return this.incompatibilityDiagnosticFor(descriptor2.getSource(), reportOn);
    }

    private final Diagnostic incompatibilityDiagnosticFor(SourceElement source, PsiElement reportOn) {
        if (source instanceof DeserializedContainerSource) {
            IncompatibleVersionErrorData<?> incompatibility = ((DeserializedContainerSource)source).getIncompatibility();
            if (incompatibility != null) {
                return Errors.INCOMPATIBLE_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString(), incompatibility);
            }
            if (((DeserializedContainerSource)source).isPreReleaseInvisible()) {
                return Errors.PRE_RELEASE_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString());
            }
        }
        return null;
    }

    private final Set<Diagnostic> collectDiagnostics(PsiElement reportOn, CallableDescriptor descriptor2) {
        Object object;
        Object p1;
        Object object2;
        Set result2 = CollectionsKt.newLinkedHashSetWithExpectedSize(1);
        Function1<ClassDescriptor, Unit> consider$ = new Function1<ClassDescriptor, Unit>(reportOn, result2){
            final /* synthetic */ PsiElement $reportOn;
            final /* synthetic */ Set $result;

            public final void invoke(@NotNull ClassDescriptor classDescriptor) {
                block2: {
                    ClassDescriptor classDescriptor2;
                    Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
                    Diagnostic diagnostic = MissingDependencyClassChecker.access$diagnosticFor(MissingDependencyClassChecker.INSTANCE, classDescriptor, this.$reportOn);
                    if (diagnostic != null) {
                        this.$result.add(diagnostic);
                        return;
                    }
                    DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
                    if (!(declarationDescriptor instanceof ClassDescriptor)) {
                        declarationDescriptor = null;
                    }
                    ClassDescriptor classDescriptor3 = (ClassDescriptor)declarationDescriptor;
                    if (classDescriptor3 == null) break block2;
                    ClassDescriptor p1 = classDescriptor2 = classDescriptor3;
                    this.invoke(p1);
                }
            }
            {
                this.$reportOn = psiElement;
                this.$result = set;
                super(1);
            }
        };
        Function1<KotlinType, Unit> consider$2 = new Function1<KotlinType, Unit>(consider$){
            final /* synthetic */ collectDiagnostics.1 $consider;

            public final void invoke(@NotNull KotlinType type2) {
                block2: {
                    Intrinsics.checkParameterIsNotNull(type2, "type");
                    if (CallCheckerKt.isComputingDeferredType(MissingDependencyClassChecker.INSTANCE, type2)) break block2;
                    ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                    if (!(classifierDescriptor instanceof ClassDescriptor)) {
                        classifierDescriptor = null;
                    }
                    ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
                    if (classDescriptor != null) {
                        ClassDescriptor classDescriptor2;
                        ClassDescriptor p1 = classDescriptor2 = classDescriptor;
                        this.$consider.invoke(p1);
                    }
                }
            }
            {
                this.$consider = var1_1;
                super(1);
            }
        };
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType != null) {
            p1 = object2 = kotlinType;
            consider$2.invoke((KotlinType)p1);
        }
        if ((object = descriptor2.getExtensionReceiverParameter()) != null && (object = object.getValue()) != null && (object = object.getType()) != null) {
            p1 = object2 = object;
            consider$2.invoke((KotlinType)p1);
        }
        Iterable $receiver$iv = descriptor2.getValueParameters();
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            KotlinType kotlinType2 = it.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "it.type");
            consider$2.invoke(kotlinType2);
        }
        return result2;
    }

    private MissingDependencyClassChecker() {
        INSTANCE = this;
    }

    static {
        new MissingDependencyClassChecker();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lcom/intellij/psi/PsiElement;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "kotlin-compiler"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        public static final ClassifierUsage INSTANCE;

        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element, @NotNull LanguageVersionSettings languageVersionSettings) {
            block2: {
                Diagnostic diagnostic;
                ClassifierDescriptor classifierDescriptor;
                Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
                Intrinsics.checkParameterIsNotNull(trace, "trace");
                Intrinsics.checkParameterIsNotNull(element, "element");
                Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
                Diagnostic diagnostic2 = INSTANCE.diagnosticFor(targetDescriptor, element);
                if (diagnostic2 != null) {
                    Diagnostic diagnostic3;
                    Diagnostic p1 = diagnostic3 = diagnostic2;
                    trace.report(p1);
                }
                if (!((classifierDescriptor = targetDescriptor) instanceof DeserializedMemberDescriptor)) {
                    classifierDescriptor = null;
                }
                DeserializedMemberDescriptor deserializedMemberDescriptor = (DeserializedMemberDescriptor)((Object)classifierDescriptor);
                DeserializedContainerSource containerSource = deserializedMemberDescriptor != null ? deserializedMemberDescriptor.getContainerSource() : null;
                Diagnostic diagnostic4 = INSTANCE.incompatibilityDiagnosticFor(containerSource, element);
                if (diagnostic4 == null) break block2;
                Diagnostic p1 = diagnostic = diagnostic4;
                trace.report(p1);
            }
        }

        private ClassifierUsage() {
            INSTANCE = this;
        }

        static {
            new ClassifierUsage();
        }
    }
}

