/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.apk.ApkDebugger;
import com.android.tools.idea.apk.ApkDebuggingUsageTracker;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFileType;
import com.android.tools.idea.apk.ApkModuleFactory;
import com.android.tools.idea.apk.ApkModuleSetup;
import com.android.tools.idea.apk.ApkProjectFolder;
import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.AsyncResult;
import com.android.tools.idea.apk.FileOpener;
import com.android.tools.idea.apk.issues.SetupIssueReporter;
import com.android.tools.idea.apk.setup.ProjectApkFileSetup;
import com.android.tools.idea.apk.setup.project.ProjectSdkSetup;
import com.android.tools.idea.gradle.project.importing.NewProjectSetup;
import com.android.tools.idea.gradle.project.importing.ProjectFolder;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.CustomProjectTypeImporter;
import com.android.tools.idea.util.ToolWindows;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkProjectImporter
extends CustomProjectTypeImporter {
    @NotNull
    private final ProjectFolder.Factory myProjectFolderFactory;
    @NotNull
    private final ApkProjectFolder myProjectFolder;
    @NotNull
    private final NewProjectSetup myNewProjectSetup;
    @NotNull
    private final ProjectApkFileSetup myApkFileSetup;
    @NotNull
    private final ApkModuleFactory myApkModuleFactory;
    @NotNull
    private final ApkModuleSetup myApkModuleSetup;
    @NotNull
    private final ApkDebugger.Factory myDebuggerFactory;
    @NotNull
    private final ProjectSdkSetup myProjectSdkSetup;
    @NotNull
    private final FileOpener myFileOpener;
    private final boolean myStartDebugSession;

    public ApkProjectImporter() {
        this(new ProjectFolder.Factory(), new ApkProjectFolder(), new NewProjectSetup(), new ProjectApkFileSetup(), new ApkModuleFactory(), new ApkModuleSetup(), new ApkDebugger.Factory(), new ProjectSdkSetup(), new FileOpener(), false);
    }

    @VisibleForTesting
    public ApkProjectImporter(@NotNull ProjectFolder.Factory projectFolderFactory, @NotNull ApkProjectFolder projectFolder, @NotNull NewProjectSetup newProjectSetup, @NotNull ProjectApkFileSetup apkFileSetup, @NotNull ApkModuleFactory apkModuleFactory, @NotNull ApkModuleSetup apkModuleSetup, @NotNull ApkDebugger.Factory debuggerFactory, @NotNull ProjectSdkSetup projectSdkSetup, @NotNull FileOpener fileOpener, boolean startDebugSession) {
        this.myProjectFolderFactory = projectFolderFactory;
        this.myProjectFolder = projectFolder;
        this.myNewProjectSetup = newProjectSetup;
        this.myApkFileSetup = apkFileSetup;
        this.myApkModuleFactory = apkModuleFactory;
        this.myApkModuleSetup = apkModuleSetup;
        this.myDebuggerFactory = debuggerFactory;
        this.myProjectSdkSetup = projectSdkSetup;
        this.myFileOpener = fileOpener;
        this.myStartDebugSession = startDebugSession;
    }

    public boolean canImport(@NotNull VirtualFile file) {
        return FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)file, null) instanceof ApkFileType;
    }

    public void importFile(@NotNull VirtualFile apkFile) {
        try {
            VirtualFile projectRootFolder = this.myProjectFolder.getOrCreateNewProjectFolder(apkFile);
            File projectRootFolderPath = VfsUtilCore.virtualToIoFile((VirtualFile)projectRootFolder);
            ProjectFolder projectFolder = this.myProjectFolderFactory.create(projectRootFolderPath);
            projectFolder.createIdeaProjectFolder();
            Project newProject = this.myNewProjectSetup.createProject(projectRootFolderPath.getName(), projectRootFolderPath.getPath());
            this.setUpApkProjectAsynchronous(newProject, apkFile);
        }
        catch (Throwable e) {
            ApkProjectImporter.showAndLogError(e);
        }
    }

    private void setUpApkProjectAsynchronous(@NotNull Project project, @NotNull VirtualFile apkFile) {
        AsyncResult<VirtualFile> callback = this.setUpApkFile(project, apkFile, project.getBaseDir());
        callback.doWhenDone(() -> {
            VirtualFile projectApkFile = (VirtualFile)callback.getResult();
            assert (projectApkFile != null);
            this.createAndSetupMainModule(project, projectApkFile);
        });
        callback.doWhenRejected(() -> {
            Throwable error = callback.getUnexpectedError();
            assert (error != null);
            ApkProjectImporter.showAndLogError(error);
        });
    }

    @NotNull
    private AsyncResult<VirtualFile> setUpApkFile(@NotNull Project project, final @NotNull VirtualFile apkFile, final @NotNull VirtualFile projectRootFolder) {
        final AsyncResult<VirtualFile> callback = new AsyncResult<VirtualFile>();
        Task.Modal task = new Task.Modal(project, "Set Up APK", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                try {
                    VirtualFile copy = ApkProjectImporter.this.setUpApkFile(apkFile, projectRootFolder, indicator);
                    if (copy != null) {
                        callback.setDone(copy);
                        return;
                    }
                    callback.setRejected(new FileNotFoundException("Failed to find APK file in the project"));
                }
                catch (Throwable error) {
                    callback.setRejected(error);
                }
            }
        };
        task.queue();
        return callback;
    }

    @Nullable
    private VirtualFile setUpApkFile(@NotNull VirtualFile apkFile, @NotNull VirtualFile projectRootFolder, @Nullable ProgressIndicator indicator) throws IOException, ExecutionException, InterruptedException {
        Path apkFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)apkFile).toPath();
        Path destination = VfsUtilCore.virtualToIoFile((VirtualFile)projectRootFolder).toPath();
        Path copyPath = this.myApkFileSetup.setUpApk(apkFilePath, destination, indicator);
        return VfsUtil.findFileByIoFile((File)copyPath.toFile(), (boolean)true);
    }

    private void createAndSetupMainModule(@NotNull Project project, @NotNull VirtualFile apkFile) {
        this.myProjectSdkSetup.setUpProject(project);
        try {
            ApkSetupContext context = this.myApkModuleFactory.createApkModule(project, apkFile);
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            if (!unitTestMode) {
                project.save();
            }
            Projects.open((Project)project);
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                try {
                    this.myApkModuleSetup.setUpApkModule(project, context);
                    this.myFileOpener.openFile(context.getApkFile(), project);
                    ApkFacet facet = context.getApkFacet();
                    assert (facet != null);
                    ApkDebuggingUsageTracker.logEvent(facet, AndroidStudioEvent.EventKind.APK_DEBUG_IMPORT);
                    SetupIssueReporter.getInstance(project).reportSetupIssues(facet);
                    if (this.myStartDebugSession) {
                        this.myDebuggerFactory.createNew(project).startDebugSession();
                    }
                }
                catch (Throwable e) {
                    ApkProjectImporter.showAndLogError(e);
                }
                if (!unitTestMode) {
                    ApplicationManager.getApplication().invokeLater(() -> ToolWindows.activateProjectView((Project)project));
                }
            });
        }
        catch (Throwable e) {
            ApkProjectImporter.showAndLogError(e);
        }
    }

    private static void showAndLogError(@NotNull Throwable e) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
            return;
        }
        Messages.showErrorDialog((String)e.getMessage(), (String)"APK Import");
        ApkProjectImporter.getLog().error(e);
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(ApkProjectImporter.class);
    }

    @VisibleForTesting
    public void setUpApkProjectSynchronous(@NotNull Project project, @NotNull VirtualFile apkFile) throws InterruptedException, ExecutionException, IOException {
        VirtualFile projectApkFile = this.setUpApkFile(apkFile, project.getBaseDir(), null);
        assert (projectApkFile != null);
        this.createAndSetupMainModule(project, projectApkFile);
    }
}

