/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.external.system;

import com.android.tools.idea.apk.external.system.ApkProjectSettings;
import com.android.tools.idea.apk.external.system.ApkProjectSettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.DelegatingExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

public class ApkSystemSettings
extends AbstractExternalSystemSettings<ApkSystemSettings, ApkProjectSettings, ApkProjectSettingsListener> {
    private static final Topic<ApkProjectSettingsListener> TOPIC = Topic.create((String)"APK project settings", ApkProjectSettingsListener.class);

    @NotNull
    public static ApkSystemSettings getInstance(@NotNull Project project) {
        return (ApkSystemSettings)((Object)ServiceManager.getService((Project)project, ApkSystemSettings.class));
    }

    public ApkSystemSettings(@NotNull Project project) {
        super(TOPIC, project);
    }

    public void subscribe(@NotNull ExternalSystemSettingsListener<ApkProjectSettings> listener) {
        this.getProject().getMessageBus().connect((Disposable)this.getProject()).subscribe(TOPIC, (Object)new DelegatingApkSystemSettingsListener(listener));
    }

    protected void copyExtraSettingsFrom(@NotNull ApkSystemSettings settings) {
    }

    protected void checkSettings(@NotNull ApkProjectSettings old, @NotNull ApkProjectSettings current) {
    }

    private static class DelegatingApkSystemSettingsListener
    extends DelegatingExternalSystemSettingsListener<ApkProjectSettings>
    implements ApkProjectSettingsListener {
        DelegatingApkSystemSettingsListener(@NotNull ExternalSystemSettingsListener<ApkProjectSettings> delegate) {
            super(delegate);
        }
    }
}

