/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.issues;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.ApkSyncMessages;
import com.android.tools.idea.apk.OpenLibraryInEditorAction;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.debugging.SetupIssue;
import com.android.tools.idea.apk.issues.IssueCategory;
import com.android.tools.idea.apk.issues.SetupIssueReportStrategy;
import com.android.tools.idea.project.messages.MessageType;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DebugSymbolsMissingReporter
extends SetupIssueReportStrategy {
    DebugSymbolsMissingReporter(@NotNull ApkSyncMessages syncMessages) {
        super(syncMessages);
    }

    @Override
    @NotNull
    IssueCategory getSupportedCategory() {
        return IssueCategory.DEBUG_SYMBOLS_MISSING;
    }

    @Override
    void report(@NotNull SetupIssue issue, @NotNull ApkFacet facet) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("To debug the APK, native libraries (*.so files) must have debug symbols.<br/>");
        List libraries = ((ApkFacetConfiguration)facet.getConfiguration()).getLibrariesWithoutDebugSymbols();
        int libraryCount = libraries.size();
        NotificationCategory category = MessageType.valueOf((String)issue.severity).convertToCategory();
        if (libraryCount == 1) {
            NativeLibrary library = (NativeLibrary)libraries.get(0);
            buffer.append("<a href='").append(library.name).append("'>Add debug symbols to ").append(library.name).append("</a>");
        } else {
            buffer.append("The following libraries are missing debug symbols (click link to add debug symbols):<br/>");
            for (int i = 0; i < libraryCount; ++i) {
                NativeLibrary library = (NativeLibrary)libraries.get(i);
                buffer.append("&nbsp;*&nbsp;<a href='").append(library.name).append("'>").append(library.name).append("</a>");
                if (i >= libraryCount - 1) continue;
                buffer.append("<br/>");
            }
        }
        ApkSyncMessages syncMessages = this.getSyncMessages();
        NotificationData notification = syncMessages.createNotification("APK Import", buffer.toString(), category, null);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)facet.getModule().getProject());
        for (NativeLibrary library : libraries) {
            notification.setListener(library.name, (NotificationListener)new OpenLibraryInEditorAction(library, fileEditorManager));
        }
        syncMessages.report(notification);
    }
}

