/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.issues;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkSyncMessages;
import com.android.tools.idea.apk.debugging.SetupIssue;
import com.android.tools.idea.apk.issues.IssueCategory;
import com.android.tools.idea.apk.issues.SetupIssueReportStrategy;
import com.android.tools.idea.apk.sdk.AndroidSdkSetup;
import com.android.tools.idea.apk.sdk.InstallPlatformQuickFix;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.IdeSdks;
import java.io.File;
import org.jetbrains.annotations.NotNull;

class SdkNotFoundReporter
extends SetupIssueReportStrategy {
    @NotNull
    private final IdeSdks myIdeSdks;

    SdkNotFoundReporter(@NotNull ApkSyncMessages syncMessages, @NotNull IdeSdks ideSdks) {
        super(syncMessages);
        this.myIdeSdks = ideSdks;
    }

    @Override
    @NotNull
    IssueCategory getSupportedCategory() {
        return IssueCategory.SDK_NOT_FOUND;
    }

    @Override
    void report(@NotNull SetupIssue issue, @NotNull ApkFacet facet) {
        String sdkVersion = issue.extraInfo;
        String text = "Failed to find Android target '" + sdkVersion + "'";
        SyncMessage message = new SyncMessage("APK Import", MessageType.valueOf((String)issue.severity), new String[]{text});
        message.add((NotificationHyperlink)new InstallPlatformQuickFix(new AndroidSdkSetup(), facet, this.getSdkPath(), sdkVersion));
        this.getSyncMessages().report(message);
    }

    @NotNull
    private File getSdkPath() {
        File sdkPath = this.myIdeSdks.getAndroidSdkPath();
        assert (sdkPath != null);
        return sdkPath;
    }
}

