/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.sdk;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.SetupIssue;
import com.android.tools.idea.apk.issues.IssueCategory;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.io.File;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkSetup {
    @NotNull
    private final AndroidSdks myAndroidSdks;

    public AndroidSdkSetup() {
        this(AndroidSdks.getInstance());
    }

    @VisibleForTesting
    AndroidSdkSetup(AndroidSdks androidSdks) {
        this.myAndroidSdks = androidSdks;
    }

    @Nullable
    public Sdk setUpSdk(@NotNull String sdkVersion, @NotNull File sdkPath, @NotNull ApkFacet facet, @NotNull ModifiableRootModel rootModel) {
        IAndroidTarget target = AndroidSdkSetup.findTarget(sdkVersion, sdkPath);
        if (target != null) {
            Sdk sdk = this.myAndroidSdks.findSuitableAndroidSdk(target.hashString());
            if (sdk != null) {
                rootModel.setSdk(sdk);
                return sdk;
            }
        } else {
            SetupIssue setupIssue = new SetupIssue();
            setupIssue.severity = MessageType.ERROR.name();
            setupIssue.category = IssueCategory.SDK_NOT_FOUND.name();
            setupIssue.extraInfo = String.valueOf(sdkVersion);
            ((ApkFacetConfiguration)facet.getConfiguration()).SETUP_ISSUES.add(setupIssue);
        }
        return null;
    }

    @Nullable
    private static IAndroidTarget findTarget(@NotNull String sdkVersion, @NotNull File sdkPath) {
        AndroidSdkData sdkData = AndroidSdkData.getSdkData((File)sdkPath);
        return sdkData != null ? sdkData.findTargetByApiLevel(sdkVersion) : null;
    }
}

