/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.setup.project;

import com.android.tools.idea.sdk.Jdks;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;

public class ProjectSdkSetup {
    public void setUpProject(@NotNull Project project) {
        ProjectSdkSetup.tryToSetProjectJdk(project, LanguageLevel.JDK_1_8, LanguageLevel.JDK_1_7, LanguageLevel.JDK_1_6);
    }

    private static void tryToSetProjectJdk(@NotNull Project project, LanguageLevel ... languageLevels) {
        for (LanguageLevel languageLevel : languageLevels) {
            if (!ProjectSdkSetup.tryToSetProjectJdk(project, languageLevel)) continue;
            return;
        }
    }

    private static boolean tryToSetProjectJdk(@NotNull Project project, @NotNull LanguageLevel languageLevel) {
        Sdk jdk = Jdks.getInstance().chooseOrCreateJavaSdk(languageLevel);
        if (jdk != null) {
            return (Boolean)ApplicationManager.getApplication().runWriteAction(() -> {
                ProjectRootManager.getInstance((Project)project).setProjectSdk(jdk);
                LanguageLevelProjectExtension.getInstance((Project)project).setLanguageLevel(languageLevel);
                return true;
            });
        }
        return false;
    }
}

