/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.ApkDebuggingUsageTracker;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.AsyncResult;
import com.android.tools.idea.apk.debugging.DebuggableSharedObjectFile;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.symbols.NdkPathMatcher;
import com.android.tools.idea.apk.symbols.SharedObjectFile;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugSymbolsUpdater {
    @NotNull
    private final LocalPathLocator myLocalPathLocator;
    @NotNull
    private final IdeSdks myIdeSdks;
    @NotNull
    private final NdkPathMatcher myNdkPathMatcher;

    public DebugSymbolsUpdater() {
        this(new LocalPathLocator(), IdeSdks.getInstance(), new NdkPathMatcher());
    }

    @VisibleForTesting
    DebugSymbolsUpdater(@NotNull LocalPathLocator localPathLocator, @NotNull IdeSdks ideSdks, @NotNull NdkPathMatcher ndkPathMatcher) {
        this.myLocalPathLocator = localPathLocator;
        this.myIdeSdks = ideSdks;
        this.myNdkPathMatcher = ndkPathMatcher;
    }

    @NotNull
    public AsyncResult<List<DebuggableSharedObjectFile>> updateDebugSymbolsInLibrary(final @NotNull List<SharedObjectFile> sharedObjectFiles, final @NotNull NativeLibrary library, final @NotNull ApkFacet facet) {
        final AsyncResult<List<DebuggableSharedObjectFile>> callback = new AsyncResult<List<DebuggableSharedObjectFile>>();
        new Task.Backgroundable(facet.getModule().getProject(), "Updating Library", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(false);
                try {
                    List<DebuggableSharedObjectFile> addedFiles = DebugSymbolsUpdater.this.updateDebugSymbolsInLibrary(sharedObjectFiles, library, facet, indicator);
                    callback.setDone(addedFiles);
                }
                catch (RuntimeException error) {
                    callback.setRejected(error);
                }
            }
        }.queue();
        return callback;
    }

    @VisibleForTesting
    @NotNull
    List<DebuggableSharedObjectFile> updateDebugSymbolsInLibrary(@NotNull List<SharedObjectFile> sharedObjectFiles, @NotNull NativeLibrary library, @NotNull ApkFacet facet, @NotNull ProgressIndicator indicator) {
        HashSet obsoleteDebugSymbolPaths = new HashSet();
        HashSet<String> newRemoteSourceFolderPaths = new HashSet<String>();
        ArrayList<DebuggableSharedObjectFile> addedFiles = new ArrayList<DebuggableSharedObjectFile>();
        indicator.setText("Updating debug symbols");
        int fileCount = sharedObjectFiles.size();
        for (int i = 0; i < fileCount; ++i) {
            indicator.setFraction((double)i / (double)fileCount);
            SharedObjectFile file = sharedObjectFiles.get(i);
            Abi abi = file.getAbi();
            assert (abi != null);
            DebuggableSharedObjectFile existingSharedObjectFile = (DebuggableSharedObjectFile)library.debuggableSharedObjectFilesByAbi.get(abi);
            if (existingSharedObjectFile != null) {
                obsoleteDebugSymbolPaths.addAll(existingSharedObjectFile.debugSymbolPaths);
            }
            List<String> debugSymbolPaths = file.getDebugSymbolPaths();
            obsoleteDebugSymbolPaths.removeAll(debugSymbolPaths);
            DebuggableSharedObjectFile debuggableFile = library.addDebuggableSharedObjectFile(abi, file.getActualFile());
            debuggableFile.debugSymbolPaths.addAll(file.getDebugSymbolPaths());
            addedFiles.add(debuggableFile);
            for (String debugSymbolPath : debuggableFile.debugSymbolPaths) {
                if (this.myLocalPathLocator.isLocal(debugSymbolPath)) continue;
                newRemoteSourceFolderPaths.add(debugSymbolPath);
            }
            ApkDebuggingUsageTracker.logEvent(facet, AndroidStudioEvent.EventKind.APK_DEBUG_ADD_SYMBOLS);
        }
        if (!obsoleteDebugSymbolPaths.isEmpty()) {
            for (String obsoletePath : obsoleteDebugSymbolPaths) {
                library.removePathMapping(obsoletePath);
            }
        }
        if (!newRemoteSourceFolderPaths.isEmpty()) {
            this.updatePathMappingValues(library, newRemoteSourceFolderPaths, this.myIdeSdks.getAndroidNdkPath());
        }
        library.recalculateSourceFolderPaths();
        return addedFiles;
    }

    public void updatePathMappingValues(@NotNull NativeLibrary library, @NotNull Collection<String> newRemoteSourceFolderPaths, @Nullable File ndkPath) {
        for (String debugSymbolPath : newRemoteSourceFolderPaths) {
            File match;
            String mappedPath = "";
            if (ndkPath != null && (match = this.myNdkPathMatcher.findMatchingPathInNdk(debugSymbolPath, ndkPath)) != null) {
                mappedPath = match.getPath();
            }
            library.addPathMapping(debugSymbolPath, mappedPath);
        }
    }

    public boolean isNdkPath(@NotNull String path) {
        return this.myNdkPathMatcher.isNdkPath(path);
    }

    @VisibleForTesting
    static class LocalPathLocator {
        LocalPathLocator() {
        }

        boolean isLocal(@NotNull String path) {
            return new File(path).exists();
        }
    }
}

