/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols.ui;

import com.android.tools.idea.apk.symbols.ui.TrimLeftFilePathSplittingPolicy;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.FileLabel;
import com.intellij.util.ui.FilePathSplittingPolicy;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class FilePathCellRenderer
extends FileLabel
implements TableCellRenderer {
    private static final int PREFERRED_TEXT_LENGTH = 50;
    private final FilePathSplittingPolicy myPolicy = new TrimLeftFilePathSplittingPolicy();

    public FilePathCellRenderer(int leftGap) {
        this.setBorder(new EmptyBorder(0, leftGap, 0, 0));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String text = Objects.toString(value, "");
        if (StringUtil.isNotEmpty((String)text)) {
            File path = new File(text);
            this.setFile(path);
            this.setIcon(AllIcons.Nodes.Folder);
            int width = this.getIconWidth() + this.getFontMetrics(this.getFont()).stringWidth(FilePathCellRenderer.getFilePath((File)path)) + 30;
            this.setPreferredSize(new Dimension(width, this.getPreferredSize().height));
        }
        return this;
    }

    public String getText() {
        if (this.myFile == null) {
            return "";
        }
        int width = this.getWidth();
        if (this.getIcon() != null) {
            width -= this.getIconWidth();
        }
        return this.myPolicy.getOptimalTextForComponent(this.myFile, (JComponent)((Object)this), width);
    }

    protected int getPreferredWidth() {
        return this.getIconWidth() + this.getFontMetrics(this.getFont()).stringWidth(this.myPolicy.getPresentableName(this.myFile, 50));
    }
}

