/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothGattCallback;
import android.os.Handler;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BluetoothGatt
implements BluetoothProfile {
    private static final String TAG = "BluetoothGatt";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private IBluetoothGatt mService;
    private volatile BluetoothGattCallback mCallback;
    private Handler mHandler;
    private int mClientIf;
    private BluetoothDevice mDevice;
    private boolean mAutoConnect;
    private int mAuthRetryState;
    private int mConnState;
    private final Object mStateLock = new Object();
    private Boolean mDeviceBusy = false;
    private int mTransport;
    private int mPhy;
    private boolean mOpportunistic;
    private static final int AUTH_RETRY_STATE_IDLE = 0;
    private static final int AUTH_RETRY_STATE_NO_MITM = 1;
    private static final int AUTH_RETRY_STATE_MITM = 2;
    private static final int CONN_STATE_IDLE = 0;
    private static final int CONN_STATE_CONNECTING = 1;
    private static final int CONN_STATE_CONNECTED = 2;
    private static final int CONN_STATE_DISCONNECTING = 3;
    private static final int CONN_STATE_CLOSED = 4;
    private List<BluetoothGattService> mServices;
    public static final int GATT_SUCCESS = 0;
    public static final int GATT_READ_NOT_PERMITTED = 2;
    public static final int GATT_WRITE_NOT_PERMITTED = 3;
    public static final int GATT_INSUFFICIENT_AUTHENTICATION = 5;
    public static final int GATT_REQUEST_NOT_SUPPORTED = 6;
    public static final int GATT_INSUFFICIENT_ENCRYPTION = 15;
    public static final int GATT_INVALID_OFFSET = 7;
    public static final int GATT_INVALID_ATTRIBUTE_LENGTH = 13;
    public static final int GATT_CONNECTION_CONGESTED = 143;
    public static final int GATT_FAILURE = 257;
    public static final int CONNECTION_PRIORITY_BALANCED = 0;
    public static final int CONNECTION_PRIORITY_HIGH = 1;
    public static final int CONNECTION_PRIORITY_LOW_POWER = 2;
    static final int AUTHENTICATION_NONE = 0;
    static final int AUTHENTICATION_NO_MITM = 1;
    static final int AUTHENTICATION_MITM = 2;
    private final IBluetoothGattCallback mBluetoothGattCallback = new IBluetoothGattCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClientRegistered(int status, int clientIf) {
            Log.d(BluetoothGatt.TAG, "onClientRegistered() - status=" + status + " clientIf=" + clientIf);
            BluetoothGatt.this.mClientIf = clientIf;
            if (status != 0) {
                BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                        if (callback != null) {
                            callback.onConnectionStateChange(BluetoothGatt.this, 257, 0);
                        }
                    }
                });
                Object object = BluetoothGatt.this.mStateLock;
                synchronized (object) {
                    BluetoothGatt.this.mConnState = 0;
                }
                return;
            }
            try {
                BluetoothGatt.this.mService.clientConnect(BluetoothGatt.this.mClientIf, BluetoothGatt.this.mDevice.getAddress(), !BluetoothGatt.this.mAutoConnect, BluetoothGatt.this.mTransport, BluetoothGatt.this.mOpportunistic, BluetoothGatt.this.mPhy);
            }
            catch (RemoteException e) {
                Log.e(BluetoothGatt.TAG, "", e);
            }
        }

        @Override
        public void onPhyUpdate(String address, final int txPhy, final int rxPhy, final int status) {
            Log.d(BluetoothGatt.TAG, "onPhyUpdate() - status=" + status + " address=" + address + " txPhy=" + txPhy + " rxPhy=" + rxPhy);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onPhyUpdate(BluetoothGatt.this, txPhy, rxPhy, status);
                    }
                }
            });
        }

        @Override
        public void onPhyRead(String address, final int txPhy, final int rxPhy, final int status) {
            Log.d(BluetoothGatt.TAG, "onPhyRead() - status=" + status + " address=" + address + " txPhy=" + txPhy + " rxPhy=" + rxPhy);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onPhyRead(BluetoothGatt.this, txPhy, rxPhy, status);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClientConnectionState(final int status, int clientIf, boolean connected, String address) {
            Log.d(BluetoothGatt.TAG, "onClientConnectionState() - status=" + status + " clientIf=" + clientIf + " device=" + address);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            final int profileState = connected ? 2 : 0;
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onConnectionStateChange(BluetoothGatt.this, status, profileState);
                    }
                }
            });
            Object object = BluetoothGatt.this.mStateLock;
            synchronized (object) {
                if (connected) {
                    BluetoothGatt.this.mConnState = 2;
                } else {
                    BluetoothGatt.this.mConnState = 0;
                }
            }
            object = BluetoothGatt.this.mDeviceBusy;
            synchronized (object) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
        }

        @Override
        public void onSearchComplete(String address, List<BluetoothGattService> services, final int status) {
            Log.d(BluetoothGatt.TAG, "onSearchComplete() = Device=" + address + " Status=" + status);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            for (BluetoothGattService s : services) {
                s.setDevice(BluetoothGatt.this.mDevice);
            }
            BluetoothGatt.this.mServices.addAll(services);
            for (BluetoothGattService fixedService : BluetoothGatt.this.mServices) {
                ArrayList<BluetoothGattService> includedServices = new ArrayList<BluetoothGattService>(fixedService.getIncludedServices());
                fixedService.getIncludedServices().clear();
                for (BluetoothGattService brokenRef : includedServices) {
                    BluetoothGattService includedService = BluetoothGatt.this.getService(BluetoothGatt.this.mDevice, brokenRef.getUuid(), brokenRef.getInstanceId());
                    if (includedService != null) {
                        fixedService.addIncludedService(includedService);
                        continue;
                    }
                    Log.e(BluetoothGatt.TAG, "Broken GATT database: can't find included service.");
                }
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onServicesDiscovered(BluetoothGatt.this, status);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCharacteristicRead(String address, final int status, int handle, final byte[] value) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Boolean bl = BluetoothGatt.this.mDeviceBusy;
            synchronized (bl) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            if ((status == 5 || status == 15) && BluetoothGatt.this.mAuthRetryState != 2) {
                try {
                    int authReq = BluetoothGatt.this.mAuthRetryState == 0 ? 1 : 2;
                    BluetoothGatt.this.mService.readCharacteristic(BluetoothGatt.this.mClientIf, address, handle, authReq);
                    BluetoothGatt.this.mAuthRetryState++;
                    return;
                }
                catch (RemoteException e) {
                    Log.e(BluetoothGatt.TAG, "", e);
                }
            }
            BluetoothGatt.this.mAuthRetryState = 0;
            final BluetoothGattCharacteristic characteristic = BluetoothGatt.this.getCharacteristicById(BluetoothGatt.this.mDevice, handle);
            if (characteristic == null) {
                Log.w(BluetoothGatt.TAG, "onCharacteristicRead() failed to find characteristic!");
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        if (status == 0) {
                            characteristic.setValue(value);
                        }
                        callback.onCharacteristicRead(BluetoothGatt.this, characteristic, status);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCharacteristicWrite(String address, final int status, int handle) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Boolean bl = BluetoothGatt.this.mDeviceBusy;
            synchronized (bl) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            final BluetoothGattCharacteristic characteristic = BluetoothGatt.this.getCharacteristicById(BluetoothGatt.this.mDevice, handle);
            if (characteristic == null) {
                return;
            }
            if ((status == 5 || status == 15) && BluetoothGatt.this.mAuthRetryState != 2) {
                try {
                    int authReq = BluetoothGatt.this.mAuthRetryState == 0 ? 1 : 2;
                    BluetoothGatt.this.mService.writeCharacteristic(BluetoothGatt.this.mClientIf, address, handle, characteristic.getWriteType(), authReq, characteristic.getValue());
                    BluetoothGatt.this.mAuthRetryState++;
                    return;
                }
                catch (RemoteException e) {
                    Log.e(BluetoothGatt.TAG, "", e);
                }
            }
            BluetoothGatt.this.mAuthRetryState = 0;
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onCharacteristicWrite(BluetoothGatt.this, characteristic, status);
                    }
                }
            });
        }

        @Override
        public void onNotify(String address, int handle, final byte[] value) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            final BluetoothGattCharacteristic characteristic = BluetoothGatt.this.getCharacteristicById(BluetoothGatt.this.mDevice, handle);
            if (characteristic == null) {
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        characteristic.setValue(value);
                        callback.onCharacteristicChanged(BluetoothGatt.this, characteristic);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDescriptorRead(String address, final int status, int handle, final byte[] value) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Boolean bl = BluetoothGatt.this.mDeviceBusy;
            synchronized (bl) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            final BluetoothGattDescriptor descriptor = BluetoothGatt.this.getDescriptorById(BluetoothGatt.this.mDevice, handle);
            if (descriptor == null) {
                return;
            }
            if ((status == 5 || status == 15) && BluetoothGatt.this.mAuthRetryState != 2) {
                try {
                    int authReq = BluetoothGatt.this.mAuthRetryState == 0 ? 1 : 2;
                    BluetoothGatt.this.mService.readDescriptor(BluetoothGatt.this.mClientIf, address, handle, authReq);
                    BluetoothGatt.this.mAuthRetryState++;
                    return;
                }
                catch (RemoteException e) {
                    Log.e(BluetoothGatt.TAG, "", e);
                }
            }
            BluetoothGatt.this.mAuthRetryState = 0;
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        if (status == 0) {
                            descriptor.setValue(value);
                        }
                        callback.onDescriptorRead(BluetoothGatt.this, descriptor, status);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDescriptorWrite(String address, final int status, int handle) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Boolean bl = BluetoothGatt.this.mDeviceBusy;
            synchronized (bl) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            final BluetoothGattDescriptor descriptor = BluetoothGatt.this.getDescriptorById(BluetoothGatt.this.mDevice, handle);
            if (descriptor == null) {
                return;
            }
            if ((status == 5 || status == 15) && BluetoothGatt.this.mAuthRetryState != 2) {
                try {
                    int authReq = BluetoothGatt.this.mAuthRetryState == 0 ? 1 : 2;
                    BluetoothGatt.this.mService.writeDescriptor(BluetoothGatt.this.mClientIf, address, handle, authReq, descriptor.getValue());
                    BluetoothGatt.this.mAuthRetryState++;
                    return;
                }
                catch (RemoteException e) {
                    Log.e(BluetoothGatt.TAG, "", e);
                }
            }
            BluetoothGatt.this.mAuthRetryState = 0;
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onDescriptorWrite(BluetoothGatt.this, descriptor, status);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onExecuteWrite(String address, final int status) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            Boolean bl = BluetoothGatt.this.mDeviceBusy;
            synchronized (bl) {
                BluetoothGatt.this.mDeviceBusy = false;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onReliableWriteCompleted(BluetoothGatt.this, status);
                    }
                }
            });
        }

        @Override
        public void onReadRemoteRssi(String address, final int rssi, final int status) {
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onReadRemoteRssi(BluetoothGatt.this, rssi, status);
                    }
                }
            });
        }

        @Override
        public void onConfigureMTU(String address, final int mtu, final int status) {
            Log.d(BluetoothGatt.TAG, "onConfigureMTU() - Device=" + address + " mtu=" + mtu + " status=" + status);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onMtuChanged(BluetoothGatt.this, mtu, status);
                    }
                }
            });
        }

        @Override
        public void onConnectionUpdated(String address, final int interval, final int latency, final int timeout, final int status) {
            Log.d(BluetoothGatt.TAG, "onConnectionUpdated() - Device=" + address + " interval=" + interval + " latency=" + latency + " timeout=" + timeout + " status=" + status);
            if (!address.equals(BluetoothGatt.this.mDevice.getAddress())) {
                return;
            }
            BluetoothGatt.this.runOrQueueCallback(new Runnable(){

                @Override
                public void run() {
                    BluetoothGattCallback callback = BluetoothGatt.this.mCallback;
                    if (callback != null) {
                        callback.onConnectionUpdated(BluetoothGatt.this, interval, latency, timeout, status);
                    }
                }
            });
        }
    };

    BluetoothGatt(IBluetoothGatt iGatt, BluetoothDevice device, int transport, boolean opportunistic, int phy) {
        this.mService = iGatt;
        this.mDevice = device;
        this.mTransport = transport;
        this.mPhy = phy;
        this.mOpportunistic = opportunistic;
        this.mServices = new ArrayList<BluetoothGattService>();
        this.mConnState = 0;
        this.mAuthRetryState = 0;
    }

    public void close() {
        Log.d(TAG, "close()");
        this.unregisterApp();
        this.mConnState = 4;
        this.mAuthRetryState = 0;
    }

    BluetoothGattService getService(BluetoothDevice device, UUID uuid, int instanceId) {
        for (BluetoothGattService svc : this.mServices) {
            if (!svc.getDevice().equals(device) || svc.getInstanceId() != instanceId || !svc.getUuid().equals(uuid)) continue;
            return svc;
        }
        return null;
    }

    BluetoothGattCharacteristic getCharacteristicById(BluetoothDevice device, int instanceId) {
        for (BluetoothGattService svc : this.mServices) {
            for (BluetoothGattCharacteristic charac : svc.getCharacteristics()) {
                if (charac.getInstanceId() != instanceId) continue;
                return charac;
            }
        }
        return null;
    }

    BluetoothGattDescriptor getDescriptorById(BluetoothDevice device, int instanceId) {
        for (BluetoothGattService svc : this.mServices) {
            for (BluetoothGattCharacteristic charac : svc.getCharacteristics()) {
                for (BluetoothGattDescriptor desc : charac.getDescriptors()) {
                    if (desc.getInstanceId() != instanceId) continue;
                    return desc;
                }
            }
        }
        return null;
    }

    private void runOrQueueCallback(Runnable cb) {
        if (this.mHandler == null) {
            try {
                cb.run();
            }
            catch (Exception ex) {
                Log.w(TAG, "Unhandled exception in callback", ex);
            }
        } else {
            this.mHandler.post(cb);
        }
    }

    private boolean registerApp(BluetoothGattCallback callback, Handler handler) {
        Log.d(TAG, "registerApp()");
        if (this.mService == null) {
            return false;
        }
        this.mCallback = callback;
        this.mHandler = handler;
        UUID uuid = UUID.randomUUID();
        Log.d(TAG, "registerApp() - UUID=" + uuid);
        try {
            this.mService.registerClient(new ParcelUuid(uuid), this.mBluetoothGattCallback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    private void unregisterApp() {
        Log.d(TAG, "unregisterApp() - mClientIf=" + this.mClientIf);
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mCallback = null;
            this.mService.unregisterClient(this.mClientIf);
            this.mClientIf = 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean connect(Boolean autoConnect, BluetoothGattCallback callback, Handler handler) {
        Log.d(TAG, "connect() - device: " + this.mDevice.getAddress() + ", auto: " + autoConnect);
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mConnState != 0) {
                throw new IllegalStateException("Not idle");
            }
            this.mConnState = 1;
        }
        this.mAutoConnect = autoConnect;
        if (!this.registerApp(callback, handler)) {
            object = this.mStateLock;
            synchronized (object) {
                this.mConnState = 0;
            }
            Log.e(TAG, "Failed to register callback");
            return false;
        }
        return true;
    }

    public void disconnect() {
        Log.d(TAG, "cancelOpen() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mService.clientDisconnect(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    public boolean connect() {
        try {
            this.mService.clientConnect(this.mClientIf, this.mDevice.getAddress(), false, this.mTransport, this.mOpportunistic, this.mPhy);
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public void setPreferredPhy(int txPhy, int rxPhy, int phyOptions) {
        try {
            this.mService.clientSetPreferredPhy(this.mClientIf, this.mDevice.getAddress(), txPhy, rxPhy, phyOptions);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    public void readPhy() {
        try {
            this.mService.clientReadPhy(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    public BluetoothDevice getDevice() {
        return this.mDevice;
    }

    public boolean discoverServices() {
        Log.d(TAG, "discoverServices() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        this.mServices.clear();
        try {
            this.mService.discoverServices(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    public boolean discoverServiceByUuid(UUID uuid) {
        Log.d(TAG, "discoverServiceByUuid() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        this.mServices.clear();
        try {
            this.mService.discoverServiceByUuid(this.mClientIf, this.mDevice.getAddress(), new ParcelUuid(uuid));
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    public List<BluetoothGattService> getServices() {
        ArrayList<BluetoothGattService> result = new ArrayList<BluetoothGattService>();
        for (BluetoothGattService service : this.mServices) {
            if (!service.getDevice().equals(this.mDevice)) continue;
            result.add(service);
        }
        return result;
    }

    public BluetoothGattService getService(UUID uuid) {
        for (BluetoothGattService service : this.mServices) {
            if (!service.getDevice().equals(this.mDevice) || !service.getUuid().equals(uuid)) continue;
            return service;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readCharacteristic(BluetoothGattCharacteristic characteristic) {
        if ((characteristic.getProperties() & 2) == 0) {
            return false;
        }
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.readCharacteristic(this.mClientIf, device.getAddress(), characteristic.getInstanceId(), 0);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readUsingCharacteristicUuid(UUID uuid, int startHandle, int endHandle) {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.readUsingCharacteristicUuid(this.mClientIf, this.mDevice.getAddress(), new ParcelUuid(uuid), startHandle, endHandle, 0);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeCharacteristic(BluetoothGattCharacteristic characteristic) {
        if ((characteristic.getProperties() & 8) == 0 && (characteristic.getProperties() & 4) == 0) {
            return false;
        }
        if (this.mService == null || this.mClientIf == 0 || characteristic.getValue() == null) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.writeCharacteristic(this.mClientIf, device.getAddress(), characteristic.getInstanceId(), characteristic.getWriteType(), 0, characteristic.getValue());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readDescriptor(BluetoothGattDescriptor descriptor) {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattCharacteristic characteristic = descriptor.getCharacteristic();
        if (characteristic == null) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.readDescriptor(this.mClientIf, device.getAddress(), descriptor.getInstanceId(), 0);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeDescriptor(BluetoothGattDescriptor descriptor) {
        if (this.mService == null || this.mClientIf == 0 || descriptor.getValue() == null) {
            return false;
        }
        BluetoothGattCharacteristic characteristic = descriptor.getCharacteristic();
        if (characteristic == null) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.writeDescriptor(this.mClientIf, device.getAddress(), descriptor.getInstanceId(), 0, descriptor.getValue());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    public boolean beginReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.beginReliableWrite(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.endReliableWrite(this.mClientIf, this.mDevice.getAddress(), true);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            this.mDeviceBusy = false;
            return false;
        }
        return true;
    }

    public void abortReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mService.endReliableWrite(this.mClientIf, this.mDevice.getAddress(), false);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    @Deprecated
    public void abortReliableWrite(BluetoothDevice mDevice) {
        this.abortReliableWrite();
    }

    public boolean setCharacteristicNotification(BluetoothGattCharacteristic characteristic, boolean enable) {
        Log.d(TAG, "setCharacteristicNotification() - uuid: " + characteristic.getUuid() + " enable: " + enable);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        BluetoothDevice device = service.getDevice();
        if (device == null) {
            return false;
        }
        try {
            this.mService.registerForNotification(this.mClientIf, device.getAddress(), characteristic.getInstanceId(), enable);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    public boolean refresh() {
        Log.d(TAG, "refresh() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.refreshDevice(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    public boolean readRemoteRssi() {
        Log.d(TAG, "readRssi() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.readRemoteRssi(this.mClientIf, this.mDevice.getAddress());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    public boolean requestMtu(int mtu) {
        Log.d(TAG, "configureMTU() - device: " + this.mDevice.getAddress() + " mtu: " + mtu);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.configureMTU(this.mClientIf, this.mDevice.getAddress(), mtu);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    public boolean requestConnectionPriority(int connectionPriority) {
        if (connectionPriority < 0 || connectionPriority > 2) {
            throw new IllegalArgumentException("connectionPriority not within valid range");
        }
        Log.d(TAG, "requestConnectionPriority() - params: " + connectionPriority);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.connectionParameterUpdate(this.mClientIf, this.mDevice.getAddress(), connectionPriority);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @Override
    public int getConnectionState(BluetoothDevice device) {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectionState instead.");
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectedDevices instead.");
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        throw new UnsupportedOperationException("Use BluetoothManager#getDevicesMatchingConnectionStates instead.");
    }
}

