/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.le.ScanRecord;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class PeriodicAdvertisingReport
implements Parcelable {
    public static final int DATA_COMPLETE = 0;
    public static final int DATA_INCOMPLETE_TRUNCATED = 2;
    private int mSyncHandle;
    private int mTxPower;
    private int mRssi;
    private int mDataStatus;
    private ScanRecord mData;
    private long mTimestampNanos;
    public static final Parcelable.Creator<PeriodicAdvertisingReport> CREATOR = new Parcelable.Creator<PeriodicAdvertisingReport>(){

        @Override
        public PeriodicAdvertisingReport createFromParcel(Parcel source) {
            return new PeriodicAdvertisingReport(source);
        }

        public PeriodicAdvertisingReport[] newArray(int size) {
            return new PeriodicAdvertisingReport[size];
        }
    };

    public PeriodicAdvertisingReport(int syncHandle, int txPower, int rssi, int dataStatus, ScanRecord data) {
        this.mSyncHandle = syncHandle;
        this.mTxPower = txPower;
        this.mRssi = rssi;
        this.mDataStatus = dataStatus;
        this.mData = data;
    }

    private PeriodicAdvertisingReport(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSyncHandle);
        dest.writeLong(this.mTxPower);
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mDataStatus);
        if (this.mData != null) {
            dest.writeInt(1);
            dest.writeByteArray(this.mData.getBytes());
        } else {
            dest.writeInt(0);
        }
    }

    private void readFromParcel(Parcel in) {
        this.mSyncHandle = in.readInt();
        this.mTxPower = in.readInt();
        this.mRssi = in.readInt();
        this.mDataStatus = in.readInt();
        if (in.readInt() == 1) {
            this.mData = ScanRecord.parseFromBytes(in.createByteArray());
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getSyncHandle() {
        return this.mSyncHandle;
    }

    public int getTxPower() {
        return this.mTxPower;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public int getDataStatus() {
        return this.mDataStatus;
    }

    public ScanRecord getData() {
        return this.mData;
    }

    public long getTimestampNanos() {
        return this.mTimestampNanos;
    }

    public int hashCode() {
        return Objects.hash(this.mSyncHandle, this.mTxPower, this.mRssi, this.mDataStatus, this.mData, this.mTimestampNanos);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PeriodicAdvertisingReport other = (PeriodicAdvertisingReport)obj;
        return this.mSyncHandle == other.mSyncHandle && this.mTxPower == other.mTxPower && this.mRssi == other.mRssi && this.mDataStatus == other.mDataStatus && Objects.equals(this.mData, other.mData) && this.mTimestampNanos == other.mTimestampNanos;
    }

    public String toString() {
        return "PeriodicAdvertisingReport{syncHandle=" + this.mSyncHandle + ", txPower=" + this.mTxPower + ", rssi=" + this.mRssi + ", dataStatus=" + this.mDataStatus + ", data=" + Objects.toString(this.mData) + ", timestampNanos=" + this.mTimestampNanos + '}';
    }
}

