/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.BaseCanvas_Delegate;
import android.graphics.Canvas_Delegate;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Paint_Delegate;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.Path_Delegate;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Shader_Delegate;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.MathUtils;
import android.util.PathParser_Delegate;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.function.Consumer;

public class VectorDrawable_Delegate {
    private static final String LOGTAG = VectorDrawable_Delegate.class.getSimpleName();
    private static final boolean DBG_VECTOR_DRAWABLE = false;
    private static final DelegateManager<VNativeObject> sPathManager = new DelegateManager<VNativeObject>(VNativeObject.class);

    private static long addNativeObject(VNativeObject object) {
        long ptr = sPathManager.addNewDelegate(object);
        object.setNativePtr(ptr);
        return ptr;
    }

    private static TypedArray obtainAttributes(Resources res, Resources.Theme theme, AttributeSet set, int[] attrs) {
        if (theme == null) {
            return res.obtainAttributes(set, attrs);
        }
        return theme.obtainStyledAttributes(set, attrs, 0, 0);
    }

    private static int applyAlpha(int color2, float alpha) {
        int alphaBytes = Color.alpha(color2);
        color2 &= 0xFFFFFF;
        return color2 |= (int)((float)alphaBytes * alpha) << 24;
    }

    @LayoutlibDelegate
    static long nCreateTree(long rootGroupPtr) {
        return VectorDrawable_Delegate.addNativeObject(new VPathRenderer_Delegate(rootGroupPtr));
    }

    @LayoutlibDelegate
    static long nCreateTreeFromCopy(long rendererToCopyPtr, long rootGroupPtr) {
        VPathRenderer_Delegate rendererToCopy = (VPathRenderer_Delegate)VNativeObject.getDelegate(rendererToCopyPtr);
        return VectorDrawable_Delegate.addNativeObject(new VPathRenderer_Delegate(rendererToCopy, rootGroupPtr));
    }

    @LayoutlibDelegate
    static void nSetRendererViewportSize(long rendererPtr, float viewportWidth, float viewportHeight) {
        VPathRenderer_Delegate nativePathRenderer = (VPathRenderer_Delegate)VNativeObject.getDelegate(rendererPtr);
        nativePathRenderer.mViewportWidth = viewportWidth;
        nativePathRenderer.mViewportHeight = viewportHeight;
    }

    @LayoutlibDelegate
    static boolean nSetRootAlpha(long rendererPtr, float alpha) {
        VPathRenderer_Delegate nativePathRenderer = (VPathRenderer_Delegate)VNativeObject.getDelegate(rendererPtr);
        nativePathRenderer.setRootAlpha(alpha);
        return true;
    }

    @LayoutlibDelegate
    static float nGetRootAlpha(long rendererPtr) {
        VPathRenderer_Delegate nativePathRenderer = (VPathRenderer_Delegate)VNativeObject.getDelegate(rendererPtr);
        return nativePathRenderer.getRootAlpha();
    }

    @LayoutlibDelegate
    static void nSetAllowCaching(long rendererPtr, boolean allowCaching) {
    }

    @LayoutlibDelegate
    static int nDraw(long rendererPtr, long canvasWrapperPtr, long colorFilterPtr, Rect bounds, boolean needsMirroring, boolean canReuseCache) {
        VPathRenderer_Delegate nativePathRenderer = (VPathRenderer_Delegate)VNativeObject.getDelegate(rendererPtr);
        Canvas_Delegate.nSave(canvasWrapperPtr, 3);
        Canvas_Delegate.nTranslate(canvasWrapperPtr, bounds.left, bounds.top);
        if (needsMirroring) {
            Canvas_Delegate.nTranslate(canvasWrapperPtr, bounds.width(), 0.0f);
            Canvas_Delegate.nScale(canvasWrapperPtr, -1.0f, 1.0f);
        }
        bounds.offsetTo(0, 0);
        nativePathRenderer.draw(canvasWrapperPtr, colorFilterPtr, bounds.width(), bounds.height());
        Canvas_Delegate.nRestore(canvasWrapperPtr);
        return bounds.width() * bounds.height();
    }

    @LayoutlibDelegate
    static long nCreateFullPath() {
        return VectorDrawable_Delegate.addNativeObject(new VFullPath_Delegate());
    }

    @LayoutlibDelegate
    static long nCreateFullPath(long nativeFullPathPtr) {
        VFullPath_Delegate original = (VFullPath_Delegate)VNativeObject.getDelegate(nativeFullPathPtr);
        return VectorDrawable_Delegate.addNativeObject(new VFullPath_Delegate(original));
    }

    @LayoutlibDelegate
    static boolean nGetFullPathProperties(long pathPtr, byte[] propertiesData, int length) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        ByteBuffer properties = ByteBuffer.wrap(propertiesData);
        properties.order(ByteOrder.nativeOrder());
        properties.putFloat(0, path.getStrokeWidth());
        properties.putInt(4, path.getStrokeColor());
        properties.putFloat(8, path.getStrokeAlpha());
        properties.putInt(12, path.getFillColor());
        properties.putFloat(16, path.getStrokeAlpha());
        properties.putFloat(20, path.getTrimPathStart());
        properties.putFloat(24, path.getTrimPathEnd());
        properties.putFloat(28, path.getTrimPathOffset());
        properties.putInt(32, path.getStrokeLineCap());
        properties.putInt(36, path.getStrokeLineJoin());
        properties.putFloat(40, path.getStrokeMiterlimit());
        properties.putInt(44, path.getFillType());
        return true;
    }

    @LayoutlibDelegate
    static void nUpdateFullPathProperties(long pathPtr, float strokeWidth, int strokeColor, float strokeAlpha, int fillColor, float fillAlpha, float trimPathStart, float trimPathEnd, float trimPathOffset, float strokeMiterLimit, int strokeLineCap, int strokeLineJoin, int fillType) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        path.setStrokeWidth(strokeWidth);
        path.setStrokeColor(strokeColor);
        path.setStrokeAlpha(strokeAlpha);
        path.setFillColor(fillColor);
        path.setFillAlpha(fillAlpha);
        path.setTrimPathStart(trimPathStart);
        path.setTrimPathEnd(trimPathEnd);
        path.setTrimPathOffset(trimPathOffset);
        path.setStrokeMiterlimit(strokeMiterLimit);
        path.setStrokeLineCap(strokeLineCap);
        path.setStrokeLineJoin(strokeLineJoin);
        path.setFillType(fillType);
    }

    @LayoutlibDelegate
    static void nUpdateFullPathFillGradient(long pathPtr, long fillGradientPtr) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        path.setFillGradient(fillGradientPtr);
    }

    @LayoutlibDelegate
    static void nUpdateFullPathStrokeGradient(long pathPtr, long strokeGradientPtr) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        path.setStrokeGradient(strokeGradientPtr);
    }

    @LayoutlibDelegate
    static long nCreateClipPath() {
        return VectorDrawable_Delegate.addNativeObject(new VClipPath_Delegate());
    }

    @LayoutlibDelegate
    static long nCreateClipPath(long clipPathPtr) {
        VClipPath_Delegate original = (VClipPath_Delegate)VNativeObject.getDelegate(clipPathPtr);
        return VectorDrawable_Delegate.addNativeObject(new VClipPath_Delegate(original));
    }

    @LayoutlibDelegate
    static long nCreateGroup() {
        return VectorDrawable_Delegate.addNativeObject(new VGroup_Delegate());
    }

    @LayoutlibDelegate
    static long nCreateGroup(long groupPtr) {
        VGroup_Delegate original = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        return VectorDrawable_Delegate.addNativeObject(new VGroup_Delegate(original, new ArrayMap()));
    }

    @LayoutlibDelegate
    static void nSetName(long nodePtr, String name) {
        VNativeObject group = (VNativeObject)VNativeObject.getDelegate(nodePtr);
        group.setName(name);
    }

    @LayoutlibDelegate
    static boolean nGetGroupProperties(long groupPtr, float[] propertiesData, int length) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        FloatBuffer properties = FloatBuffer.wrap(propertiesData);
        properties.put(0, group.getRotation());
        properties.put(1, group.getPivotX());
        properties.put(2, group.getPivotY());
        properties.put(3, group.getScaleX());
        properties.put(4, group.getScaleY());
        properties.put(5, group.getTranslateX());
        properties.put(6, group.getTranslateY());
        return true;
    }

    @LayoutlibDelegate
    static void nUpdateGroupProperties(long groupPtr, float rotate, float pivotX, float pivotY, float scaleX, float scaleY, float translateX, float translateY) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        group.setRotation(rotate);
        group.setPivotX(pivotX);
        group.setPivotY(pivotY);
        group.setScaleX(scaleX);
        group.setScaleY(scaleY);
        group.setTranslateX(translateX);
        group.setTranslateY(translateY);
    }

    @LayoutlibDelegate
    static void nAddChild(long groupPtr, long nodePtr) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        group.mChildren.add(VNativeObject.getDelegate(nodePtr));
    }

    @LayoutlibDelegate
    static void nSetPathString(long pathPtr, String pathString, int length) {
        VPath_Delegate path = (VPath_Delegate)VNativeObject.getDelegate(pathPtr);
        path.setPathData(PathParser_Delegate.createNodesFromPathData(pathString));
    }

    @LayoutlibDelegate
    static float nGetRotation(long groupPtr) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        return group.getRotation();
    }

    @LayoutlibDelegate
    static void nSetRotation(long groupPtr, float rotation) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        group.setRotation(rotation);
    }

    @LayoutlibDelegate
    static float nGetPivotX(long groupPtr) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        return group.getPivotX();
    }

    @LayoutlibDelegate
    static void nSetPivotX(long groupPtr, float pivotX) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        group.setPivotX(pivotX);
    }

    @LayoutlibDelegate
    static float nGetPivotY(long groupPtr) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        return group.getPivotY();
    }

    @LayoutlibDelegate
    static void nSetPivotY(long groupPtr, float pivotY) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        group.setPivotY(pivotY);
    }

    @LayoutlibDelegate
    static float nGetScaleX(long groupPtr) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        return group.getScaleX();
    }

    @LayoutlibDelegate
    static void nSetScaleX(long groupPtr, float scaleX) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        group.setScaleX(scaleX);
    }

    @LayoutlibDelegate
    static float nGetScaleY(long groupPtr) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        return group.getScaleY();
    }

    @LayoutlibDelegate
    static void nSetScaleY(long groupPtr, float scaleY) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        group.setScaleY(scaleY);
    }

    @LayoutlibDelegate
    static float nGetTranslateX(long groupPtr) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        return group.getTranslateX();
    }

    @LayoutlibDelegate
    static void nSetTranslateX(long groupPtr, float translateX) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        group.setTranslateX(translateX);
    }

    @LayoutlibDelegate
    static float nGetTranslateY(long groupPtr) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        return group.getTranslateY();
    }

    @LayoutlibDelegate
    static void nSetTranslateY(long groupPtr, float translateY) {
        VGroup_Delegate group = (VGroup_Delegate)VNativeObject.getDelegate(groupPtr);
        group.setTranslateY(translateY);
    }

    @LayoutlibDelegate
    static void nSetPathData(long pathPtr, long pathDataPtr) {
        VPath_Delegate path = (VPath_Delegate)VNativeObject.getDelegate(pathPtr);
        path.setPathData(PathParser_Delegate.getDelegate(pathDataPtr).getPathDataNodes());
    }

    @LayoutlibDelegate
    static float nGetStrokeWidth(long pathPtr) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        return path.getStrokeWidth();
    }

    @LayoutlibDelegate
    static void nSetStrokeWidth(long pathPtr, float width) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        path.setStrokeWidth(width);
    }

    @LayoutlibDelegate
    static int nGetStrokeColor(long pathPtr) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        return path.getStrokeColor();
    }

    @LayoutlibDelegate
    static void nSetStrokeColor(long pathPtr, int strokeColor) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        path.setStrokeColor(strokeColor);
    }

    @LayoutlibDelegate
    static float nGetStrokeAlpha(long pathPtr) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        return path.getStrokeAlpha();
    }

    @LayoutlibDelegate
    static void nSetStrokeAlpha(long pathPtr, float alpha) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        path.setStrokeAlpha(alpha);
    }

    @LayoutlibDelegate
    static int nGetFillColor(long pathPtr) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        return path.getFillColor();
    }

    @LayoutlibDelegate
    static void nSetFillColor(long pathPtr, int fillColor) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        path.setFillColor(fillColor);
    }

    @LayoutlibDelegate
    static float nGetFillAlpha(long pathPtr) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        return path.getFillAlpha();
    }

    @LayoutlibDelegate
    static void nSetFillAlpha(long pathPtr, float fillAlpha) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        path.setFillAlpha(fillAlpha);
    }

    @LayoutlibDelegate
    static float nGetTrimPathStart(long pathPtr) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        return path.getTrimPathStart();
    }

    @LayoutlibDelegate
    static void nSetTrimPathStart(long pathPtr, float trimPathStart) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        path.setTrimPathStart(trimPathStart);
    }

    @LayoutlibDelegate
    static float nGetTrimPathEnd(long pathPtr) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        return path.getTrimPathEnd();
    }

    @LayoutlibDelegate
    static void nSetTrimPathEnd(long pathPtr, float trimPathEnd) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        path.setTrimPathEnd(trimPathEnd);
    }

    @LayoutlibDelegate
    static float nGetTrimPathOffset(long pathPtr) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        return path.getTrimPathOffset();
    }

    @LayoutlibDelegate
    static void nSetTrimPathOffset(long pathPtr, float trimPathOffset) {
        VFullPath_Delegate path = (VFullPath_Delegate)VNativeObject.getDelegate(pathPtr);
        path.setTrimPathOffset(trimPathOffset);
    }

    static class VPathRenderer_Delegate
    extends VNativeObject {
        private final Path mPath;
        private final Path mRenderPath;
        private final Matrix mFinalPathMatrix = new Matrix();
        private final long mRootGroupPtr;
        private float mViewportWidth = 0.0f;
        private float mViewportHeight = 0.0f;
        private float mRootAlpha = 1.0f;
        private Paint mStrokePaint;
        private Paint mFillPaint;
        private PathMeasure mPathMeasure;

        private VPathRenderer_Delegate(long rootGroupPtr) {
            this.mRootGroupPtr = rootGroupPtr;
            this.mPath = new Path();
            this.mRenderPath = new Path();
        }

        private VPathRenderer_Delegate(VPathRenderer_Delegate rendererToCopy, long rootGroupPtr) {
            this(rootGroupPtr);
            this.mViewportWidth = rendererToCopy.mViewportWidth;
            this.mViewportHeight = rendererToCopy.mViewportHeight;
            this.mRootAlpha = rendererToCopy.mRootAlpha;
        }

        private float getRootAlpha() {
            return this.mRootAlpha;
        }

        void setRootAlpha(float alpha) {
            this.mRootAlpha = alpha;
        }

        private void drawGroupTree(VGroup_Delegate currentGroup, Matrix currentMatrix, long canvasPtr, int w, int h, long filterPtr) {
            currentGroup.mStackedMatrix.set(currentMatrix);
            currentGroup.mStackedMatrix.preConcat(currentGroup.mLocalMatrix);
            Canvas_Delegate.nSave(canvasPtr, 3);
            for (int i = 0; i < currentGroup.mChildren.size(); ++i) {
                Object child = currentGroup.mChildren.get(i);
                if (child instanceof VGroup_Delegate) {
                    VGroup_Delegate childGroup = (VGroup_Delegate)child;
                    this.drawGroupTree(childGroup, currentGroup.mStackedMatrix, canvasPtr, w, h, filterPtr);
                    continue;
                }
                if (!(child instanceof VPath_Delegate)) continue;
                VPath_Delegate childPath = (VPath_Delegate)child;
                this.drawPath(currentGroup, childPath, canvasPtr, w, h, filterPtr);
            }
            Canvas_Delegate.nRestore(canvasPtr);
        }

        public void draw(long canvasPtr, long filterPtr, int w, int h) {
            this.drawGroupTree((VGroup_Delegate)VNativeObject.getDelegate(this.mRootGroupPtr), Matrix.IDENTITY_MATRIX, canvasPtr, w, h, filterPtr);
        }

        private void drawPath(VGroup_Delegate VGroup2, VPath_Delegate VPath2, long canvasPtr, int w, int h, long filterPtr) {
            float scaleX = (float)w / this.mViewportWidth;
            float scaleY = (float)h / this.mViewportHeight;
            float minScale = Math.min(scaleX, scaleY);
            Matrix groupStackedMatrix = VGroup2.mStackedMatrix;
            this.mFinalPathMatrix.set(groupStackedMatrix);
            this.mFinalPathMatrix.postScale(scaleX, scaleY);
            float matrixScale = this.getMatrixScale(groupStackedMatrix);
            if (matrixScale == 0.0f) {
                return;
            }
            VPath2.toPath(this.mPath);
            Path path = this.mPath;
            this.mRenderPath.reset();
            if (VPath2.isClipPath()) {
                this.mRenderPath.addPath(path, this.mFinalPathMatrix);
                Canvas_Delegate.nClipPath(canvasPtr, this.mRenderPath.mNativePath, Region.Op.INTERSECT.nativeInt);
            } else {
                VFullPath_Delegate fullPath = (VFullPath_Delegate)VPath2;
                if (fullPath.mTrimPathStart != 0.0f || fullPath.mTrimPathEnd != 1.0f) {
                    float start = (fullPath.mTrimPathStart + fullPath.mTrimPathOffset) % 1.0f;
                    float end = (fullPath.mTrimPathEnd + fullPath.mTrimPathOffset) % 1.0f;
                    if (this.mPathMeasure == null) {
                        this.mPathMeasure = new PathMeasure();
                    }
                    this.mPathMeasure.setPath(this.mPath, false);
                    float len = this.mPathMeasure.getLength();
                    start *= len;
                    end *= len;
                    path.reset();
                    if (start > end) {
                        this.mPathMeasure.getSegment(start, len, path, true);
                        this.mPathMeasure.getSegment(0.0f, end, path, true);
                    } else {
                        this.mPathMeasure.getSegment(start, end, path, true);
                    }
                    path.rLineTo(0.0f, 0.0f);
                }
                this.mRenderPath.addPath(path, this.mFinalPathMatrix);
                if (fullPath.mFillColor != 0) {
                    if (this.mFillPaint == null) {
                        this.mFillPaint = new Paint();
                        this.mFillPaint.setStyle(Paint.Style.FILL);
                        this.mFillPaint.setAntiAlias(true);
                    }
                    Paint fillPaint = this.mFillPaint;
                    fillPaint.setColor(VectorDrawable_Delegate.applyAlpha(VectorDrawable_Delegate.applyAlpha(fullPath.mFillColor, fullPath.mFillAlpha), this.getRootAlpha()));
                    Paint_Delegate fillPaintDelegate = Paint_Delegate.getDelegate(fillPaint.getNativeInstance());
                    assert (fillPaintDelegate != null);
                    fillPaintDelegate.setColorFilter(filterPtr);
                    Shader_Delegate shaderDelegate = Shader_Delegate.getDelegate(fullPath.mFillGradient);
                    if (shaderDelegate != null) {
                        shaderDelegate.setLocalMatrix(this.mFinalPathMatrix.native_instance);
                    }
                    fillPaintDelegate.setShader(fullPath.mFillGradient);
                    Path_Delegate.nSetFillType(this.mRenderPath.mNativePath, fullPath.mFillType);
                    BaseCanvas_Delegate.nDrawPath(canvasPtr, this.mRenderPath.mNativePath, fillPaint.getNativeInstance());
                    if (shaderDelegate != null) {
                        shaderDelegate.setLocalMatrix(0L);
                    }
                }
                if (fullPath.mStrokeColor != 0) {
                    if (this.mStrokePaint == null) {
                        this.mStrokePaint = new Paint();
                        this.mStrokePaint.setStyle(Paint.Style.STROKE);
                        this.mStrokePaint.setAntiAlias(true);
                    }
                    Paint strokePaint = this.mStrokePaint;
                    if (fullPath.mStrokeLineJoin != null) {
                        strokePaint.setStrokeJoin(fullPath.mStrokeLineJoin);
                    }
                    if (fullPath.mStrokeLineCap != null) {
                        strokePaint.setStrokeCap(fullPath.mStrokeLineCap);
                    }
                    strokePaint.setStrokeMiter(fullPath.mStrokeMiterlimit);
                    strokePaint.setColor(VectorDrawable_Delegate.applyAlpha(VectorDrawable_Delegate.applyAlpha(fullPath.mStrokeColor, fullPath.mStrokeAlpha), this.getRootAlpha()));
                    Paint_Delegate strokePaintDelegate = Paint_Delegate.getDelegate(strokePaint.getNativeInstance());
                    assert (strokePaintDelegate != null);
                    strokePaintDelegate.setColorFilter(filterPtr);
                    float finalStrokeScale = minScale * matrixScale;
                    strokePaint.setStrokeWidth(fullPath.mStrokeWidth * finalStrokeScale);
                    strokePaintDelegate.setShader(fullPath.mStrokeGradient);
                    BaseCanvas_Delegate.nDrawPath(canvasPtr, this.mRenderPath.mNativePath, strokePaint.getNativeInstance());
                }
            }
        }

        private float getMatrixScale(Matrix groupStackedMatrix) {
            float[] unitVectors = new float[]{0.0f, 1.0f, 1.0f, 0.0f};
            groupStackedMatrix.mapVectors(unitVectors);
            float scaleX = MathUtils.mag(unitVectors[0], unitVectors[1]);
            float scaleY = MathUtils.mag(unitVectors[2], unitVectors[3]);
            float crossProduct = MathUtils.cross(unitVectors[0], unitVectors[1], unitVectors[2], unitVectors[3]);
            float maxScale = MathUtils.max(scaleX, scaleY);
            float matrixScale = 0.0f;
            if (maxScale > 0.0f) {
                matrixScale = MathUtils.abs(crossProduct) / maxScale;
            }
            return matrixScale;
        }

        @Override
        public void setName(String name) {
        }

        protected void finalize() throws Throwable {
            VNativeObject nativeObject = (VNativeObject)sPathManager.getDelegate(this.mRootGroupPtr);
            sPathManager.removeJavaReferenceFor(this.mRootGroupPtr);
            assert (nativeObject != null);
            nativeObject.dispose();
            super.finalize();
        }
    }

    public static class VPath_Delegate
    extends VNativeObject {
        protected PathParser_Delegate.PathDataNode[] mNodes = null;
        String mPathName;
        int mChangingConfigurations;

        public VPath_Delegate() {
        }

        public VPath_Delegate(VPath_Delegate copy) {
            this.mPathName = copy.mPathName;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            this.mNodes = copy.mNodes != null ? PathParser_Delegate.deepCopyNodes(copy.mNodes) : null;
        }

        public void toPath(Path path) {
            path.reset();
            if (this.mNodes != null) {
                PathParser_Delegate.PathDataNode.nodesToPath(this.mNodes, Path_Delegate.getDelegate(path.mNativePath));
            }
        }

        @Override
        public void setName(String name) {
            this.mPathName = name;
        }

        public boolean isClipPath() {
            return false;
        }

        private void setPathData(PathParser_Delegate.PathDataNode[] nodes) {
            if (!PathParser_Delegate.canMorph(this.mNodes, nodes)) {
                this.mNodes = PathParser_Delegate.deepCopyNodes(nodes);
            } else {
                PathParser_Delegate.updateNodes(this.mNodes, nodes);
            }
        }

        @Override
        void dispose() {
            this.mNodes = null;
        }
    }

    static class VGroup_Delegate
    extends VNativeObject {
        private static final int ROTATE_INDEX = 0;
        private static final int PIVOT_X_INDEX = 1;
        private static final int PIVOT_Y_INDEX = 2;
        private static final int SCALE_X_INDEX = 3;
        private static final int SCALE_Y_INDEX = 4;
        private static final int TRANSLATE_X_INDEX = 5;
        private static final int TRANSLATE_Y_INDEX = 6;
        final ArrayList<Object> mChildren = new ArrayList();
        private final Matrix mStackedMatrix = new Matrix();
        private final Matrix mLocalMatrix = new Matrix();
        private float mRotate = 0.0f;
        private float mPivotX = 0.0f;
        private float mPivotY = 0.0f;
        private float mScaleX = 1.0f;
        private float mScaleY = 1.0f;
        private float mTranslateX = 0.0f;
        private float mTranslateY = 0.0f;
        private int mChangingConfigurations;
        private String mGroupName = null;

        public Consumer<Float> getPropertySetter(int propertyIdx) {
            switch (propertyIdx) {
                case 0: {
                    return this::setRotation;
                }
                case 1: {
                    return this::setPivotX;
                }
                case 2: {
                    return this::setPivotY;
                }
                case 3: {
                    return this::setScaleX;
                }
                case 4: {
                    return this::setScaleY;
                }
                case 5: {
                    return this::setTranslateX;
                }
                case 6: {
                    return this::setTranslateY;
                }
            }
            assert (false) : "Invalid VGroup_Delegate property index " + propertyIdx;
            return t -> {};
        }

        private VGroup_Delegate(VGroup_Delegate copy, ArrayMap<String, Object> targetsMap) {
            this.mRotate = copy.mRotate;
            this.mPivotX = copy.mPivotX;
            this.mPivotY = copy.mPivotY;
            this.mScaleX = copy.mScaleX;
            this.mScaleY = copy.mScaleY;
            this.mTranslateX = copy.mTranslateX;
            this.mTranslateY = copy.mTranslateY;
            this.mGroupName = copy.mGroupName;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            if (this.mGroupName != null) {
                targetsMap.put(this.mGroupName, this);
            }
            this.mLocalMatrix.set(copy.mLocalMatrix);
        }

        private VGroup_Delegate() {
        }

        private void updateLocalMatrix() {
            this.mLocalMatrix.reset();
            this.mLocalMatrix.postTranslate(-this.mPivotX, -this.mPivotY);
            this.mLocalMatrix.postScale(this.mScaleX, this.mScaleY);
            this.mLocalMatrix.postRotate(this.mRotate, 0.0f, 0.0f);
            this.mLocalMatrix.postTranslate(this.mTranslateX + this.mPivotX, this.mTranslateY + this.mPivotY);
        }

        private float getRotation() {
            return this.mRotate;
        }

        private void setRotation(float rotation) {
            if (rotation != this.mRotate) {
                this.mRotate = rotation;
                this.updateLocalMatrix();
            }
        }

        private float getPivotX() {
            return this.mPivotX;
        }

        private void setPivotX(float pivotX) {
            if (pivotX != this.mPivotX) {
                this.mPivotX = pivotX;
                this.updateLocalMatrix();
            }
        }

        private float getPivotY() {
            return this.mPivotY;
        }

        private void setPivotY(float pivotY) {
            if (pivotY != this.mPivotY) {
                this.mPivotY = pivotY;
                this.updateLocalMatrix();
            }
        }

        private float getScaleX() {
            return this.mScaleX;
        }

        private void setScaleX(float scaleX) {
            if (scaleX != this.mScaleX) {
                this.mScaleX = scaleX;
                this.updateLocalMatrix();
            }
        }

        private float getScaleY() {
            return this.mScaleY;
        }

        private void setScaleY(float scaleY) {
            if (scaleY != this.mScaleY) {
                this.mScaleY = scaleY;
                this.updateLocalMatrix();
            }
        }

        private float getTranslateX() {
            return this.mTranslateX;
        }

        private void setTranslateX(float translateX) {
            if (translateX != this.mTranslateX) {
                this.mTranslateX = translateX;
                this.updateLocalMatrix();
            }
        }

        private float getTranslateY() {
            return this.mTranslateY;
        }

        private void setTranslateY(float translateY) {
            if (translateY != this.mTranslateY) {
                this.mTranslateY = translateY;
                this.updateLocalMatrix();
            }
        }

        @Override
        public void setName(String name) {
            this.mGroupName = name;
        }

        @Override
        protected void dispose() {
            this.mChildren.stream().filter(child -> child instanceof VNativeObject).forEach(child -> {
                VNativeObject nativeObject = (VNativeObject)child;
                if (nativeObject.mNativePtr != 0L) {
                    sPathManager.removeJavaReferenceFor(nativeObject.mNativePtr);
                    nativeObject.mNativePtr = 0L;
                }
                nativeObject.dispose();
            });
            this.mChildren.clear();
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }
    }

    static class VFullPath_Delegate
    extends VPath_Delegate {
        private static final int STROKE_WIDTH_INDEX = 0;
        private static final int STROKE_COLOR_INDEX = 1;
        private static final int STROKE_ALPHA_INDEX = 2;
        private static final int FILL_COLOR_INDEX = 3;
        private static final int FILL_ALPHA_INDEX = 4;
        private static final int TRIM_PATH_START_INDEX = 5;
        private static final int TRIM_PATH_END_INDEX = 6;
        private static final int TRIM_PATH_OFFSET_INDEX = 7;
        private static final int STROKE_LINE_CAP_INDEX = 8;
        private static final int STROKE_LINE_JOIN_INDEX = 9;
        private static final int STROKE_MITER_LIMIT_INDEX = 10;
        private static final int FILL_TYPE_INDEX = 11;
        private static final int LINECAP_BUTT = 0;
        private static final int LINECAP_ROUND = 1;
        private static final int LINECAP_SQUARE = 2;
        private static final int LINEJOIN_MITER = 0;
        private static final int LINEJOIN_ROUND = 1;
        private static final int LINEJOIN_BEVEL = 2;
        int mStrokeColor = 0;
        float mStrokeWidth = 0.0f;
        int mFillColor = 0;
        long mStrokeGradient = 0L;
        long mFillGradient = 0L;
        float mStrokeAlpha = 1.0f;
        float mFillAlpha = 1.0f;
        float mTrimPathStart = 0.0f;
        float mTrimPathEnd = 1.0f;
        float mTrimPathOffset = 0.0f;
        Paint.Cap mStrokeLineCap = Paint.Cap.BUTT;
        Paint.Join mStrokeLineJoin = Paint.Join.MITER;
        float mStrokeMiterlimit = 4.0f;
        int mFillType = 0;

        public Consumer<Float> getFloatPropertySetter(int propertyIdx) {
            switch (propertyIdx) {
                case 0: {
                    return this::setStrokeWidth;
                }
                case 2: {
                    return this::setStrokeAlpha;
                }
                case 4: {
                    return this::setFillAlpha;
                }
                case 5: {
                    return this::setTrimPathStart;
                }
                case 6: {
                    return this::setTrimPathEnd;
                }
                case 7: {
                    return this::setTrimPathOffset;
                }
            }
            assert (false) : "Invalid VFullPath_Delegate property index " + propertyIdx;
            return t -> {};
        }

        public Consumer<Integer> getIntPropertySetter(int propertyIdx) {
            switch (propertyIdx) {
                case 1: {
                    return this::setStrokeColor;
                }
                case 3: {
                    return this::setFillColor;
                }
            }
            assert (false) : "Invalid VFullPath_Delegate property index " + propertyIdx;
            return t -> {};
        }

        private VFullPath_Delegate() {
        }

        private VFullPath_Delegate(VFullPath_Delegate copy) {
            super(copy);
            this.mStrokeColor = copy.mStrokeColor;
            this.mStrokeWidth = copy.mStrokeWidth;
            this.mStrokeAlpha = copy.mStrokeAlpha;
            this.mFillColor = copy.mFillColor;
            this.mFillAlpha = copy.mFillAlpha;
            this.mTrimPathStart = copy.mTrimPathStart;
            this.mTrimPathEnd = copy.mTrimPathEnd;
            this.mTrimPathOffset = copy.mTrimPathOffset;
            this.mStrokeLineCap = copy.mStrokeLineCap;
            this.mStrokeLineJoin = copy.mStrokeLineJoin;
            this.mStrokeMiterlimit = copy.mStrokeMiterlimit;
            this.mStrokeGradient = copy.mStrokeGradient;
            this.mFillGradient = copy.mFillGradient;
            this.mFillType = copy.mFillType;
        }

        private int getStrokeLineCap() {
            switch (this.mStrokeLineCap) {
                case BUTT: {
                    return 0;
                }
                case ROUND: {
                    return 1;
                }
                case SQUARE: {
                    return 2;
                }
            }
            assert (false);
            return -1;
        }

        private void setStrokeLineCap(int cap) {
            switch (cap) {
                case 0: {
                    this.mStrokeLineCap = Paint.Cap.BUTT;
                    break;
                }
                case 1: {
                    this.mStrokeLineCap = Paint.Cap.ROUND;
                    break;
                }
                case 2: {
                    this.mStrokeLineCap = Paint.Cap.SQUARE;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private int getStrokeLineJoin() {
            switch (this.mStrokeLineJoin) {
                case MITER: {
                    return 0;
                }
                case ROUND: {
                    return 1;
                }
                case BEVEL: {
                    return 2;
                }
            }
            assert (false);
            return -1;
        }

        private void setStrokeLineJoin(int join) {
            switch (join) {
                case 2: {
                    this.mStrokeLineJoin = Paint.Join.BEVEL;
                    break;
                }
                case 0: {
                    this.mStrokeLineJoin = Paint.Join.MITER;
                    break;
                }
                case 1: {
                    this.mStrokeLineJoin = Paint.Join.ROUND;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private int getStrokeColor() {
            return this.mStrokeColor;
        }

        private void setStrokeColor(int strokeColor) {
            this.mStrokeColor = strokeColor;
        }

        private float getStrokeWidth() {
            return this.mStrokeWidth;
        }

        private void setStrokeWidth(float strokeWidth) {
            this.mStrokeWidth = strokeWidth;
        }

        private float getStrokeAlpha() {
            return this.mStrokeAlpha;
        }

        private void setStrokeAlpha(float strokeAlpha) {
            this.mStrokeAlpha = strokeAlpha;
        }

        private int getFillColor() {
            return this.mFillColor;
        }

        private void setFillColor(int fillColor) {
            this.mFillColor = fillColor;
        }

        private float getFillAlpha() {
            return this.mFillAlpha;
        }

        private void setFillAlpha(float fillAlpha) {
            this.mFillAlpha = fillAlpha;
        }

        private float getTrimPathStart() {
            return this.mTrimPathStart;
        }

        private void setTrimPathStart(float trimPathStart) {
            this.mTrimPathStart = trimPathStart;
        }

        private float getTrimPathEnd() {
            return this.mTrimPathEnd;
        }

        private void setTrimPathEnd(float trimPathEnd) {
            this.mTrimPathEnd = trimPathEnd;
        }

        private float getTrimPathOffset() {
            return this.mTrimPathOffset;
        }

        private void setTrimPathOffset(float trimPathOffset) {
            this.mTrimPathOffset = trimPathOffset;
        }

        private void setStrokeMiterlimit(float limit) {
            this.mStrokeMiterlimit = limit;
        }

        private float getStrokeMiterlimit() {
            return this.mStrokeMiterlimit;
        }

        private void setStrokeGradient(long gradientPtr) {
            this.mStrokeGradient = gradientPtr;
        }

        private void setFillGradient(long gradientPtr) {
            this.mFillGradient = gradientPtr;
        }

        private void setFillType(int fillType) {
            this.mFillType = fillType;
        }

        private int getFillType() {
            return this.mFillType;
        }
    }

    private static class VClipPath_Delegate
    extends VPath_Delegate {
        private VClipPath_Delegate() {
        }

        private VClipPath_Delegate(VClipPath_Delegate copy) {
            super(copy);
        }

        @Override
        public boolean isClipPath() {
            return true;
        }
    }

    static abstract class VNativeObject {
        long mNativePtr = 0L;

        VNativeObject() {
        }

        static <T> T getDelegate(long nativePtr) {
            Object vNativeObject = sPathManager.getDelegate(nativePtr);
            assert (vNativeObject != null);
            return vNativeObject;
        }

        abstract void setName(String var1);

        void setNativePtr(long nativePtr) {
            this.mNativePtr = nativePtr;
        }

        void dispose() {
        }
    }
}

