/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number.rounders;

import android.icu.impl.number.FormatQuantity;
import android.icu.impl.number.Properties;
import android.icu.impl.number.Rounder;
import java.math.BigDecimal;

public class IncrementRounder
extends Rounder {
    private final BigDecimal roundingIncrement;

    public static boolean useRoundingIncrement(IProperties properties) {
        return properties.getRoundingIncrement() != IProperties.DEFAULT_ROUNDING_INCREMENT;
    }

    public static IncrementRounder getInstance(IProperties properties) {
        return new IncrementRounder(properties);
    }

    private IncrementRounder(IProperties properties) {
        super(properties);
        if (properties.getRoundingIncrement().compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("Rounding interval must be greater than zero");
        }
        this.roundingIncrement = properties.getRoundingIncrement();
    }

    @Override
    public void apply(FormatQuantity input) {
        input.roundToIncrement(this.roundingIncrement, this.mathContext);
        this.applyDefaults(input);
    }

    @Override
    public void export(Properties properties) {
        super.export(properties);
        properties.setRoundingIncrement(this.roundingIncrement);
    }

    public static interface IProperties
    extends Rounder.IBasicRoundingProperties {
        public static final BigDecimal DEFAULT_ROUNDING_INCREMENT = null;

        public BigDecimal getRoundingIncrement();

        public IProperties setRoundingIncrement(BigDecimal var1);
    }
}

