/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number.rounders;

import android.icu.impl.number.FormatQuantity;
import android.icu.impl.number.Properties;
import android.icu.impl.number.Rounder;
import android.icu.text.DecimalFormat;

public class SignificantDigitsRounder
extends Rounder {
    private final int minSig;
    private final int maxSig;
    private final DecimalFormat.SignificantDigitsMode mode;

    public static boolean useSignificantDigits(IProperties properties) {
        return properties.getMinimumSignificantDigits() != -1 || properties.getMaximumSignificantDigits() != -1 || properties.getSignificantDigitsMode() != IProperties.DEFAULT_SIGNIFICANT_DIGITS_MODE;
    }

    public static SignificantDigitsRounder getInstance(IProperties properties) {
        return new SignificantDigitsRounder(properties);
    }

    private SignificantDigitsRounder(IProperties properties) {
        super(properties);
        int _minSig = properties.getMinimumSignificantDigits();
        int _maxSig = properties.getMaximumSignificantDigits();
        int n = _minSig < 1 ? 1 : (this.minSig = _minSig > 1000 ? 1000 : _minSig);
        this.maxSig = _maxSig < 0 ? 1000 : (_maxSig < this.minSig ? this.minSig : (_maxSig > 1000 ? 1000 : _maxSig));
        DecimalFormat.SignificantDigitsMode _mode = properties.getSignificantDigitsMode();
        this.mode = _mode == null ? DecimalFormat.SignificantDigitsMode.OVERRIDE_MAXIMUM_FRACTION : _mode;
    }

    @Override
    public void apply(FormatQuantity input) {
        int roundingMagnitude;
        int magnitude = input.isZero() ? this.minInt - 1 : input.getMagnitude();
        int effectiveMag = Math.min(magnitude + 1, this.maxInt);
        int magMinSig = effectiveMag - this.minSig;
        int magMaxSig = effectiveMag - this.maxSig;
        switch (this.mode) {
            case OVERRIDE_MAXIMUM_FRACTION: {
                roundingMagnitude = magMaxSig;
                break;
            }
            case RESPECT_MAXIMUM_FRACTION: {
                roundingMagnitude = Math.max(-this.maxFrac, magMaxSig);
                break;
            }
            case ENSURE_MINIMUM_SIGNIFICANT: {
                roundingMagnitude = Math.min(magMinSig, Math.max(-this.maxFrac, magMaxSig));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        input.roundToMagnitude(roundingMagnitude, this.mathContext);
        magnitude = input.isZero() ? this.minInt - 1 : input.getMagnitude();
        effectiveMag = Math.min(magnitude + 1, this.maxInt);
        magMinSig = effectiveMag - this.minSig;
        magMaxSig = effectiveMag - this.maxSig;
        switch (this.mode) {
            case OVERRIDE_MAXIMUM_FRACTION: {
                input.setIntegerFractionLength(this.minInt, this.maxInt, Math.max(this.minFrac, -magMinSig), Integer.MAX_VALUE);
                break;
            }
            case RESPECT_MAXIMUM_FRACTION: {
                input.setIntegerFractionLength(this.minInt, this.maxInt, Math.min(this.maxFrac, Math.max(this.minFrac, -magMinSig)), this.maxFrac);
                break;
            }
            case ENSURE_MINIMUM_SIGNIFICANT: {
                input.setIntegerFractionLength(this.minInt, this.maxInt, this.minFrac, Integer.MAX_VALUE);
            }
        }
    }

    @Override
    public void export(Properties properties) {
        super.export(properties);
        properties.setMinimumSignificantDigits(this.minSig);
        properties.setMaximumSignificantDigits(this.maxSig);
        properties.setSignificantDigitsMode(this.mode);
    }

    public static interface IProperties
    extends Rounder.IBasicRoundingProperties {
        public static final int DEFAULT_MINIMUM_SIGNIFICANT_DIGITS = -1;
        public static final int DEFAULT_MAXIMUM_SIGNIFICANT_DIGITS = -1;
        public static final DecimalFormat.SignificantDigitsMode DEFAULT_SIGNIFICANT_DIGITS_MODE = null;

        public int getMinimumSignificantDigits();

        public IProperties setMinimumSignificantDigits(int var1);

        public int getMaximumSignificantDigits();

        public IProperties setMaximumSignificantDigits(int var1);

        public DecimalFormat.SignificantDigitsMode getSignificantDigitsMode();

        public IProperties setSignificantDigitsMode(DecimalFormat.SignificantDigitsMode var1);
    }
}

