/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.media.Cea608CCParser;
import android.media.ClosedCaptionWidget;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.CaptioningManager;
import android.widget.LinearLayout;
import android.widget.TextView;

class Cea608CCWidget
extends ClosedCaptionWidget
implements Cea608CCParser.DisplayListener {
    private static final Rect mTextBounds = new Rect();
    private static final String mDummyText = "1234567890123456789012345678901234";

    public Cea608CCWidget(Context context) {
        this(context, null);
    }

    public Cea608CCWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Cea608CCWidget(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0);
    }

    public Cea608CCWidget(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public ClosedCaptionWidget.ClosedCaptionLayout createCaptionLayout(Context context) {
        return new CCLayout(context);
    }

    @Override
    public void onDisplayChanged(SpannableStringBuilder[] styledTexts) {
        ((CCLayout)this.mClosedCaptionLayout).update(styledTexts);
        if (this.mListener != null) {
            this.mListener.onChanged(this);
        }
    }

    @Override
    public CaptioningManager.CaptionStyle getCaptionStyle() {
        return this.mCaptionStyle;
    }

    private static class CCLayout
    extends LinearLayout
    implements ClosedCaptionWidget.ClosedCaptionLayout {
        private static final int MAX_ROWS = 15;
        private static final float SAFE_AREA_RATIO = 0.9f;
        private final CCLineBox[] mLineBoxes = new CCLineBox[15];

        CCLayout(Context context) {
            super(context);
            this.setGravity(0x800003);
            this.setOrientation(1);
            for (int i = 0; i < 15; ++i) {
                this.mLineBoxes[i] = new CCLineBox(this.getContext());
                this.addView((View)this.mLineBoxes[i], -2, -2);
            }
        }

        @Override
        public void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle) {
            for (int i = 0; i < 15; ++i) {
                this.mLineBoxes[i].setCaptionStyle(captionStyle);
            }
        }

        @Override
        public void setFontScale(float fontScale) {
        }

        void update(SpannableStringBuilder[] textBuffer) {
            for (int i = 0; i < 15; ++i) {
                if (textBuffer[i] != null) {
                    this.mLineBoxes[i].setText(textBuffer[i], TextView.BufferType.SPANNABLE);
                    this.mLineBoxes[i].setVisibility(0);
                    continue;
                }
                this.mLineBoxes[i].setVisibility(4);
            }
        }

        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            int safeWidth = this.getMeasuredWidth();
            int safeHeight = this.getMeasuredHeight();
            if (safeWidth * 3 >= safeHeight * 4) {
                safeWidth = safeHeight * 4 / 3;
            } else {
                safeHeight = safeWidth * 3 / 4;
            }
            safeWidth = (int)((float)safeWidth * 0.9f);
            safeHeight = (int)((float)safeHeight * 0.9f);
            int lineHeight = safeHeight / 15;
            int lineHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(lineHeight, 0x40000000);
            int lineWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(safeWidth, 0x40000000);
            for (int i = 0; i < 15; ++i) {
                this.mLineBoxes[i].measure(lineWidthMeasureSpec, lineHeightMeasureSpec);
            }
        }

        @Override
        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            int safeHeight;
            int safeWidth;
            int viewPortWidth = r - l;
            int viewPortHeight = b - t;
            if (viewPortWidth * 3 >= viewPortHeight * 4) {
                safeWidth = viewPortHeight * 4 / 3;
                safeHeight = viewPortHeight;
            } else {
                safeWidth = viewPortWidth;
                safeHeight = viewPortWidth * 3 / 4;
            }
            safeWidth = (int)((float)safeWidth * 0.9f);
            safeHeight = (int)((float)safeHeight * 0.9f);
            int left = (viewPortWidth - safeWidth) / 2;
            int top = (viewPortHeight - safeHeight) / 2;
            for (int i = 0; i < 15; ++i) {
                this.mLineBoxes[i].layout(left, top + safeHeight * i / 15, left + safeWidth, top + safeHeight * (i + 1) / 15);
            }
        }
    }

    private static class CCLineBox
    extends TextView {
        private static final float FONT_PADDING_RATIO = 0.75f;
        private static final float EDGE_OUTLINE_RATIO = 0.1f;
        private static final float EDGE_SHADOW_RATIO = 0.05f;
        private float mOutlineWidth;
        private float mShadowRadius;
        private float mShadowOffset;
        private int mTextColor = -1;
        private int mBgColor = -16777216;
        private int mEdgeType = 0;
        private int mEdgeColor = 0;

        CCLineBox(Context context) {
            super(context);
            this.setGravity(17);
            this.setBackgroundColor(0);
            this.setTextColor(-1);
            this.setTypeface(Typeface.MONOSPACE);
            this.setVisibility(4);
            Resources res = this.getContext().getResources();
            this.mOutlineWidth = res.getDimensionPixelSize(17105263);
            this.mShadowRadius = res.getDimensionPixelSize(17105265);
            this.mShadowOffset = res.getDimensionPixelSize(17105264);
        }

        void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle) {
            this.mTextColor = captionStyle.foregroundColor;
            this.mBgColor = captionStyle.backgroundColor;
            this.mEdgeType = captionStyle.edgeType;
            this.mEdgeColor = captionStyle.edgeColor;
            this.setTextColor(this.mTextColor);
            if (this.mEdgeType == 2) {
                this.setShadowLayer(this.mShadowRadius, this.mShadowOffset, this.mShadowOffset, this.mEdgeColor);
            } else {
                this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            }
            this.invalidate();
        }

        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            float fontSize = (float)View.MeasureSpec.getSize(heightMeasureSpec) * 0.75f;
            this.setTextSize(0, fontSize);
            this.mOutlineWidth = 0.1f * fontSize + 1.0f;
            this.mShadowOffset = this.mShadowRadius = 0.05f * fontSize + 1.0f;
            this.setScaleX(1.0f);
            this.getPaint().getTextBounds(Cea608CCWidget.mDummyText, 0, Cea608CCWidget.mDummyText.length(), mTextBounds);
            float actualTextWidth = mTextBounds.width();
            float requiredTextWidth = View.MeasureSpec.getSize(widthMeasureSpec);
            this.setScaleX(requiredTextWidth / actualTextWidth);
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }

        @Override
        protected void onDraw(Canvas c) {
            if (this.mEdgeType == -1 || this.mEdgeType == 0 || this.mEdgeType == 2) {
                super.onDraw(c);
                return;
            }
            if (this.mEdgeType == 1) {
                this.drawEdgeOutline(c);
            } else {
                this.drawEdgeRaisedOrDepressed(c);
            }
        }

        private void drawEdgeOutline(Canvas c) {
            TextPaint textPaint = this.getPaint();
            Paint.Style previousStyle = textPaint.getStyle();
            Paint.Join previousJoin = textPaint.getStrokeJoin();
            float previousWidth = textPaint.getStrokeWidth();
            this.setTextColor(this.mEdgeColor);
            textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            textPaint.setStrokeJoin(Paint.Join.ROUND);
            textPaint.setStrokeWidth(this.mOutlineWidth);
            super.onDraw(c);
            this.setTextColor(this.mTextColor);
            textPaint.setStyle(previousStyle);
            textPaint.setStrokeJoin(previousJoin);
            textPaint.setStrokeWidth(previousWidth);
            this.setBackgroundSpans(0);
            super.onDraw(c);
            this.setBackgroundSpans(this.mBgColor);
        }

        private void drawEdgeRaisedOrDepressed(Canvas c) {
            TextPaint textPaint = this.getPaint();
            Paint.Style previousStyle = textPaint.getStyle();
            textPaint.setStyle(Paint.Style.FILL);
            boolean raised = this.mEdgeType == 3;
            int colorUp = raised ? -1 : this.mEdgeColor;
            int colorDown = raised ? this.mEdgeColor : -1;
            float offset = this.mShadowRadius / 2.0f;
            this.setShadowLayer(this.mShadowRadius, -offset, -offset, colorUp);
            super.onDraw(c);
            this.setBackgroundSpans(0);
            this.setShadowLayer(this.mShadowRadius, offset, offset, colorDown);
            super.onDraw(c);
            textPaint.setStyle(previousStyle);
            this.setBackgroundSpans(this.mBgColor);
        }

        private void setBackgroundSpans(int color2) {
            CharSequence text = this.getText();
            if (text instanceof Spannable) {
                Spannable spannable = (Spannable)text;
                Cea608CCParser.MutableBackgroundColorSpan[] bgSpans = spannable.getSpans(0, spannable.length(), Cea608CCParser.MutableBackgroundColorSpan.class);
                for (int i = 0; i < bgSpans.length; ++i) {
                    bgSpans[i].setBackgroundColor(color2);
                }
            }
        }
    }
}

