/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import java.io.PrintWriter;

public class UserHandle
implements Parcelable {
    public static final int PER_USER_RANGE = 100000;
    public static final int USER_ALL = -1;
    public static final UserHandle ALL = new UserHandle(-1);
    public static final int USER_CURRENT = -2;
    public static final UserHandle CURRENT = new UserHandle(-2);
    public static final int USER_CURRENT_OR_SELF = -3;
    public static final UserHandle CURRENT_OR_SELF = new UserHandle(-3);
    public static final int USER_NULL = -10000;
    @Deprecated
    public static final int USER_OWNER = 0;
    @Deprecated
    public static final UserHandle OWNER = new UserHandle(0);
    public static final int USER_SYSTEM = 0;
    public static final int USER_SERIAL_SYSTEM = 0;
    public static final UserHandle SYSTEM = new UserHandle(0);
    public static final boolean MU_ENABLED = true;
    final int mHandle;
    public static final Parcelable.Creator<UserHandle> CREATOR = new Parcelable.Creator<UserHandle>(){

        @Override
        public UserHandle createFromParcel(Parcel in) {
            return new UserHandle(in);
        }

        public UserHandle[] newArray(int size) {
            return new UserHandle[size];
        }
    };

    public static boolean isSameUser(int uid1, int uid2) {
        return UserHandle.getUserId(uid1) == UserHandle.getUserId(uid2);
    }

    public static boolean isSameApp(int uid1, int uid2) {
        return UserHandle.getAppId(uid1) == UserHandle.getAppId(uid2);
    }

    public static boolean isIsolated(int uid) {
        if (uid > 0) {
            int appId = UserHandle.getAppId(uid);
            return appId >= 99000 && appId <= 99999;
        }
        return false;
    }

    public static boolean isApp(int uid) {
        if (uid > 0) {
            int appId = UserHandle.getAppId(uid);
            return appId >= 10000 && appId <= 19999;
        }
        return false;
    }

    public static UserHandle getUserHandleForUid(int uid) {
        return UserHandle.of(UserHandle.getUserId(uid));
    }

    public static int getUserId(int uid) {
        return uid / 100000;
    }

    public static int getCallingUserId() {
        return UserHandle.getUserId(Binder.getCallingUid());
    }

    public static int getCallingAppId() {
        return UserHandle.getAppId(Binder.getCallingUid());
    }

    public static UserHandle of(int userId) {
        return userId == 0 ? SYSTEM : new UserHandle(userId);
    }

    public static int getUid(int userId, int appId) {
        return userId * 100000 + appId % 100000;
    }

    public static int getAppId(int uid) {
        return uid % 100000;
    }

    public static int getUserGid(int userId) {
        return UserHandle.getUid(userId, 9997);
    }

    public static int getSharedAppGid(int id2) {
        return 50000 + id2 % 100000 - 10000;
    }

    public static int getAppIdFromSharedAppGid(int gid) {
        int appId = UserHandle.getAppId(gid) + 10000 - 50000;
        if (appId < 0 || appId >= 50000) {
            return -1;
        }
        return appId;
    }

    public static int getCacheAppGid(int id2) {
        return 20000 + id2 % 100000 - 10000;
    }

    public static void formatUid(StringBuilder sb, int uid) {
        if (uid < 10000) {
            sb.append(uid);
        } else {
            sb.append('u');
            sb.append(UserHandle.getUserId(uid));
            int appId = UserHandle.getAppId(uid);
            if (appId >= 99000 && appId <= 99999) {
                sb.append('i');
                sb.append(appId - 99000);
            } else if (appId >= 10000) {
                sb.append('a');
                sb.append(appId - 10000);
            } else {
                sb.append('s');
                sb.append(appId);
            }
        }
    }

    public static String formatUid(int uid) {
        StringBuilder sb = new StringBuilder();
        UserHandle.formatUid(sb, uid);
        return sb.toString();
    }

    public static void formatUid(PrintWriter pw, int uid) {
        if (uid < 10000) {
            pw.print(uid);
        } else {
            pw.print('u');
            pw.print(UserHandle.getUserId(uid));
            int appId = UserHandle.getAppId(uid);
            if (appId >= 99000 && appId <= 99999) {
                pw.print('i');
                pw.print(appId - 99000);
            } else if (appId >= 10000) {
                pw.print('a');
                pw.print(appId - 10000);
            } else {
                pw.print('s');
                pw.print(appId);
            }
        }
    }

    public static int parseUserArg(String arg) {
        int userId;
        if ("all".equals(arg)) {
            userId = -1;
        } else if ("current".equals(arg) || "cur".equals(arg)) {
            userId = -2;
        } else {
            try {
                userId = Integer.parseInt(arg);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bad user number: " + arg);
            }
        }
        return userId;
    }

    public static int myUserId() {
        return UserHandle.getUserId(Process.myUid());
    }

    @Deprecated
    public boolean isOwner() {
        return this.equals(OWNER);
    }

    public boolean isSystem() {
        return this.equals(SYSTEM);
    }

    public UserHandle(int h) {
        this.mHandle = h;
    }

    public int getIdentifier() {
        return this.mHandle;
    }

    public String toString() {
        return "UserHandle{" + this.mHandle + "}";
    }

    public boolean equals(Object obj) {
        try {
            if (obj != null) {
                UserHandle other = (UserHandle)obj;
                return this.mHandle == other.mHandle;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        return this.mHandle;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mHandle);
    }

    public static void writeToParcel(UserHandle h, Parcel out) {
        if (h != null) {
            h.writeToParcel(out, 0);
        } else {
            out.writeInt(-10000);
        }
    }

    public static UserHandle readFromParcel(Parcel in) {
        int h = in.readInt();
        return h != -10000 ? new UserHandle(h) : null;
    }

    public UserHandle(Parcel in) {
        this.mHandle = in.readInt();
    }
}

