/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.BidiRenderer;
import android.graphics.Paint_Delegate;
import android.graphics.RectF;
import android.icu.text.BreakIterator;
import android.icu.util.ULocale;
import android.text.GreedyLineBreaker;
import android.text.Hyphenator_Delegate;
import android.text.LineBreaker;
import android.text.LineWidth;
import android.text.OptimizingLineBreaker;
import android.text.Primitive;
import android.text.StaticLayout;
import android.text.TabStops;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.Segment;

public class StaticLayout_Delegate {
    private static final char CHAR_SPACE = ' ';
    private static final char CHAR_TAB = '\t';
    private static final char CHAR_NEWLINE = '\n';
    private static final char CHAR_ZWSP = '\u200b';
    private static final DelegateManager<Builder> sBuilderManager = new DelegateManager<Builder>(Builder.class);

    @LayoutlibDelegate
    static long nNewBuilder() {
        return sBuilderManager.addNewDelegate(new Builder());
    }

    @LayoutlibDelegate
    static void nFreeBuilder(long nativeBuilder) {
        sBuilderManager.removeJavaReferenceFor(nativeBuilder);
    }

    @LayoutlibDelegate
    static void nFinishBuilder(long nativeBuilder) {
    }

    @LayoutlibDelegate
    static long nLoadHyphenator(ByteBuffer buf, int offset, int minPrefix, int minSuffix) {
        return Hyphenator_Delegate.loadHyphenator(buf, offset, minPrefix, minSuffix);
    }

    @LayoutlibDelegate
    static void nSetLocales(long nativeBuilder, String locales, long[] nativeHyphenators) {
        Builder builder = sBuilderManager.getDelegate(nativeBuilder);
        if (builder != null) {
            builder.mLocales = locales;
            builder.mNativeHyphenators = nativeHyphenators;
        }
    }

    @LayoutlibDelegate
    static void nSetupParagraph(long nativeBuilder, char[] text, int length, float firstWidth, int firstWidthLineCount, float restWidth, int[] variableTabStops, int defaultTabStop, int breakStrategy, int hyphenationFrequency, boolean isJustified, int[] indents, int intentsOffset) {
        Builder builder = sBuilderManager.getDelegate(nativeBuilder);
        if (builder == null) {
            return;
        }
        builder.mText = text;
        builder.mWidths = new float[length];
        builder.mLineWidth = new LineWidth(firstWidth, firstWidthLineCount, restWidth);
        builder.mTabStopCalculator = new TabStops(variableTabStops, defaultTabStop);
    }

    @LayoutlibDelegate
    static float nAddStyleRun(long nativeBuilder, long nativePaint, int start, int end, boolean isRtl) {
        Builder builder = sBuilderManager.getDelegate(nativeBuilder);
        int bidiFlags = isRtl ? 5 : 4;
        return builder == null ? 0.0f : StaticLayout_Delegate.measureText(nativePaint, builder.mText, start, end - start, builder.mWidths, bidiFlags);
    }

    @LayoutlibDelegate
    static void nAddMeasuredRun(long nativeBuilder, int start, int end, float[] widths) {
        Builder builder = sBuilderManager.getDelegate(nativeBuilder);
        if (builder != null) {
            System.arraycopy(widths, start, builder.mWidths, start, end - start);
        }
    }

    @LayoutlibDelegate
    static void nAddReplacementRun(long nativeBuilder, int start, int end, float width) {
        Builder builder = sBuilderManager.getDelegate(nativeBuilder);
        if (builder == null) {
            return;
        }
        builder.mWidths[start] = width;
        Arrays.fill(builder.mWidths, start + 1, end, 0.0f);
    }

    @LayoutlibDelegate
    static void nGetWidths(long nativeBuilder, float[] floatsArray) {
        Builder builder = sBuilderManager.getDelegate(nativeBuilder);
        if (builder != null) {
            System.arraycopy(builder.mWidths, 0, floatsArray, 0, builder.mWidths.length);
        }
    }

    @LayoutlibDelegate
    static int nComputeLineBreaks(long nativeBuilder, StaticLayout.LineBreaks recycle, int[] recycleBreaks, float[] recycleWidths, float[] recycleAscents, float[] recycleDescents, int[] recycleFlags, int recycleLength) {
        int loc;
        Builder builder = sBuilderManager.getDelegate(nativeBuilder);
        if (builder == null) {
            return 0;
        }
        int length = builder.mWidths.length;
        BreakIterator it = BreakIterator.getLineInstance(new ULocale(builder.mLocales));
        it.setText(new Segment(builder.mText, 0, length));
        ArrayList<Integer> breaks = new ArrayList<Integer>((int)Math.ceil((double)length / 5.0));
        it.first();
        while ((loc = it.next()) != -1) {
            breaks.add(loc);
        }
        List<Primitive> primitives = StaticLayout_Delegate.computePrimitives(builder.mText, builder.mWidths, length, breaks);
        switch (builder.mBreakStrategy) {
            case 0: {
                builder.mLineBreaker = new GreedyLineBreaker(primitives, builder.mLineWidth, builder.mTabStopCalculator);
                break;
            }
            case 1: 
            case 2: {
                builder.mLineBreaker = new OptimizingLineBreaker(primitives, builder.mLineWidth, builder.mTabStopCalculator);
                break;
            }
            default: {
                assert (false) : "Unknown break strategy: " + builder.mBreakStrategy;
                builder.mLineBreaker = new GreedyLineBreaker(primitives, builder.mLineWidth, builder.mTabStopCalculator);
            }
        }
        builder.mLineBreaker.computeBreaks(recycle);
        return recycle.breaks.length;
    }

    private static List<Primitive> computePrimitives(char[] text, float[] widths, int length, List<Integer> breaks) {
        ArrayList<Primitive> primitives = new ArrayList<Primitive>((int)Math.ceil((double)length * 1.833));
        int breaksSize = breaks.size();
        int breakIndex = 0;
        for (int i = 0; i < length; ++i) {
            char c = text[i];
            if (c == ' ' || c == '\u200b') {
                primitives.add(Primitive.PrimitiveType.GLUE.getNewPrimitive(i, widths[i]));
                continue;
            }
            if (c == '\t') {
                primitives.add(Primitive.PrimitiveType.VARIABLE.getNewPrimitive(i));
                continue;
            }
            if (c == '\n') continue;
            while (breakIndex < breaksSize && breaks.get(breakIndex) < i) {
                ++breakIndex;
            }
            if (widths[i] != 0.0f) {
                Primitive p = breakIndex < breaksSize && breaks.get(breakIndex) == i ? Primitive.PrimitiveType.PENALTY.getNewPrimitive(i, 0.0f, 0.0f) : Primitive.PrimitiveType.WORD_BREAK.getNewPrimitive(i, 0.0f);
                primitives.add(p);
            }
            primitives.add(Primitive.PrimitiveType.BOX.getNewPrimitive(i, widths[i]));
        }
        primitives.add(Primitive.PrimitiveType.PENALTY.getNewPrimitive(length, 0.0f, -1.0E7f));
        return primitives;
    }

    private static float measureText(long nativePaint, char[] text, int index, int count, float[] widths, int bidiFlags) {
        Paint_Delegate paint = Paint_Delegate.getDelegate(nativePaint);
        RectF bounds = new BidiRenderer(null, paint, text).renderText(index, index + count, bidiFlags, widths, 0, false);
        return bounds.right - bounds.left;
    }

    private static class Builder {
        String mLocales;
        char[] mText;
        float[] mWidths;
        LineBreaker mLineBreaker;
        long[] mNativeHyphenators;
        int mBreakStrategy;
        LineWidth mLineWidth;
        TabStops mTabStopCalculator;

        private Builder() {
        }
    }
}

