/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Slog;
import android.widget.Toast;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.ChooserActivity;
import com.android.internal.app.ResolverActivity;
import java.util.List;

public class IntentForwarderActivity
extends Activity {
    public static String TAG = "IntentForwarderActivity";
    public static String FORWARD_INTENT_TO_PARENT = "com.android.internal.app.ForwardIntentToParent";
    public static String FORWARD_INTENT_TO_MANAGED_PROFILE = "com.android.internal.app.ForwardIntentToManagedProfile";
    private Injector mInjector;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        int targetUserId;
        int userMessageId;
        super.onCreate(savedInstanceState);
        this.mInjector = this.createInjector();
        Intent intentReceived = this.getIntent();
        String className = intentReceived.getComponent().getClassName();
        if (className.equals(FORWARD_INTENT_TO_PARENT)) {
            userMessageId = 17039901;
            targetUserId = this.getProfileParent();
        } else if (className.equals(FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            userMessageId = 17039902;
            targetUserId = this.getManagedProfile();
        } else {
            Slog.wtf(TAG, IntentForwarderActivity.class.getName() + " cannot be called directly");
            userMessageId = -1;
            targetUserId = -10000;
        }
        if (targetUserId == -10000) {
            this.finish();
            return;
        }
        int callingUserId = this.getUserId();
        Intent newIntent = this.canForward(intentReceived, targetUserId);
        if (newIntent != null) {
            if ("android.intent.action.CHOOSER".equals(newIntent.getAction())) {
                Intent innerIntent = (Intent)newIntent.getParcelableExtra("android.intent.extra.INTENT");
                innerIntent.prepareToLeaveUser(callingUserId);
            } else {
                newIntent.prepareToLeaveUser(callingUserId);
            }
            ResolveInfo ri = this.mInjector.getPackageManager().resolveActivityAsUser(newIntent, 65536, targetUserId);
            boolean shouldShowDisclosure = ri == null || ri.activityInfo == null || !"android".equals(ri.activityInfo.packageName) || !ResolverActivity.class.getName().equals(ri.activityInfo.name) && !ChooserActivity.class.getName().equals(ri.activityInfo.name);
            try {
                this.startActivityAsCaller(newIntent, null, false, targetUserId);
            }
            catch (RuntimeException e) {
                int launchedFromUid = -1;
                String launchedFromPackage = "?";
                try {
                    launchedFromUid = ActivityManager.getService().getLaunchedFromUid(this.getActivityToken());
                    launchedFromPackage = ActivityManager.getService().getLaunchedFromPackage(this.getActivityToken());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                Slog.wtf(TAG, "Unable to launch as UID " + launchedFromUid + " package " + launchedFromPackage + ", while running in " + ActivityThread.currentProcessName(), e);
            }
            if (shouldShowDisclosure) {
                Toast.makeText((Context)this, this.getString(userMessageId), 1).show();
            }
        } else {
            Slog.wtf(TAG, "the intent: " + intentReceived + " cannot be forwarded from user " + callingUserId + " to user " + targetUserId);
        }
        this.finish();
    }

    Intent canForward(Intent incomingIntent, int targetUserId) {
        Intent forwardIntent = new Intent(incomingIntent);
        forwardIntent.addFlags(0x3000000);
        this.sanitizeIntent(forwardIntent);
        Intent intentToCheck = forwardIntent;
        if ("android.intent.action.CHOOSER".equals(forwardIntent.getAction())) {
            if (forwardIntent.hasExtra("android.intent.extra.INITIAL_INTENTS")) {
                Slog.wtf(TAG, "An chooser intent with extra initial intents cannot be forwarded to a different user");
                return null;
            }
            if (forwardIntent.hasExtra("android.intent.extra.REPLACEMENT_EXTRAS")) {
                Slog.wtf(TAG, "A chooser intent with replacement extras cannot be forwarded to a different user");
                return null;
            }
            intentToCheck = (Intent)forwardIntent.getParcelableExtra("android.intent.extra.INTENT");
            if (intentToCheck == null) {
                Slog.wtf(TAG, "Cannot forward a chooser intent with no extra android.intent.extra.INTENT");
                return null;
            }
        }
        if (forwardIntent.getSelector() != null) {
            intentToCheck = forwardIntent.getSelector();
        }
        String resolvedType = intentToCheck.resolveTypeIfNeeded(this.getContentResolver());
        this.sanitizeIntent(intentToCheck);
        try {
            if (this.mInjector.getIPackageManager().canForwardTo(intentToCheck, resolvedType, this.getUserId(), targetUserId)) {
                return forwardIntent;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "PackageManagerService is dead?");
        }
        return null;
    }

    private int getManagedProfile() {
        List<UserInfo> relatedUsers = this.mInjector.getUserManager().getProfiles(UserHandle.myUserId());
        for (UserInfo userInfo : relatedUsers) {
            if (!userInfo.isManagedProfile()) continue;
            return userInfo.id;
        }
        Slog.wtf(TAG, FORWARD_INTENT_TO_MANAGED_PROFILE + " has been called, but there is no managed profile");
        return -10000;
    }

    private int getProfileParent() {
        UserInfo parent = this.mInjector.getUserManager().getProfileParent(UserHandle.myUserId());
        if (parent == null) {
            Slog.wtf(TAG, FORWARD_INTENT_TO_PARENT + " has been called, but there is no parent");
            return -10000;
        }
        return parent.id;
    }

    private void sanitizeIntent(Intent intent) {
        intent.setPackage(null);
        intent.setComponent(null);
    }

    @VisibleForTesting
    protected Injector createInjector() {
        return new InjectorImpl();
    }

    public static interface Injector {
        public IPackageManager getIPackageManager();

        public UserManager getUserManager();

        public PackageManager getPackageManager();
    }

    private class InjectorImpl
    implements Injector {
        private InjectorImpl() {
        }

        @Override
        public IPackageManager getIPackageManager() {
            return AppGlobals.getPackageManager();
        }

        @Override
        public UserManager getUserManager() {
            return IntentForwarderActivity.this.getSystemService(UserManager.class);
        }

        @Override
        public PackageManager getPackageManager() {
            return IntentForwarderActivity.this.getPackageManager();
        }
    }
}

