/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;

public class WifiPowerCalculator
extends PowerCalculator {
    private static final boolean DEBUG = false;
    private static final String TAG = "WifiPowerCalculator";
    private final double mIdleCurrentMa;
    private final double mTxCurrentMa;
    private final double mRxCurrentMa;
    private double mTotalAppPowerDrain = 0.0;
    private long mTotalAppRunningTime = 0L;

    public WifiPowerCalculator(PowerProfile profile) {
        this.mIdleCurrentMa = profile.getAveragePower("wifi.controller.idle");
        this.mTxCurrentMa = profile.getAveragePower("wifi.controller.tx");
        this.mRxCurrentMa = profile.getAveragePower("wifi.controller.rx");
    }

    @Override
    public void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        BatteryStats.ControllerActivityCounter counter = u.getWifiControllerActivity();
        if (counter == null) {
            return;
        }
        long idleTime = counter.getIdleTimeCounter().getCountLocked(statsType);
        long txTime = counter.getTxTimeCounters()[0].getCountLocked(statsType);
        long rxTime = counter.getRxTimeCounter().getCountLocked(statsType);
        app.wifiRunningTimeMs = idleTime + rxTime + txTime;
        this.mTotalAppRunningTime += app.wifiRunningTimeMs;
        app.wifiPowerMah = ((double)idleTime * this.mIdleCurrentMa + (double)txTime * this.mTxCurrentMa + (double)rxTime * this.mRxCurrentMa) / 3600000.0;
        this.mTotalAppPowerDrain += app.wifiPowerMah;
        app.wifiRxPackets = u.getNetworkActivityPackets(2, statsType);
        app.wifiTxPackets = u.getNetworkActivityPackets(3, statsType);
        app.wifiRxBytes = u.getNetworkActivityBytes(2, statsType);
        app.wifiTxBytes = u.getNetworkActivityBytes(3, statsType);
    }

    @Override
    public void calculateRemaining(BatterySipper app, BatteryStats stats, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        BatteryStats.ControllerActivityCounter counter = stats.getWifiControllerActivity();
        long idleTimeMs = counter.getIdleTimeCounter().getCountLocked(statsType);
        long txTimeMs = counter.getTxTimeCounters()[0].getCountLocked(statsType);
        long rxTimeMs = counter.getRxTimeCounter().getCountLocked(statsType);
        app.wifiRunningTimeMs = Math.max(0L, idleTimeMs + rxTimeMs + txTimeMs - this.mTotalAppRunningTime);
        double powerDrainMah = (double)counter.getPowerCounter().getCountLocked(statsType) / 3600000.0;
        if (powerDrainMah == 0.0) {
            powerDrainMah = ((double)idleTimeMs * this.mIdleCurrentMa + (double)txTimeMs * this.mTxCurrentMa + (double)rxTimeMs * this.mRxCurrentMa) / 3600000.0;
        }
        app.wifiPowerMah = Math.max(0.0, powerDrainMah - this.mTotalAppPowerDrain);
    }

    @Override
    public void reset() {
        this.mTotalAppPowerDrain = 0.0;
        this.mTotalAppRunningTime = 0L;
    }
}

