/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ExpandMacroToPathMap
extends PathMacroMap {
    private final Map<String, String> myPlainMap = ContainerUtilRt.newLinkedHashMap();
    private final Map<String, String> myMacroExpands = ContainerUtil.newHashMap();

    public void addMacroExpand(@NotNull String macroName, @NotNull String path) {
        this.myMacroExpands.put(macroName, FileUtil.toSystemIndependentName((String)path));
    }

    public void put(@NotNull String fromText, @NotNull String toText) {
        this.myPlainMap.put(fromText, toText);
    }

    public void putAll(@NotNull ExpandMacroToPathMap another) {
        this.myPlainMap.putAll(another.myPlainMap);
        this.myMacroExpands.putAll(another.myMacroExpands);
    }

    @Override
    public String substitute(String text, boolean caseSensitive) {
        if (text == null) {
            return null;
        }
        if (text.indexOf(36) < 0 && text.indexOf(37) < 0) {
            return text;
        }
        for (Map.Entry<String, String> entry : this.myPlainMap.entrySet()) {
            text = StringUtil.replace((String)text, (String)entry.getKey(), (String)entry.getValue(), (boolean)false);
        }
        for (String macroName : this.myMacroExpands.keySet()) {
            text = ExpandMacroToPathMap.replaceMacro(text, macroName, this.myMacroExpands.get(macroName));
        }
        return text;
    }

    @NotNull
    private static String replaceMacro(@NotNull String text, @NotNull String macroName, @NotNull String replacement) {
        int start;
        while ((start = ExpandMacroToPathMap.findMacroIndex(text, macroName)) >= 0) {
            int end = start + macroName.length() + 2;
            int slashCount = ExpandMacroToPathMap.getSlashCount(text, end);
            String actualReplacement = slashCount > 0 && !replacement.endsWith("/") ? replacement + "/" : replacement;
            text = StringUtil.replaceSubstring((String)text, (TextRange)new TextRange(start, end + slashCount), (String)actualReplacement);
        }
        return text;
    }

    private static int getSlashCount(@NotNull String text, int pos) {
        return StringUtil.isChar((CharSequence)text, (int)pos, (char)'/') ? (StringUtil.isChar((CharSequence)text, (int)(pos + 1), (char)'/') ? 2 : 1) : 0;
    }

    private static int findMacroIndex(@NotNull String text, @NotNull String macroName) {
        int i = -1;
        do {
            if ((i = text.indexOf(36, i + 1)) >= 0) continue;
            return -1;
        } while (!StringUtil.startsWith((CharSequence)text, (int)(i + 1), (CharSequence)macroName) || !StringUtil.isChar((CharSequence)text, (int)(i + macroName.length() + 1), (char)'$'));
        return i;
    }

    @Override
    public int hashCode() {
        return this.myPlainMap.hashCode() + this.myMacroExpands.hashCode();
    }
}

