/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.service.SharedThreadPool;

public class JdkVersionDetectorImpl
extends JdkVersionDetector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.SdkVersionUtil");
    private static final JdkVersionDetector.ActionRunner ACTION_RUNNER = new JdkVersionDetector.ActionRunner(){

        public Future<?> run(Runnable runnable) {
            return SharedThreadPool.getInstance().executeOnPooledThread(runnable);
        }
    };

    @Nullable
    public String detectJdkVersion(@NotNull String homePath) {
        return this.detectJdkVersion(homePath, ACTION_RUNNER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String detectJdkVersion(@NotNull String homePath, @NotNull JdkVersionDetector.ActionRunner runner) {
        JdkVersionDetector.JdkVersionInfo info;
        File rtFile = new File(homePath, "jre/lib/rt.jar");
        if (rtFile.isFile()) {
            try (JarFile rtJar = new JarFile(rtFile, false);){
                String version;
                Manifest manifest = rtJar.getManifest();
                if (manifest != null && (version = manifest.getMainAttributes().getValue("Implementation-Version")) != null) {
                    String string = "java version \"" + version + "\"";
                    return string;
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        if ((info = this.detectJdkVersionInfo(homePath, runner)) == null) return null;
        String string = info.getVersion();
        return string;
    }

    public JdkVersionDetector.JdkVersionInfo detectJdkVersionInfo(@NotNull String homePath) {
        return this.detectJdkVersionInfo(homePath, ACTION_RUNNER);
    }

    public JdkVersionDetector.JdkVersionInfo detectJdkVersionInfo(@NotNull String homePath, @NotNull JdkVersionDetector.ActionRunner runner) {
        String javaExe;
        File releaseFile = new File(homePath, "release");
        if (releaseFile.isFile()) {
            try {
                Properties p = new Properties();
                p.load(new FileInputStream(releaseFile));
                String version = p.getProperty("JAVA_FULL_VERSION", p.getProperty("JAVA_VERSION"));
                if (version != null) {
                    String arch;
                    int i = (version = StringUtil.unquoteString((String)version)).indexOf(43);
                    if (i > 0) {
                        version = version.substring(0, i);
                    }
                    boolean x64 = "x86_64".equals(arch = StringUtil.unquoteString((String)p.getProperty("OS_ARCH", ""))) || "amd64".equals(arch);
                    return new JdkVersionDetector.JdkVersionInfo("java version \"" + version + "\"", x64 ? Bitness.x64 : Bitness.x32);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        if (new File(javaExe = homePath + File.separator + "bin" + File.separator + (SystemInfo.isWindows ? "java.exe" : "java")).canExecute()) {
            try {
                Process process = new ProcessBuilder(javaExe, "-version").redirectErrorStream(true).start();
                VersionOutputReader reader = new VersionOutputReader(process.getInputStream(), runner);
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    LOG.info((Throwable)e);
                    process.destroy();
                }
                return reader.getVersionInfo();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return null;
    }

    private static class VersionOutputReader
    extends BaseOutputReader {
        private static final BaseOutputReader.Options OPTIONS = new BaseOutputReader.Options(){

            public BaseDataReader.SleepingPolicy policy() {
                return BaseDataReader.SleepingPolicy.BLOCKING;
            }

            public boolean splitToLines() {
                return true;
            }

            public boolean sendIncompleteLines() {
                return false;
            }

            public boolean withSeparators() {
                return false;
            }
        };
        private final JdkVersionDetector.ActionRunner myRunner;
        private final List<String> myLines;

        public VersionOutputReader(@NotNull InputStream stream, @NotNull JdkVersionDetector.ActionRunner runner) {
            super(stream, CharsetToolkit.getDefaultSystemCharset(), OPTIONS);
            this.myRunner = runner;
            this.myLines = new CopyOnWriteArrayList<String>();
            this.start("java -version");
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            return this.myRunner.run(runnable);
        }

        protected void onTextAvailable(@NotNull String text) {
            this.myLines.add(text);
        }

        @Nullable
        public JdkVersionDetector.JdkVersionInfo getVersionInfo() {
            String version = null;
            Bitness arch = Bitness.x32;
            for (String line : this.myLines) {
                if (line.contains("version")) {
                    if (version != null) continue;
                    version = line;
                    continue;
                }
                if (!line.contains("64-Bit") && !line.contains("x86_64") && !line.contains("amd64")) continue;
                arch = Bitness.x64;
            }
            return version != null ? new JdkVersionDetector.JdkVersionInfo(version, arch) : null;
        }
    }
}

