/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.service.impl;

import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.plugin.JpsPluginManager;
import org.jetbrains.jps.service.JpsServiceManager;

public class JpsServiceManagerImpl
extends JpsServiceManager {
    private final ConcurrentMap<Class, Object> myServices = new ConcurrentHashMap<Class, Object>(16, 0.75f, 1);
    private final ConcurrentMap<Class, List<?>> myExtensions = new ConcurrentHashMap(16, 0.75f, 1);
    private volatile JpsPluginManager myPluginManager;

    public <T> T getService(Class<T> serviceClass) {
        Object service = this.myServices.get(serviceClass);
        if (service == null) {
            Iterator<T> iterator = ServiceLoader.load(serviceClass, serviceClass.getClassLoader()).iterator();
            if (!iterator.hasNext()) {
                throw new ServiceConfigurationError("Implementation for " + serviceClass + " not found");
            }
            T loadedService = iterator.next();
            if (iterator.hasNext()) {
                throw new ServiceConfigurationError("More than one implementation for " + serviceClass + " found: " + loadedService.getClass() + " and " + iterator.next().getClass());
            }
            service = this.myServices.putIfAbsent(serviceClass, loadedService);
            if (service == null) {
                service = loadedService;
            }
        }
        return (T)service;
    }

    public <T> Iterable<T> getExtensions(Class<T> extensionClass) {
        ArrayList<T> extensions;
        ArrayList<T> cached = (ArrayList<T>)this.myExtensions.get(extensionClass);
        if (cached == null && (cached = (List)this.myExtensions.putIfAbsent(extensionClass, extensions = new ArrayList<T>(this.loadExtensions(extensionClass)))) == null) {
            cached = extensions;
        }
        return cached;
    }

    @NotNull
    private <T> Collection<T> loadExtensions(Class<T> extensionClass) {
        JpsPluginManager pluginManager = this.myPluginManager;
        if (pluginManager == null) {
            Iterator<JpsPluginManager> managers = ServiceLoader.load(JpsPluginManager.class, JpsPluginManager.class.getClassLoader()).iterator();
            if (managers.hasNext()) {
                pluginManager = managers.next();
                if (managers.hasNext()) {
                    throw new ServiceConfigurationError("More than one implementation of " + JpsPluginManager.class + " found: " + pluginManager.getClass() + " and " + managers.next().getClass());
                }
            } else {
                pluginManager = new SingleClassLoaderPluginManager();
            }
            this.myPluginManager = pluginManager;
        }
        return pluginManager.loadExtensions(extensionClass);
    }

    private static class SingleClassLoaderPluginManager
    extends JpsPluginManager {
        private SingleClassLoaderPluginManager() {
        }

        @Override
        @NotNull
        public <T> Collection<T> loadExtensions(@NotNull Class<T> extensionClass) {
            ServiceLoader<T> loader = ServiceLoader.load(extensionClass, extensionClass.getClassLoader());
            return ContainerUtilRt.newArrayList(loader);
        }
    }
}

