/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.codegen;

import com.google.common.base.Strings;
import com.google.gct.testrecorder.util.ClassHelper;
import com.google.gct.testrecorder.util.StringHelper;
import com.intellij.openapi.project.Project;

public class MatcherBuilder {
    private final Project myProject;
    private int myMatcherCount = 0;
    private final StringBuilder myMatchers = new StringBuilder();

    public MatcherBuilder(Project project) {
        this.myProject = project;
    }

    public void addMatcher(Kind kind, String matchedString, boolean shouldBox, boolean isAssertionMatcher) {
        if (!Strings.isNullOrEmpty((String)matchedString)) {
            if (kind == Kind.ClassName && !isAssertionMatcher) {
                matchedString = ClassHelper.getInternalName(this.myProject, matchedString);
            }
            if (this.myMatcherCount > 0) {
                this.myMatchers.append(", ");
            }
            if (kind == Kind.ClassName && isAssertionMatcher) {
                this.myMatchers.append("IsInstanceOf.<View>instanceOf(").append(matchedString).append(".class)");
            } else {
                this.myMatchers.append("with").append(kind.name()).append(kind == Kind.ClassName ? "(is(" : "(").append(shouldBox ? StringHelper.boxString(matchedString) : matchedString).append(kind == Kind.ClassName ? "))" : ")");
            }
            ++this.myMatcherCount;
        }
    }

    public int getMatcherCount() {
        return this.myMatcherCount;
    }

    public String getMatchers() {
        return this.myMatchers.toString();
    }

    public static enum Kind {
        Id,
        Text,
        ContentDescription,
        ClassName;

    }
}

