/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.codegen;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.run.ApkProviderUtil;
import com.google.gct.testrecorder.codegen.TestCodeMapper;
import com.google.gct.testrecorder.event.TestRecorderAssertion;
import com.google.gct.testrecorder.event.TestRecorderEvent;
import com.google.gct.testrecorder.ui.RecordingDialog;
import com.google.gct.testrecorder.util.ResourceHelper;
import com.google.gct.testrecorder.util.StringHelper;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.TestRecorderDetails;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.actions.SelectInContextImpl;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestCodeGenerator {
    private static final String TEST_CODE_TEMPLATE_FILE_NAME = "TestCodeTemplate.vm";
    private static final String ESPRESSO_CUSTOM_PACKAGE = "com.google.android.apps.common.testing.ui";
    private static final String ESPRESSO_STANDARD_PACKAGE = "android.support.test";
    private final AndroidFacet myFacet;
    private final PsiClass myTestClass;
    private final Module myTestClassModule;
    private final List<Object> myEvents;
    private final Project myProject;
    private final String myLaunchedActivityName;
    private final boolean myHasCustomEspressoDependency;
    private final boolean myHasAddedEspressoDependencies;
    private final boolean myWasEverPaused;

    public TestCodeGenerator(AndroidFacet facet, Module testClassModule, PsiClass testClass, List<Object> events, String launchedActivityName, boolean hasCustomEspressoDependency, boolean hasAddedEspressoDependencies, boolean wasEverPaused) {
        this.myFacet = facet;
        this.myTestClass = testClass;
        this.myTestClassModule = testClassModule;
        this.myEvents = events;
        this.myProject = this.myTestClassModule.getProject();
        this.myLaunchedActivityName = launchedActivityName;
        this.myHasCustomEspressoDependency = hasCustomEspressoDependency;
        this.myHasAddedEspressoDependencies = hasAddedEspressoDependencies;
        this.myWasEverPaused = wasEverPaused;
    }

    public void generate() {
        String testFilePath = this.myTestClass.getContainingFile().getVirtualFile().getPath();
        final VirtualFile testVirtualFile = LocalFileSystem.getInstance().findFileByPath(testFilePath);
        if (testVirtualFile == null) {
            return;
        }
        this.writeCode(testFilePath, testVirtualFile);
        testVirtualFile.refresh(false, true);
        OpenFileAction.openFile((String)testFilePath, (Project)this.myProject);
        testVirtualFile.refresh(false, true, new Runnable(){

            @Override
            public void run() {
                ProjectView projectView = ProjectView.getInstance((Project)TestCodeGenerator.this.myProject);
                String currentViewId = projectView.getCurrentViewId() == null ? "ProjectPane" : projectView.getCurrentViewId();
                for (SelectInTarget target : projectView.getSelectInTargets()) {
                    if (!currentViewId.equals(target.getMinorViewId())) continue;
                    target.selectIn((SelectInContext)new SelectInContextImpl(PsiManager.getInstance((Project)TestCodeGenerator.this.myProject).findFile(testVirtualFile)){

                        @Nullable
                        public FileEditorProvider getFileEditorProvider() {
                            return null;
                        }
                    }, false);
                    break;
                }
                JobScheduler.getScheduler().schedule(new Runnable(){

                    @Override
                    public void run() {
                        TransactionGuard.getInstance().submitTransactionLater((Disposable)TestCodeGenerator.this.myProject, () -> new OptimizeImportsProcessor(TestCodeGenerator.this.myProject, PsiManager.getInstance((Project)TestCodeGenerator.this.myProject).findFile(testVirtualFile)).run());
                    }
                }, TestCodeGenerator.this.myHasAddedEspressoDependencies ? 10L : 2L, TimeUnit.SECONDS);
                JobScheduler.getScheduler().schedule(new Runnable(){

                    @Override
                    public void run() {
                        TransactionGuard.getInstance().submitTransactionLater((Disposable)TestCodeGenerator.this.myProject, () -> new ReformatCodeProcessor(TestCodeGenerator.this.myProject, PsiManager.getInstance((Project)TestCodeGenerator.this.myProject).findFile(testVirtualFile), null, false).run());
                    }
                }, 2L, TimeUnit.SECONDS);
            }
        });
    }

    protected void writeCode(String testFilePath, VirtualFile testVirtualFile) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(testFilePath, "UTF-8");
            VelocityEngine velocityEngine = new VelocityEngine();
            velocityEngine.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogChute");
            velocityEngine.init();
            velocityEngine.evaluate((Context)this.createVelocityContext(testVirtualFile), (Writer)writer, RecordingDialog.class.getName(), this.readTemplateFileContent());
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate test class file: ", e);
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String readTemplateFileContent() {
        File testTemplateFile = ResourceHelper.getFileForResource(this, TEST_CODE_TEMPLATE_FILE_NAME, "test_code_template_", "vm");
        try {
            return FileUtils.readFileToString((File)testTemplateFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read the test template file " + testTemplateFile.getAbsolutePath(), e);
        }
    }

    @NotNull
    private VelocityContext createVelocityContext(VirtualFile testCodeVirtualFile) {
        Object lastEvent;
        Manifest manifest;
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("TestActivityName", (Object)StringHelper.getClassName(this.myLaunchedActivityName));
        velocityContext.put("ClassName", (Object)this.myTestClass.getName());
        velocityContext.put("TestMethodName", (Object)StringHelper.lowerCaseFirstCharacter(this.myTestClass.getName()));
        velocityContext.put("PackageName", (Object)AndroidUtils.computePackageName((Module)this.myTestClassModule, (VirtualFile)testCodeVirtualFile));
        velocityContext.put("EspressoPackageName", (Object)(this.myHasCustomEspressoDependency ? ESPRESSO_CUSTOM_PACKAGE : ESPRESSO_STANDARD_PACKAGE));
        velocityContext.put("WasEverPaused", (Object)this.myWasEverPaused);
        String resourcePackageName = "unknown";
        AndroidFacet testClassFacet = AndroidFacet.getInstance((Module)this.myTestClassModule);
        if (testClassFacet != null && (manifest = testClassFacet.getManifest()) != null) {
            resourcePackageName = manifest.getPackage().getStringValue();
        }
        velocityContext.put("ResourcePackageName", (Object)resourcePackageName);
        TestCodeMapper codeMapper = new TestCodeMapper(this.getApplicationId(resourcePackageName), this.myHasCustomEspressoDependency, this.myProject, this.getAndroidTargetData());
        ArrayList<String> testCodeLines = new ArrayList<String>();
        int eventCount = 0;
        int assertionCount = 0;
        if (!this.myEvents.isEmpty() && (lastEvent = this.myEvents.get(this.myEvents.size() - 1)) instanceof TestRecorderEvent && ((TestRecorderEvent)lastEvent).isDelayedMessagePost()) {
            this.myEvents.remove(this.myEvents.size() - 1);
        }
        for (Object event : this.myEvents) {
            if (event instanceof TestRecorderEvent) {
                testCodeLines.addAll(codeMapper.getTestCodeLinesForEvent((TestRecorderEvent)event));
                ++eventCount;
            } else {
                testCodeLines.addAll(codeMapper.getTestCodeLinesForAssertion((TestRecorderAssertion)event));
                ++assertionCount;
            }
            testCodeLines.add("");
        }
        velocityContext.put("AddContribImport", (Object)codeMapper.isRecyclerViewActionAdded());
        velocityContext.put("AddChildAtPositionMethod", (Object)codeMapper.isChildAtPositionAdded());
        velocityContext.put("TestCode", testCodeLines);
        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.TEST_RECORDER).setKind(AndroidStudioEvent.EventKind.TEST_RECORDER_GENERATE_TEST_CLASS).setTestRecorderDetails(TestRecorderDetails.newBuilder().setAssertionCount((long)assertionCount).setEventCount((long)eventCount)));
        return velocityContext;
    }

    private String getApplicationId(String defaultId) {
        try {
            return ApkProviderUtil.computePackageName((AndroidFacet)this.myFacet);
        }
        catch (Exception e) {
            return defaultId;
        }
    }

    @Nullable
    private AndroidTargetData getAndroidTargetData() {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance((Module)this.myTestClassModule);
        if (androidPlatform == null) {
            return null;
        }
        return androidPlatform.getSdkData().getTargetData(androidPlatform.getTarget());
    }
}

