/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.run;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.gct.testrecorder.settings.TestRecorderSettings;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestRecorderAndroidRunConfiguration
extends AndroidRunConfiguration {
    private static final Logger LOGGER = Logger.getInstance(TestRecorderAndroidRunConfiguration.class);

    public TestRecorderAndroidRunConfiguration(AndroidRunConfiguration baseConfiguration) {
        super(baseConfiguration.getProject(), baseConfiguration.getFactory());
        this.setName("TestRecorder" + baseConfiguration.getName());
        Element element = new Element("toClone");
        try {
            baseConfiguration.writeExternal(element);
            this.readExternal(element);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
    }

    public boolean supportsInstantRun() {
        return false;
    }

    @Nullable
    protected LaunchTask getApplicationLaunchTask(@NotNull ApplicationIdProvider applicationIdProvider, @NotNull AndroidFacet facet, boolean waitForDebugger, @NotNull LaunchStatus launchStatus) {
        LaunchTask launchTask = super.getApplicationLaunchTask(applicationIdProvider, facet, waitForDebugger, launchStatus);
        return launchTask == null ? null : new TestRecorderLaunchTask(launchTask, facet);
    }

    private static class TestRecorderLaunchTask
    implements LaunchTask {
        private final LaunchTask myDefaultLaunchTask;
        private final AndroidFacet myFacet;

        TestRecorderLaunchTask(@NotNull LaunchTask defaultLaunchTask, AndroidFacet facet) {
            this.myDefaultLaunchTask = defaultLaunchTask;
            this.myFacet = facet;
        }

        @NotNull
        public String getDescription() {
            return this.myDefaultLaunchTask.getDescription();
        }

        public int getDuration() {
            return this.myDefaultLaunchTask.getDuration();
        }

        public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
            if (TestRecorderSettings.getInstance().CLEAN_BEFORE_START) {
                try {
                    String command = "pm clear " + ApkProviderUtil.computePackageName((AndroidFacet)this.myFacet);
                    printer.stdout("$ adb shell " + command);
                    device.executeShellCommand(command, (IShellOutputReceiver)new NullOutputReceiver(), 5L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    LOGGER.warn("Exception clearing app data", (Throwable)e);
                }
            }
            return this.myDefaultLaunchTask.perform(device, launchStatus, printer);
        }
    }
}

