/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.settings;

import com.google.gct.testrecorder.settings.TestRecorderSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.text.NumberFormatter;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestRecorderSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final TestRecorderSettings mySettings;
    private JPanel myPanel;
    private JSpinner myEvaluationDepthSpinner;
    private JSpinner myScrollDepthSpinner;
    private JSpinner myAssertionDepthSpinner;
    private JCheckBox myCapEvaluationDepthCheckBox;
    private JCheckBox myCleanBeforeStartCheckbox;
    private JCheckBox myCleanAfterFinishCheckbox;
    private JCheckBox myStopAppCheckbox;
    private JPanel myLaunchAndTearDownSettingsPanel;
    private JPanel myDataCollecationAndCodeGenerationSettingsPanel;
    private JCheckBox myUseTextForElementMatchingCheckBox;
    private JCheckBox myUseContentDescriptionForElementMatchingCheckBox;
    private JCheckBox myEnableTestFragmentRecordingCheckBox;

    public TestRecorderSettingsConfigurable() {
        this.$$$setupUI$$$();
        this.mySettings = TestRecorderSettings.getInstance();
    }

    @NotNull
    public String getId() {
        return "test.recorder";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Espresso Test Recorder";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public JComponent createComponent() {
        this.myDataCollecationAndCodeGenerationSettingsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Data collection and code generation settings", (boolean)false, (Insets)new Insets(7, 0, 0, 0)));
        this.myLaunchAndTearDownSettingsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Launch and tear down settings", (boolean)false, (Insets)new Insets(7, 0, 0, 0)));
        this.myCleanAfterFinishCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestRecorderSettingsConfigurable.this.updateDependentCheckboxes();
            }
        });
        return this.myPanel;
    }

    private void updateDependentCheckboxes() {
        if (this.myCleanAfterFinishCheckbox.isSelected()) {
            this.myStopAppCheckbox.setSelected(true);
            this.myStopAppCheckbox.setEnabled(false);
        } else {
            this.myStopAppCheckbox.setEnabled(true);
        }
    }

    public boolean isModified() {
        Integer evaluationDepth = this.getSpinnerValue(this.myEvaluationDepthSpinner);
        Integer scrollDepth = this.getSpinnerValue(this.myScrollDepthSpinner);
        Integer assertionDepth = this.getSpinnerValue(this.myAssertionDepthSpinner);
        return evaluationDepth != null && this.mySettings.EVALUATION_DEPTH != evaluationDepth || scrollDepth != null && this.mySettings.SCROLL_DEPTH != scrollDepth || assertionDepth != null && this.mySettings.ASSERTION_DEPTH != assertionDepth || this.mySettings.CAP_AT_NON_IDENTIFIABLE_ELEMENTS != this.myCapEvaluationDepthCheckBox.isSelected() || this.mySettings.USE_TEXT_FOR_ELEMENT_MATCHING != this.myUseTextForElementMatchingCheckBox.isSelected() || this.mySettings.USE_CONTENT_DESCRIPTION_FOR_ELEMENT_MATCHING != this.myUseContentDescriptionForElementMatchingCheckBox.isSelected() || this.mySettings.ENABLE_TEST_FRAGMENT_RECORDING != this.myEnableTestFragmentRecordingCheckBox.isSelected() || this.mySettings.CLEAN_BEFORE_START != this.myCleanBeforeStartCheckbox.isSelected() || this.mySettings.CLEAN_AFTER_FINISH != this.myCleanAfterFinishCheckbox.isSelected() || this.mySettings.STOP_APP_AFTER_RECORDING != this.myStopAppCheckbox.isSelected();
    }

    public void apply() throws ConfigurationException {
        Integer assertionDepth;
        Integer scrollDepth;
        Integer evaluationDepth = this.getSpinnerValue(this.myEvaluationDepthSpinner);
        if (evaluationDepth != null) {
            this.mySettings.EVALUATION_DEPTH = evaluationDepth;
        }
        if ((scrollDepth = this.getSpinnerValue(this.myScrollDepthSpinner)) != null) {
            this.mySettings.SCROLL_DEPTH = scrollDepth;
        }
        if ((assertionDepth = this.getSpinnerValue(this.myAssertionDepthSpinner)) != null) {
            this.mySettings.ASSERTION_DEPTH = assertionDepth;
        }
        this.mySettings.CAP_AT_NON_IDENTIFIABLE_ELEMENTS = this.myCapEvaluationDepthCheckBox.isSelected();
        this.mySettings.USE_TEXT_FOR_ELEMENT_MATCHING = this.myUseTextForElementMatchingCheckBox.isSelected();
        this.mySettings.USE_CONTENT_DESCRIPTION_FOR_ELEMENT_MATCHING = this.myUseContentDescriptionForElementMatchingCheckBox.isSelected();
        this.mySettings.ENABLE_TEST_FRAGMENT_RECORDING = this.myEnableTestFragmentRecordingCheckBox.isSelected();
        this.mySettings.CLEAN_BEFORE_START = this.myCleanBeforeStartCheckbox.isSelected();
        this.mySettings.CLEAN_AFTER_FINISH = this.myCleanAfterFinishCheckbox.isSelected();
        this.mySettings.STOP_APP_AFTER_RECORDING = this.myStopAppCheckbox.isSelected();
    }

    public void reset() {
        this.myEvaluationDepthSpinner.setValue(this.mySettings.EVALUATION_DEPTH);
        this.myScrollDepthSpinner.setValue(this.mySettings.SCROLL_DEPTH);
        this.myAssertionDepthSpinner.setValue(this.mySettings.ASSERTION_DEPTH);
        this.myCapEvaluationDepthCheckBox.setSelected(this.mySettings.CAP_AT_NON_IDENTIFIABLE_ELEMENTS);
        this.myUseTextForElementMatchingCheckBox.setSelected(this.mySettings.USE_TEXT_FOR_ELEMENT_MATCHING);
        this.myUseContentDescriptionForElementMatchingCheckBox.setSelected(this.mySettings.USE_CONTENT_DESCRIPTION_FOR_ELEMENT_MATCHING);
        this.myEnableTestFragmentRecordingCheckBox.setSelected(this.mySettings.ENABLE_TEST_FRAGMENT_RECORDING);
        this.myCleanBeforeStartCheckbox.setSelected(this.mySettings.CLEAN_BEFORE_START);
        this.myCleanAfterFinishCheckbox.setSelected(this.mySettings.CLEAN_AFTER_FINISH);
        this.myStopAppCheckbox.setSelected(this.mySettings.STOP_APP_AFTER_RECORDING);
        this.updateDependentCheckboxes();
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        TestRecorderSettings testRecorderSettings = TestRecorderSettings.getInstance();
        this.myEvaluationDepthSpinner = new JSpinner(new SpinnerNumberModel(testRecorderSettings.EVALUATION_DEPTH, 1, 20, 1));
        this.forceToAcceptNumbersOnly(this.myEvaluationDepthSpinner);
        this.myScrollDepthSpinner = new JSpinner(new SpinnerNumberModel(testRecorderSettings.SCROLL_DEPTH, 1, 20, 1));
        this.forceToAcceptNumbersOnly(this.myScrollDepthSpinner);
        this.myAssertionDepthSpinner = new JSpinner(new SpinnerNumberModel(testRecorderSettings.ASSERTION_DEPTH, 1, 20, 1));
        this.forceToAcceptNumbersOnly(this.myAssertionDepthSpinner);
    }

    @Nullable
    private Integer getSpinnerValue(JSpinner spinner) {
        Object value = spinner.getValue();
        return value instanceof Integer ? (Integer)value : null;
    }

    private void forceToAcceptNumbersOnly(JSpinner spinner) {
        JFormattedTextField.AbstractFormatter formatter;
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.NumberEditor && (formatter = ((JSpinner.NumberEditor)editor).getTextField().getFormatter()) instanceof NumberFormatter) {
            ((NumberFormatter)formatter).setAllowsInvalid(false);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html><b>Warning:</b> changing these settings could affect the performance of Test Recorder, or impact the quality of the recorded tests.</html>");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 4, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html><br></html>");
        jPanel3.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 4, 0, 0, 0, 0, null, null, null));
        this.myDataCollecationAndCodeGenerationSettingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Max UI depth");
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("ScrollView detection depth");
        jPanel2.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        JSpinner jSpinner = this.myScrollDepthSpinner;
        jPanel2.add((Component)jSpinner, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JSpinner jSpinner2 = this.myEvaluationDepthSpinner;
        jPanel2.add((Component)jSpinner2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Assertion depth");
        jPanel2.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        JSpinner jSpinner3 = this.myAssertionDepthSpinner;
        jPanel2.add((Component)jSpinner3, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCapEvaluationDepthCheckBox = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Limit max depth to identifiable elements");
        jCheckBox7.setSelected(true);
        jPanel2.add((Component)jCheckBox7, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseTextForElementMatchingCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Use text for element matching");
        jCheckBox6.setSelected(true);
        jPanel2.add((Component)jCheckBox6, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseContentDescriptionForElementMatchingCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Use content description for element matching");
        jCheckBox5.setSelected(true);
        jPanel2.add((Component)jCheckBox5, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEnableTestFragmentRecordingCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Enable test fragment recording");
        jPanel2.add((Component)jCheckBox4, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLaunchAndTearDownSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCleanBeforeStartCheckbox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Clear app data before recording");
        jCheckBox3.setSelected(true);
        jPanel.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCleanAfterFinishCheckbox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Clear app data after recording");
        jCheckBox2.setSelected(true);
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myStopAppCheckbox = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(false);
        jCheckBox.setText("Exit app after recording");
        jCheckBox.setSelected(true);
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

