/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.ui;

import com.android.builder.model.SourceProvider;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.testartifacts.scopes.TestArtifactSearchScopes;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.ui.JBColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class TestClassNameInputDialog
extends DialogWrapper {
    private final Project myProject;
    private final String myLaunchedActivityName;
    private Module myTestClassModule;
    private PsiDirectory myTestClassParent;
    private PsiClass myTestClass;
    private String myClassName;
    private JPanel myRootPanel;
    private JTextField myClassNameField;
    private JLabel myErrorMessageLabel;

    protected TestClassNameInputDialog(Module launchedModule, String launchedActivityName) {
        super(launchedModule.getProject(), true);
        this.$$$setupUI$$$();
        this.myProject = launchedModule.getProject();
        this.myLaunchedActivityName = launchedActivityName;
        this.myTestClassModule = launchedModule;
        this.init();
        this.setTitle("Pick a test class name for your test");
        this.prepareEnvironment();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestClassNameInputDialog.this.updateOKButton();
            }
        });
    }

    private void prepareEnvironment() {
        String activityTestNameBase;
        VirtualFile testSourceDirectory = this.detectOrCreateTestSourceDirectory();
        if (testSourceDirectory == null) {
            throw new RuntimeException("Could not detect or create the test source directory!");
        }
        String[] activityNameFragments = this.myLaunchedActivityName.split("\\.");
        VirtualFile testFileParent = this.getOrCreateSubdirectory(testSourceDirectory, activityNameFragments, false);
        String activityTestName = activityTestNameBase = activityNameFragments[activityNameFragments.length - 1] + "Test";
        int counter = 2;
        while (testFileParent.findChild(this.appendJavaExtension(activityTestName)) != null) {
            activityTestName = activityTestNameBase + counter++;
        }
        this.myTestClassParent = PsiManager.getInstance((Project)this.myProject).findDirectory(testFileParent);
        this.myClassName = activityTestName;
        this.myClassNameField.setText(this.myClassName);
    }

    private VirtualFile detectOrCreateTestSourceDirectory() {
        VirtualFile launchedActivitySourceRoot = this.getContainingSourceRoot(this.appendJavaExtension(this.myLaunchedActivityName.replace('.', '/')));
        List<VirtualFile> existingAndroidTestSourceRoots = this.getExistingAndroidTestSourceRoots();
        if (existingAndroidTestSourceRoots.isEmpty()) {
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.TEST_RECORDER).setKind(AndroidStudioEvent.EventKind.TEST_RECORDER_MISSING_INSTRUMENTATION_TEST_FOLDER));
            VirtualFile moduleFile = this.myTestClassModule.getModuleFile();
            if (moduleFile == null) {
                throw new RuntimeException("Could not find module file for module " + this.myTestClassModule.getName());
            }
            VirtualFile moduleDirectory = moduleFile.getParent();
            List<String> androidTestSourceRoots = this.getAndroidTestSourceRoots();
            if (androidTestSourceRoots.isEmpty()) {
                return this.getOrCreateSubdirectory(moduleDirectory, new String[]{"src", "androidTest", "java"}, true);
            }
            String closestAndroidTestSourcePath = androidTestSourceRoots.get(this.findClosestAndroidTestSourceRootIndex(launchedActivitySourceRoot, androidTestSourceRoots));
            String moduleDirectoryCanonicalPath = moduleDirectory.getCanonicalPath();
            if (moduleDirectoryCanonicalPath == null || !closestAndroidTestSourcePath.startsWith(moduleDirectoryCanonicalPath)) {
                throw new RuntimeException("Android test source path is not inside the module: " + closestAndroidTestSourcePath);
            }
            return this.getOrCreateSubdirectory(moduleDirectory, closestAndroidTestSourcePath.substring(moduleDirectoryCanonicalPath.length() + 1).split("/"), true);
        }
        return existingAndroidTestSourceRoots.get(this.findClosestAndroidTestSourceRootIndex(launchedActivitySourceRoot, this.getCanonicalPaths(existingAndroidTestSourceRoots)));
    }

    private List<String> getAndroidTestSourceRoots() {
        ArrayList androidTestSourceRoots = Lists.newArrayList();
        AndroidModuleModel androidModel = AndroidModuleModel.get((Module)this.myTestClassModule);
        if (androidModel != null) {
            for (SourceProvider sourceProvider : androidModel.getTestSourceProviders("_android_test_")) {
                for (File javaDirectory : sourceProvider.getJavaDirectories()) {
                    try {
                        androidTestSourceRoots.add(FileUtil.toSystemIndependentName((String)javaDirectory.getCanonicalPath()));
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return androidTestSourceRoots;
    }

    private List<String> getCanonicalPaths(List<VirtualFile> virtualFiles) {
        ArrayList canonicalPaths = Lists.newArrayList();
        for (VirtualFile virtualFile : virtualFiles) {
            canonicalPaths.add(virtualFile.getCanonicalPath());
        }
        return canonicalPaths;
    }

    private VirtualFile getOrCreateSubdirectory(final VirtualFile parentDirectory, final String[] subdirectoriesPath, final boolean includeLastPathElement) {
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile currentDirectory = parentDirectory;
                int subdirectoriesPathLength = includeLastPathElement ? subdirectoriesPath.length : subdirectoriesPath.length - 1;
                for (int i = 0; i < subdirectoriesPathLength; ++i) {
                    String subdirectory = subdirectoriesPath[i];
                    VirtualFile child = currentDirectory.findChild(subdirectory);
                    if (child == null) {
                        try {
                            currentDirectory = currentDirectory.createChildDirectory((Object)this, subdirectory);
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to create subdirectory " + subdirectory, e);
                        }
                    }
                    currentDirectory = child;
                }
                return currentDirectory;
            }
        });
    }

    private int findClosestAndroidTestSourceRootIndex(@Nullable VirtualFile sourceRoot, List<String> androidTestSourceRootPaths) {
        if (sourceRoot == null) {
            return 0;
        }
        String sourceRootCanonicalPath = sourceRoot.getCanonicalPath();
        int closestAndroidTestSourceIndex = 0;
        String closestAndroidTestSourceRootPath = androidTestSourceRootPaths.get(closestAndroidTestSourceIndex);
        int maxOverlapSize = this.computeOverlapSize(sourceRootCanonicalPath, closestAndroidTestSourceRootPath);
        for (int i = 1; i < androidTestSourceRootPaths.size(); ++i) {
            int overlapSize = this.computeOverlapSize(sourceRootCanonicalPath, androidTestSourceRootPaths.get(i));
            if (overlapSize <= maxOverlapSize) continue;
            maxOverlapSize = overlapSize;
            closestAndroidTestSourceIndex = i;
        }
        return closestAndroidTestSourceIndex;
    }

    private int computeOverlapSize(String path1, String path2) {
        char[] pathChars1 = path1.toCharArray();
        char[] pathChars2 = path2.toCharArray();
        int overlapSize = 0;
        for (int i = 0; i < Math.min(pathChars1.length, pathChars2.length) && pathChars1[i] == pathChars2[i]; ++i) {
            ++overlapSize;
        }
        return overlapSize;
    }

    private static void collectModulesClosure(@NotNull Module module, List<Module> result) {
        if (result.contains(module)) {
            return;
        }
        result.add(module);
        for (Module depModule : ModuleRootManager.getInstance((Module)module).getDependencies()) {
            TestClassNameInputDialog.collectModulesClosure(depModule, result);
        }
    }

    @Nullable
    private VirtualFile getContainingSourceRoot(String fileRelativePath) {
        LinkedList relevantModules = Lists.newLinkedList();
        TestClassNameInputDialog.collectModulesClosure(this.myTestClassModule, relevantModules);
        for (Module module : relevantModules) {
            for (VirtualFile sourceRoot : ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE)) {
                if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)sourceRoot, (Project)this.myProject) || sourceRoot.findFileByRelativePath(fileRelativePath) == null) continue;
                this.myTestClassModule = module;
                return sourceRoot;
            }
        }
        return null;
    }

    private List<VirtualFile> getExistingAndroidTestSourceRoots() {
        ArrayList existingAndroidTestSourceRoots = Lists.newArrayList();
        for (VirtualFile testSourceRoot : ModuleRootManager.getInstance((Module)this.myTestClassModule).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE)) {
            TestArtifactSearchScopes searchScopes;
            if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)testSourceRoot, (Project)this.myProject) || (searchScopes = TestArtifactSearchScopes.get((Module)this.myTestClassModule)) == null || !searchScopes.isAndroidTestSource(testSourceRoot)) continue;
            existingAndroidTestSourceRoots.add(testSourceRoot);
        }
        return existingAndroidTestSourceRoots;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myErrorMessageLabel.setText("");
        this.myErrorMessageLabel.setForeground((Color)JBColor.RED);
        this.myClassNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            private void update() {
                TestClassNameInputDialog.this.myClassName = TestClassNameInputDialog.this.myClassNameField.getText().trim();
                TestClassNameInputDialog.this.updateOKButton();
            }
        });
        return this.myRootPanel;
    }

    private void updateOKButton() {
        this.setOKActionEnabled(PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(this.myClassName));
    }

    public PsiClass getTestClass() {
        return this.myTestClass;
    }

    public Module getTestClassModule() {
        return this.myTestClassModule;
    }

    protected void doOKAction() {
        if (((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return TestClassNameInputDialog.this.myTestClassParent.findFile(TestClassNameInputDialog.this.appendJavaExtension(TestClassNameInputDialog.this.myClassName)) != null;
            }
        })).booleanValue()) {
            this.myErrorMessageLabel.setText("File already exists.");
            return;
        }
        String errorMessage = (String)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<String>(){

            public String compute() {
                try {
                    TestClassNameInputDialog.this.myTestClass = JavaDirectoryService.getInstance().createClass(TestClassNameInputDialog.this.myTestClassParent, TestClassNameInputDialog.this.myClassName, "Class", false);
                    PsiManager.getInstance((Project)TestClassNameInputDialog.this.myProject).reloadFromDisk(TestClassNameInputDialog.this.myTestClass.getContainingFile());
                }
                catch (Exception e) {
                    return e.getMessage();
                }
                return null;
            }
        });
        if (errorMessage != null || this.myTestClass == null) {
            this.myErrorMessageLabel.setText("File creation failed.");
        } else {
            super.doOKAction();
        }
    }

    @NotNull
    private String appendJavaExtension(String appendToString) {
        return appendToString + "." + StdFileTypes.JAVA.getDefaultExtension();
    }

    public void doCancelAction() {
        this.myClassName = null;
        this.myTestClass = null;
        super.doCancelAction();
    }

    public void dispose() {
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return "#com.google.gct.testrecorder.ui.TestClassNameInputDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myClassNameField;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextField jTextField;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setOpaque(true);
        jPanel.setMinimumSize(new Dimension(450, 48));
        jPanel.setInheritsPopupMenu(false);
        jPanel.setPreferredSize(new Dimension(450, 48));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setMinimumSize(new Dimension(450, 26));
        jPanel2.setPreferredSize(new Dimension(450, 26));
        jPanel.add((Component)jPanel2, "North");
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Test class name:");
        jPanel2.add((Component)jLabel2, "West");
        this.myClassNameField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, "Center");
        this.myErrorMessageLabel = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setText("ERROR");
        Font font = jLabel.getFont();
        if (font != null) {
            jLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        }
        jLabel.setHorizontalTextPosition(4);
        jPanel.add((Component)jLabel, "South");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

