/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class ResourceHelper {
    public static File getFileForResource(@NotNull Object resourceRequester, @NotNull String resourcePath, @NotNull String prefix, String suffix) {
        InputStream in = resourceRequester.getClass().getClassLoader().getResourceAsStream(resourcePath);
        FileOutputStream out = null;
        try {
            File tempFile = File.createTempFile(prefix, suffix);
            tempFile.deleteOnExit();
            out = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            File file = tempFile;
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create file for resource " + resourcePath, e);
        }
        finally {
            try {
                in.close();
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] readResourceFully(@NotNull Object resourceRequester, @NotNull String resourcePath) {
        ByteArrayOutputStream readBytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        InputStream in = resourceRequester.getClass().getClassLoader().getResourceAsStream(resourcePath);
        try {
            int count;
            while ((count = in.read(buffer)) != -1) {
                readBytes.write(buffer, 0, count);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read resource " + resourcePath, e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return readBytes.toByteArray();
    }
}

