/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.annotation

import org.jetbrains.kotlin.resolve.jvm.JvmClassName

/**
 * Annotation file is generated by collecting annotated elements of generated files.
 * When compiling incrementally, the compiler generates only subset of all classes,
 * so after compilation annotation file contains only a subset of annotated elements,
 * which breaks the build.
 *
 * The workaround is to:
 * 1. backup old file before incremental compilation;
 * 2. after each iteration of IC:
 *  2.1 remove classes corresponding to dirty source files
 *  2.2 add annotations from newly generated annotations file
 */
interface AnnotationFileUpdater {
    fun updateAnnotations(outdatedClasses: Iterable<JvmClassName>)
    fun revert()
}

