/*
 * Copyright 2010-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

@file:Suppress("unused")
package kotlinx.android.parcel

import android.os.Parcel
import android.os.Parcelable

interface Parceler<P: Parcelable> {
    /**
     * Writes the [P] instance state to the [parcel].
     */
    fun P.write(parcel: Parcel, flags: Int)

    /**
     * Reads the [P] instance state from the [parcel], constructs the new [P] instance and returns it.
     */
    fun create(parcel: Parcel): P

    /**
     * Returns a new [Array]<P> with the given array [size].
     */
    fun newArray(size: Int): Array<P> {
        throw NotImplementedError("Generated by Android Extensions automatically")
    }
}