/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.bootstrap;

import org.gradle.api.Action;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.buildevents.BuildExceptionReporter;
import org.gradle.internal.logging.DefaultLoggingConfiguration;
import org.gradle.internal.logging.text.StreamingStyledTextOutputFactory;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.launcher.bootstrap.ExecutionCompleter;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.bootstrap.ProcessCompleter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntryPoint {
    public void run(String[] args) {
        RecordingExecutionListener listener = new RecordingExecutionListener();
        try {
            this.doAction(args, listener);
        }
        catch (Throwable e) {
            this.createErrorHandler().execute(e);
            listener.onFailure(e);
        }
        Throwable failure = listener.getFailure();
        ExecutionCompleter completer = this.createCompleter();
        if (failure == null) {
            completer.complete();
        } else {
            completer.completeWithFailure(failure);
        }
    }

    protected ExecutionCompleter createCompleter() {
        return new ProcessCompleter();
    }

    protected Action<Throwable> createErrorHandler() {
        return new BuildExceptionReporter((StyledTextOutputFactory)new StreamingStyledTextOutputFactory((Appendable)System.err), (LoggingConfiguration)new DefaultLoggingConfiguration(), (BuildClientMetaData)new GradleLauncherMetaData());
    }

    protected abstract void doAction(String[] var1, ExecutionListener var2);

    private static class RecordingExecutionListener
    implements ExecutionListener {
        private Throwable failure;

        private RecordingExecutionListener() {
        }

        public void onFailure(Throwable failure) {
            this.failure = failure;
        }

        public Throwable getFailure() {
            return this.failure;
        }
    }
}

