/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExpressionTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ShowExpressionTypeHandler
implements CodeInsightActionHandler {
    private final boolean myRequestFocus;

    public ShowExpressionTypeHandler(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, final @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)editor.getCaretModel().getOffset());
        Set<ExpressionTypeProvider> handlers = ShowExpressionTypeHandler.getHandlers(project, language, file2.getViewProvider().getBaseLanguage());
        if (handlers.isEmpty()) {
            return;
        }
        final Map<PsiElement, ExpressionTypeProvider> map = ShowExpressionTypeHandler.getExpressions(file2, editor, handlers);
        Pass<PsiElement> callback = new Pass<PsiElement>(){

            public void pass(@NotNull PsiElement expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExpressionTypeProvider provider = (ExpressionTypeProvider)ObjectUtils.assertNotNull(map.get(expression));
                String informationHint = provider.getInformationHint(expression);
                TextRange range2 = expression.getTextRange();
                editor.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (editor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    HintManager.getInstance().setRequestFocusForNextHint(ShowExpressionTypeHandler.this.myRequestFocus);
                    HintManager.getInstance().showInformationHint(editor, informationHint);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/hint/ShowExpressionTypeHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$pass$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (map.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (editor == null) {
                    ShowExpressionTypeHandler.$$$reportNull$$$0(12);
                }
                String errorHint = ((ExpressionTypeProvider)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)handlers))).getErrorHint();
                HintManager.getInstance().showErrorHint(editor, errorHint);
            });
        } else if (map.size() == 1) {
            callback.pass(ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(map.keySet())));
        } else {
            IntroduceTargetChooser.showChooser(editor, ContainerUtil.newArrayList(map.keySet()), callback, expression -> expression.getText());
        }
    }

    @NotNull
    public Map<PsiElement, ExpressionTypeProvider> getExpressions(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(4);
        }
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)editor.getCaretModel().getOffset());
        Set<ExpressionTypeProvider> handlers = ShowExpressionTypeHandler.getHandlers(file2.getProject(), language, file2.getViewProvider().getBaseLanguage());
        Map<PsiElement, ExpressionTypeProvider> map = ShowExpressionTypeHandler.getExpressions(file2, editor, handlers);
        if (map == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(5);
        }
        return map;
    }

    @NotNull
    private static Map<PsiElement, ExpressionTypeProvider> getExpressions(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Set<ExpressionTypeProvider> handlers) {
        if (file2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(7);
        }
        if (handlers == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(8);
        }
        if (handlers.isEmpty()) {
            Map<PsiElement, ExpressionTypeProvider> map = Collections.emptyMap();
            if (map == null) {
                ShowExpressionTypeHandler.$$$reportNull$$$0(9);
            }
            return map;
        }
        boolean exactRange = false;
        TextRange range2 = EditorUtil.getSelectionInAnyMode(editor);
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        int offset = !range2.isEmpty() ? range2.getStartOffset() : TargetElementUtil.adjustOffset(file2, editor.getDocument(), range2.getStartOffset());
        for (int i = 0; i < 3 && map.isEmpty() && offset > i; ++i) {
            PsiElement elementAt = file2.findElementAt(offset - i);
            if (elementAt == null) continue;
            for (ExpressionTypeProvider handler2 : handlers) {
                for (PsiElement element : handler2.getExpressionsAt(elementAt)) {
                    TextRange r = element.getTextRange();
                    if (exactRange && !r.equals((Object)range2) || !r.contains(range2)) continue;
                    if (!exactRange) {
                        exactRange = r.equals((Object)range2);
                    }
                    map.put(element, handler2);
                }
            }
        }
        LinkedHashMap linkedHashMap = map;
        if (linkedHashMap == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(10);
        }
        return linkedHashMap;
    }

    @NotNull
    public static Set<ExpressionTypeProvider> getHandlers(Project project, Language ... languages) {
        Set set2 = (Set)JBIterable.of((Object[])languages).flatten(language -> DumbService.getInstance((Project)project).filterByDumbAwareness((Collection)LanguageExpressionTypes.INSTANCE.allForLanguage(language))).addAllTo((Collection)ContainerUtil.newLinkedHashSet());
        if (set2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(11);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/ShowExpressionTypeHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/ShowExpressionTypeHandler";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExpressions";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

