/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.AbstractEmptyIntentionAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionListStep
implements ListPopupStep<IntentionActionWithTextCaching>,
SpeedSearchFilter<IntentionActionWithTextCaching> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.IntentionListStep");
    private final Set<IntentionActionWithTextCaching> myCachedIntentions;
    private final Set<IntentionActionWithTextCaching> myCachedErrorFixes;
    private final Set<IntentionActionWithTextCaching> myCachedInspectionFixes;
    private final Set<IntentionActionWithTextCaching> myCachedGutters;
    private final Set<IntentionActionWithTextCaching> myCachedNotifications;
    private final IntentionManagerSettings mySettings;
    @Nullable
    private final IntentionHintComponent myIntentionHintComponent;
    @Nullable
    private final Editor myEditor;
    private final PsiFile myFile;
    private final Project myProject;
    private static final TObjectHashingStrategy<IntentionActionWithTextCaching> ACTION_TEXT_AND_CLASS_EQUALS = new TObjectHashingStrategy<IntentionActionWithTextCaching>(){

        public int computeHashCode(IntentionActionWithTextCaching object) {
            return object.getText().hashCode();
        }

        public boolean equals(IntentionActionWithTextCaching o1, IntentionActionWithTextCaching o2) {
            return this.getActionClass(o1) == this.getActionClass(o2) && o1.getText().equals(o2.getText());
        }

        private Class<? extends IntentionAction> getActionClass(IntentionActionWithTextCaching o1) {
            IntentionAction action = o1.getAction();
            if (action instanceof IntentionActionDelegate) {
                return ((IntentionActionDelegate)action).getDelegate().getClass();
            }
            return action.getClass();
        }
    };
    private Runnable myFinalRunnable;

    public IntentionListStep(@Nullable IntentionHintComponent intentionHintComponent, @NotNull ShowIntentionsPass.IntentionsInfo intentions, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull Project project) {
        if (intentions == null) {
            IntentionListStep.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            IntentionListStep.$$$reportNull$$$0(1);
        }
        if (project == null) {
            IntentionListStep.$$$reportNull$$$0(2);
        }
        this(intentionHintComponent, editor, file2, project);
        this.wrapAndUpdateActions(intentions, false);
    }

    IntentionListStep(@Nullable IntentionHintComponent intentionHintComponent, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull Project project) {
        if (file2 == null) {
            IntentionListStep.$$$reportNull$$$0(3);
        }
        if (project == null) {
            IntentionListStep.$$$reportNull$$$0(4);
        }
        this.myCachedIntentions = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myCachedErrorFixes = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myCachedInspectionFixes = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myCachedGutters = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myCachedNotifications = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
        this.myIntentionHintComponent = intentionHintComponent;
        this.myEditor = editor;
        this.myFile = file2;
        this.myProject = project;
        this.mySettings = IntentionManagerSettings.getInstance();
    }

    boolean wrapAndUpdateActions(@NotNull ShowIntentionsPass.IntentionsInfo newInfo, boolean callUpdate) {
        if (newInfo == null) {
            IntentionListStep.$$$reportNull$$$0(5);
        }
        boolean changed = this.wrapActionsTo(newInfo.errorFixesToShow, this.myCachedErrorFixes, callUpdate);
        changed |= this.wrapActionsTo(newInfo.inspectionFixesToShow, this.myCachedInspectionFixes, callUpdate);
        changed |= this.wrapActionsTo(newInfo.intentionsToShow, this.myCachedIntentions, callUpdate);
        changed |= this.wrapActionsTo(newInfo.guttersToShow, this.myCachedGutters, callUpdate);
        return changed |= this.wrapActionsTo(newInfo.notificationActionsToShow, this.myCachedNotifications, callUpdate);
    }

    private boolean wrapActionsTo(@NotNull List<HighlightInfo.IntentionActionDescriptor> newDescriptors, @NotNull Set<IntentionActionWithTextCaching> cachedActions, boolean callUpdate) {
        if (newDescriptors == null) {
            IntentionListStep.$$$reportNull$$$0(6);
        }
        if (cachedActions == null) {
            IntentionListStep.$$$reportNull$$$0(7);
        }
        boolean changed = false;
        if (this.myEditor == null) {
            LOG.assertTrue(!callUpdate);
            for (HighlightInfo.IntentionActionDescriptor descriptor : newDescriptors) {
                changed |= cachedActions.add(this.wrapAction(descriptor, (PsiElement)this.myFile, this.myFile, null));
            }
        } else {
            Editor injectedEditor;
            PsiFile injectedFile;
            PsiFile hostElement;
            PsiFile element;
            int fileOffset;
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            int n = fileOffset = caretOffset > 0 && caretOffset == this.myFile.getTextLength() ? caretOffset - 1 : caretOffset;
            if (this.myFile instanceof PsiCompiledElement) {
                hostElement = element = this.myFile;
            } else if (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
                FileViewProvider viewProvider = this.myFile.getViewProvider();
                hostElement = element = viewProvider.findElementAt(fileOffset, viewProvider.getBaseLanguage());
            } else {
                hostElement = this.myFile.getViewProvider().findElementAt(fileOffset, this.myFile.getLanguage());
                element = InjectedLanguageUtil.findElementAtNoCommit(this.myFile, fileOffset);
            }
            if (element == null || element == hostElement) {
                injectedFile = this.myFile;
                injectedEditor = this.myEditor;
            } else {
                injectedFile = element.getContainingFile();
                injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(this.myEditor, injectedFile);
            }
            Iterator<IntentionActionWithTextCaching> iterator = cachedActions.iterator();
            while (iterator.hasNext()) {
                IntentionActionWithTextCaching cachedAction = iterator.next();
                IntentionAction action = cachedAction.getAction();
                if (ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, action) || hostElement != element && (element == null || ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, action))) continue;
                iterator.remove();
                changed = true;
            }
            THashSet wrappedNew = new THashSet(newDescriptors.size(), ACTION_TEXT_AND_CLASS_EQUALS);
            for (HighlightInfo.IntentionActionDescriptor descriptor : newDescriptors) {
                IntentionActionWithTextCaching cachedAction;
                IntentionAction action = descriptor.getAction();
                if (element != null && element != hostElement && (!callUpdate || ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, action))) {
                    cachedAction = this.wrapAction(descriptor, (PsiElement)element, injectedFile, injectedEditor);
                    wrappedNew.add(cachedAction);
                    changed |= cachedActions.add(cachedAction);
                    continue;
                }
                if (hostElement == null || callUpdate && !ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, action)) continue;
                cachedAction = this.wrapAction(descriptor, (PsiElement)hostElement, this.myFile, this.myEditor);
                wrappedNew.add(cachedAction);
                changed |= cachedActions.add(cachedAction);
            }
            Iterator<IntentionActionWithTextCaching> iterator2 = cachedActions.iterator();
            while (iterator2.hasNext()) {
                IntentionActionWithTextCaching cachedAction = iterator2.next();
                if (wrappedNew.contains(cachedAction)) continue;
                iterator2.remove();
                changed = true;
            }
        }
        return changed;
    }

    @NotNull
    IntentionActionWithTextCaching wrapAction(@NotNull HighlightInfo.IntentionActionDescriptor descriptor, @Nullable PsiElement element, @Nullable PsiFile containingFile, @Nullable Editor containingEditor) {
        if (descriptor == null) {
            IntentionListStep.$$$reportNull$$$0(8);
        }
        IntentionActionWithTextCaching cachedAction = new IntentionActionWithTextCaching(descriptor, (cached, action) -> {
            this.removeActionFromCached((IntentionActionWithTextCaching)cached);
            this.markInvoked((IntentionAction)action);
        });
        if (element == null) {
            IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
            if (intentionActionWithTextCaching == null) {
                IntentionListStep.$$$reportNull$$$0(9);
            }
            return intentionActionWithTextCaching;
        }
        List<IntentionAction> options = descriptor.getOptions(element, containingEditor);
        if (options == null) {
            IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
            if (intentionActionWithTextCaching == null) {
                IntentionListStep.$$$reportNull$$$0(10);
            }
            return intentionActionWithTextCaching;
        }
        for (IntentionAction option : options) {
            boolean isInspectionFix;
            if (containingFile == null || containingEditor == null || this.myEditor == null ? !option.isAvailable(this.myProject, containingEditor, containingFile) && (containingEditor == this.myEditor || !option.isAvailable(this.myProject, this.myEditor, this.myFile)) : !ShowIntentionActionsHandler.availableFor(containingFile, containingEditor, option) && (containingEditor == this.myEditor || !ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, option))) continue;
            IntentionActionWithTextCaching textCaching = new IntentionActionWithTextCaching(option);
            boolean isErrorFix = this.myCachedErrorFixes.contains(textCaching);
            if (isErrorFix) {
                cachedAction.addErrorFix(option);
            }
            if (isInspectionFix = this.myCachedInspectionFixes.contains(textCaching)) {
                cachedAction.addInspectionFix(option);
                continue;
            }
            cachedAction.addIntention(option);
        }
        IntentionActionWithTextCaching intentionActionWithTextCaching = cachedAction;
        if (intentionActionWithTextCaching == null) {
            IntentionListStep.$$$reportNull$$$0(11);
        }
        return intentionActionWithTextCaching;
    }

    public String getTitle() {
        return null;
    }

    public boolean isSelectable(IntentionActionWithTextCaching action) {
        return true;
    }

    public PopupStep onChosen(IntentionActionWithTextCaching action, boolean finalChoice) {
        IntentionAction a = action.getAction();
        while (a instanceof IntentionActionDelegate) {
            a = ((IntentionActionDelegate)a).getDelegate();
        }
        if (finalChoice && !(a instanceof AbstractEmptyIntentionAction)) {
            this.applyAction(action);
            return FINAL_CHOICE;
        }
        if (this.hasSubstep(action)) {
            return this.getSubStep(action, action.getToolName());
        }
        return FINAL_CHOICE;
    }

    public Runnable getFinalRunnable() {
        return this.myFinalRunnable;
    }

    private void applyAction(@NotNull IntentionActionWithTextCaching cachedAction) {
        if (cachedAction == null) {
            IntentionListStep.$$$reportNull$$$0(12);
        }
        this.myFinalRunnable = () -> {
            PsiFile file2;
            if (cachedAction == null) {
                IntentionListStep.$$$reportNull$$$0(19);
            }
            HintManager.getInstance().hideAllHints();
            if (this.myProject.isDisposed() || this.myEditor != null && (this.myEditor.isDisposed() || !this.myEditor.getComponent().isShowing())) {
                return;
            }
            if (DumbService.isDumb((Project)this.myProject) && !DumbService.isDumbAware((Object)cachedAction)) {
                DumbService.getInstance((Project)this.myProject).showDumbModeNotification(cachedAction.getText() + " is not available during indexing");
                return;
            }
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            PsiFile psiFile = file2 = this.myEditor != null ? PsiUtilBase.getPsiFileInEditor((Editor)this.myEditor, (Project)this.myProject) : this.myFile;
            if (file2 == null) {
                return;
            }
            ShowIntentionActionsHandler.chooseActionAndInvoke(file2, this.myEditor, cachedAction.getAction(), cachedAction.getText(), this.myProject);
        };
    }

    private void markInvoked(@NotNull IntentionAction action) {
        if (action == null) {
            IntentionListStep.$$$reportNull$$$0(13);
        }
        if (this.myEditor != null) {
            ShowIntentionsPass.markActionInvoked(this.myFile.getProject(), this.myEditor, action);
        }
    }

    private void removeActionFromCached(@NotNull IntentionActionWithTextCaching action) {
        if (action == null) {
            IntentionListStep.$$$reportNull$$$0(14);
        }
        this.myCachedErrorFixes.remove(action);
        this.myCachedGutters.remove(action);
        this.myCachedInspectionFixes.remove(action);
        this.myCachedIntentions.remove(action);
        this.myCachedNotifications.remove(action);
    }

    @NotNull
    IntentionListStep getSubStep(@NotNull IntentionActionWithTextCaching action, final String title) {
        if (action == null) {
            IntentionListStep.$$$reportNull$$$0(15);
        }
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        for (IntentionAction optionIntention : action.getOptionIntentions()) {
            intentions.intentionsToShow.add(new HighlightInfo.IntentionActionDescriptor(optionIntention, IntentionListStep.getIcon(optionIntention)));
        }
        for (IntentionAction optionFix : action.getOptionErrorFixes()) {
            intentions.errorFixesToShow.add(new HighlightInfo.IntentionActionDescriptor(optionFix, IntentionListStep.getIcon(optionFix)));
        }
        for (IntentionAction optionFix : action.getOptionInspectionFixes()) {
            intentions.inspectionFixesToShow.add(new HighlightInfo.IntentionActionDescriptor(optionFix, IntentionListStep.getIcon(optionFix)));
        }
        IntentionListStep intentionListStep = new IntentionListStep(this.myIntentionHintComponent, intentions, this.myEditor, this.myFile, this.myProject){

            @Override
            public String getTitle() {
                return title;
            }
        };
        if (intentionListStep == null) {
            IntentionListStep.$$$reportNull$$$0(16);
        }
        return intentionListStep;
    }

    private static Icon getIcon(IntentionAction optionIntention) {
        return optionIntention instanceof Iconable ? ((Iconable)optionIntention).getIcon(0) : null;
    }

    public Map<IntentionAction, List<IntentionAction>> getActionsWithSubActions() {
        LinkedHashMap result2 = ContainerUtil.newLinkedHashMap();
        for (IntentionActionWithTextCaching cached : this.getValues()) {
            IntentionAction action = cached.getAction();
            if (ShowIntentionActionsHandler.chooseFileForAction(this.myFile, this.myEditor, action) == null) continue;
            List<IntentionActionWithTextCaching> subActions = this.getSubStep(cached, cached.getToolName()).getValues();
            List options = subActions.stream().map(IntentionActionWithTextCaching::getAction).filter(option -> ShowIntentionActionsHandler.chooseFileForAction(this.myFile, this.myEditor, option) != null).collect(Collectors.toList());
            result2.put(action, options);
        }
        return result2;
    }

    public boolean hasSubstep(IntentionActionWithTextCaching action) {
        return action.getOptionIntentions().size() + action.getOptionErrorFixes().size() > 0;
    }

    @NotNull
    public List<IntentionActionWithTextCaching> getValues() {
        List<IntentionActionWithTextCaching> result2 = new ArrayList<IntentionActionWithTextCaching>(this.myCachedErrorFixes);
        result2.addAll(this.myCachedInspectionFixes);
        result2.addAll(this.myCachedIntentions);
        result2.addAll(this.myCachedGutters);
        result2.addAll(this.myCachedNotifications);
        result2 = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(result2);
        Collections.sort(result2, (o1, o2) -> {
            int weight2;
            int weight1 = this.getWeight((IntentionActionWithTextCaching)o1);
            if (weight1 != (weight2 = this.getWeight((IntentionActionWithTextCaching)o2))) {
                return weight2 - weight1;
            }
            return o1.compareTo((IntentionActionWithTextCaching)o2);
        });
        List<IntentionActionWithTextCaching> list2 = result2;
        if (list2 == null) {
            IntentionListStep.$$$reportNull$$$0(17);
        }
        return list2;
    }

    private int getWeight(IntentionActionWithTextCaching action) {
        IntentionAction a = action.getAction();
        int group = this.getGroup(action);
        while (a instanceof IntentionActionDelegate) {
            a = ((IntentionActionDelegate)a).getDelegate();
        }
        if (a instanceof PriorityAction) {
            return group + IntentionListStep.getPriorityWeight(((PriorityAction)a).getPriority());
        }
        if (a instanceof SuppressIntentionActionFromFix && ((SuppressIntentionActionFromFix)a).isShouldBeAppliedToInjectionHost() == ThreeState.NO) {
            return group - 1;
        }
        return group;
    }

    private static int getPriorityWeight(PriorityAction.Priority priority) {
        switch (priority) {
            case HIGH: {
                return 3;
            }
            case LOW: {
                return -3;
            }
        }
        return 0;
    }

    private int getGroup(IntentionActionWithTextCaching action) {
        if (this.myCachedErrorFixes.contains(action)) {
            return 20;
        }
        if (this.myCachedInspectionFixes.contains(action)) {
            return 10;
        }
        if (this.myCachedNotifications.contains(action)) {
            return 7;
        }
        if (this.myCachedGutters.contains(action)) {
            return 5;
        }
        if (action.getAction() instanceof EmptyIntentionAction) {
            return -10;
        }
        return 0;
    }

    @NotNull
    public String getTextFor(IntentionActionWithTextCaching action) {
        String text = action.getAction().getText();
        if (LOG.isDebugEnabled() && text.startsWith("<html>")) {
            LOG.info("IntentionAction.getText() returned HTML: action=" + action + " text=" + text);
        }
        String string = text;
        if (string == null) {
            IntentionListStep.$$$reportNull$$$0(18);
        }
        return string;
    }

    public Icon getIconFor(IntentionActionWithTextCaching value) {
        Icon icon;
        if (value.getIcon() != null) {
            return value.getIcon();
        }
        IntentionAction action = value.getAction();
        while (action instanceof IntentionActionDelegate) {
            action = ((IntentionActionDelegate)action).getDelegate();
        }
        IntentionAction iconable = action;
        if (action instanceof QuickFixWrapper) {
            iconable = ((QuickFixWrapper)action).getFix();
        }
        if (iconable instanceof Iconable && (icon = ((Iconable)iconable).getIcon(0)) != null) {
            return icon;
        }
        if (this.mySettings.isShowLightBulb(action)) {
            return this.myCachedErrorFixes.contains(value) ? AllIcons.Actions.QuickfixBulb : (this.myCachedInspectionFixes.contains(value) ? AllIcons.Actions.IntentionBulb : AllIcons.Actions.RealIntentionBulb);
        }
        return this.myCachedErrorFixes.contains(value) ? AllIcons.Actions.QuickfixOffBulb : AllIcons.Actions.RealIntentionOffBulb;
    }

    public void canceled() {
        if (this.myIntentionHintComponent != null) {
            this.myIntentionHintComponent.canceled(this);
        }
    }

    public int getDefaultOptionIndex() {
        return 0;
    }

    public ListSeparator getSeparatorAbove(IntentionActionWithTextCaching value) {
        List<IntentionActionWithTextCaching> values = this.getValues();
        int index = values.indexOf(value);
        if (index <= 0) {
            return null;
        }
        IntentionActionWithTextCaching prev2 = values.get(index - 1);
        if (this.getGroup(value) != this.getGroup(prev2)) {
            return new ListSeparator();
        }
        return null;
    }

    public boolean isMnemonicsNavigationEnabled() {
        return false;
    }

    public MnemonicNavigationFilter<IntentionActionWithTextCaching> getMnemonicNavigationFilter() {
        return null;
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public boolean isAutoSelectionEnabled() {
        return false;
    }

    public SpeedSearchFilter<IntentionActionWithTextCaching> getSpeedSearchFilter() {
        return this;
    }

    public boolean canBeHidden(IntentionActionWithTextCaching value) {
        return true;
    }

    public String getIndexedString(IntentionActionWithTextCaching value) {
        return this.getTextFor(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDescriptors";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedActions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/IntentionListStep";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedAction";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionListStep";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAction";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubStep";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrapAndUpdateActions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wrapActionsTo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wrapAction";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyAction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "markInvoked";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeActionFromCached";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSubStep";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyAction$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

