/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetAbbreviationBalloon {
    private final String myAbbreviationsHistoryKey;
    private final String myLastAbbreviationKey;
    private final Callback myCallback;
    @NotNull
    private final EmmetContextHelp myContextHelp;
    @Nullable
    private static String ourTestingAbbreviation;

    public EmmetAbbreviationBalloon(@NotNull String abbreviationsHistoryKey, @NotNull String lastAbbreviationKey, @NotNull Callback callback, @NotNull EmmetContextHelp contextHelp) {
        if (abbreviationsHistoryKey == null) {
            EmmetAbbreviationBalloon.$$$reportNull$$$0(0);
        }
        if (lastAbbreviationKey == null) {
            EmmetAbbreviationBalloon.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            EmmetAbbreviationBalloon.$$$reportNull$$$0(2);
        }
        if (contextHelp == null) {
            EmmetAbbreviationBalloon.$$$reportNull$$$0(3);
        }
        this.myAbbreviationsHistoryKey = abbreviationsHistoryKey;
        this.myLastAbbreviationKey = lastAbbreviationKey;
        this.myCallback = callback;
        this.myContextHelp = contextHelp;
    }

    public static void setTestingAbbreviation(@NotNull String testingAbbreviation, @NotNull Disposable parentDisposable) {
        if (testingAbbreviation == null) {
            EmmetAbbreviationBalloon.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            EmmetAbbreviationBalloon.$$$reportNull$$$0(5);
        }
        ourTestingAbbreviation = testingAbbreviation;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourTestingAbbreviation = null;
            }
        });
    }

    public void show(final @NotNull CustomTemplateCallback customTemplateCallback) {
        if (customTemplateCallback == null) {
            EmmetAbbreviationBalloon.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (ourTestingAbbreviation == null) {
                throw new RuntimeException("Testing abbreviation is not set. See EmmetAbbreviationBalloon#setTestingAbbreviation");
            }
            this.myCallback.onEnter(ourTestingAbbreviation);
            return;
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        final TextFieldWithStoredHistory field = new TextFieldWithStoredHistory(this.myAbbreviationsHistoryKey);
        Dimension fieldPreferredSize = field.getPreferredSize();
        field.setPreferredSize(new Dimension(Math.max(220, fieldPreferredSize.width), fieldPreferredSize.height));
        field.setHistorySize(10);
        ContextHelpLabel label = this.myContextHelp.createHelpLabel();
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)3, (int)0, (int)1));
        panel2.add((Component)field, "Center");
        panel2.add((Component)label, "East");
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        final BalloonImpl balloon = (BalloonImpl)popupFactory.createBalloonBuilder((JComponent)panel2).setCloseButtonEnabled(false).setBlockClicksThroughBalloon(true).setAnimationCycle(0).setHideOnKeyOutside(true).setHideOnClickOutside(true).setFillColor(panel2.getBackground()).createBalloon();
        final DocumentAdapter documentListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!EmmetAbbreviationBalloon.isValid(customTemplateCallback)) {
                    balloon.hide();
                    return;
                }
                EmmetAbbreviationBalloon.validateTemplateKey((TextFieldWithHistory)field, balloon, field.getText(), customTemplateCallback);
            }
        };
        field.addDocumentListener((DocumentListener)documentListener);
        final KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!field.isPopupVisible()) {
                    if (!EmmetAbbreviationBalloon.isValid(customTemplateCallback)) {
                        balloon.hide();
                        return;
                    }
                    switch (e.getKeyCode()) {
                        case 10: {
                            String abbreviation = field.getText();
                            if (!EmmetAbbreviationBalloon.validateTemplateKey((TextFieldWithHistory)field, balloon, abbreviation, customTemplateCallback)) break;
                            EmmetAbbreviationBalloon.this.myCallback.onEnter(abbreviation);
                            PropertiesComponent.getInstance().setValue(EmmetAbbreviationBalloon.this.myLastAbbreviationKey, abbreviation);
                            field.addCurrentTextToHistory();
                            balloon.hide();
                            break;
                        }
                        case 27: {
                            balloon.hide(false);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon$3", "keyPressed"));
            }
        };
        field.addKeyboardListener((KeyListener)keyListener);
        balloon.addListener((JBPopupListener)new JBPopupListener.Adapter(){

            public void beforeShown(LightweightWindowEvent event) {
                field.setText(PropertiesComponent.getInstance().getValue(EmmetAbbreviationBalloon.this.myLastAbbreviationKey, ""));
            }

            public void onClosed(LightweightWindowEvent event) {
                field.removeKeyListener((KeyListener)keyListener);
                field.removeDocumentListener((DocumentListener)documentListener);
                super.onClosed(event);
            }
        });
        balloon.show(popupFactory.guessBestPopupLocation(customTemplateCallback.getEditor()), Balloon.Position.below);
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)customTemplateCallback.getProject());
        focusManager.doWhenFocusSettlesDown(() -> {
            focusManager.requestFocus((Component)field, true);
            field.selectText();
        });
    }

    private static boolean validateTemplateKey(@NotNull TextFieldWithHistory field, @Nullable Balloon balloon, @NotNull String abbreviation, @NotNull CustomTemplateCallback callback) {
        if (field == null) {
            EmmetAbbreviationBalloon.$$$reportNull$$$0(7);
        }
        if (abbreviation == null) {
            EmmetAbbreviationBalloon.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            EmmetAbbreviationBalloon.$$$reportNull$$$0(9);
        }
        boolean correct = ZenCodingTemplate.checkTemplateKey(abbreviation, callback);
        field.getTextEditor().setBackground(correct ? LightColors.SLIGHTLY_GREEN : LightColors.RED);
        if (balloon != null && !balloon.isDisposed()) {
            balloon.revalidate();
        }
        return correct;
    }

    private static boolean isValid(CustomTemplateCallback callback) {
        return !callback.getEditor().isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abbreviationsHistoryKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastAbbreviationKey";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextHelp";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testingAbbreviation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customTemplateCallback";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abbreviation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setTestingAbbreviation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "validateTemplateKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Callback {
        public void onEnter(@NotNull String var1);
    }

    public static class EmmetContextHelp {
        @NotNull
        private final String myDescription;
        @Nullable
        private String myLinkText;
        @Nullable
        private String myLinkUrl;

        public EmmetContextHelp(@NotNull String description) {
            if (description == null) {
                EmmetContextHelp.$$$reportNull$$$0(0);
            }
            this.myLinkText = null;
            this.myLinkUrl = null;
            this.myDescription = description;
        }

        public EmmetContextHelp(@NotNull String description, @NotNull String linkText, @NotNull String linkUrl) {
            if (description == null) {
                EmmetContextHelp.$$$reportNull$$$0(1);
            }
            if (linkText == null) {
                EmmetContextHelp.$$$reportNull$$$0(2);
            }
            if (linkUrl == null) {
                EmmetContextHelp.$$$reportNull$$$0(3);
            }
            this.myLinkText = null;
            this.myLinkUrl = null;
            this.myDescription = description;
            this.myLinkText = linkText;
            this.myLinkUrl = linkUrl;
        }

        @NotNull
        public ContextHelpLabel createHelpLabel() {
            if (StringUtil.isEmpty((String)this.myLinkText) || StringUtil.isEmpty((String)this.myLinkUrl)) {
                ContextHelpLabel contextHelpLabel = ContextHelpLabel.create((String)this.myDescription);
                if (contextHelpLabel == null) {
                    EmmetContextHelp.$$$reportNull$$$0(4);
                }
                return contextHelpLabel;
            }
            ContextHelpLabel contextHelpLabel = ContextHelpLabel.createWithLink(null, (String)this.myDescription, (String)this.myLinkText, () -> BrowserUtil.browse((String)this.myLinkUrl));
            if (contextHelpLabel == null) {
                EmmetContextHelp.$$$reportNull$$$0(5);
            }
            return contextHelpLabel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linkText";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linkUrl";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon$EmmetContextHelp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/emmet/EmmetAbbreviationBalloon$EmmetContextHelp";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHelpLabel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

