/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.CommonProblemDescriptorImpl;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ExternallyAnnotated;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptorBase
extends CommonProblemDescriptorImpl
implements ProblemDescriptor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.ProblemDescriptorImpl");
    @NotNull
    private final SmartPsiElementPointer myStartSmartPointer;
    @Nullable
    private final SmartPsiElementPointer myEndSmartPointer;
    private final ProblemHighlightType myHighlightType;
    private Navigatable myNavigatable;
    private final boolean myAfterEndOfLine;
    private final TextRange myTextRangeInElement;
    private final boolean myShowTooltip;
    private TextAttributesKey myEnforcedTextAttributes;
    private int myLineNumber;
    private ProblemGroup myProblemGroup;
    @Nullable
    private final Throwable myCreationTrace;

    public ProblemDescriptorBase(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String descriptionTemplate, LocalQuickFix[] fixes, @NotNull ProblemHighlightType highlightType, boolean isAfterEndOfLine, @Nullable TextRange rangeInElement, boolean showTooltip, boolean onTheFly) {
        if (startElement == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(1);
        }
        if (descriptionTemplate == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(2);
        }
        if (highlightType == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(3);
        }
        super((QuickFix[])fixes, descriptionTemplate);
        this.myLineNumber = -1;
        this.myShowTooltip = showTooltip;
        PsiFile startContainingFile = startElement.getContainingFile();
        LOG.assertTrue(startContainingFile != null && startContainingFile.isValid() || startElement.isValid(), (Object)startElement);
        PsiFile endContainingFile = startElement == endElement ? startContainingFile : endElement.getContainingFile();
        LOG.assertTrue(startElement == endElement || endContainingFile != null && endContainingFile.isValid() || endElement.isValid(), (Object)endElement);
        this.assertPhysical(startElement);
        if (startElement != endElement) {
            this.assertPhysical(endElement);
        }
        TextRange startElementRange = ProblemDescriptorBase.getAnnotationRange(startElement);
        TextRange endElementRange = ProblemDescriptorBase.getAnnotationRange(endElement);
        if (!(startElementRange == null || endElementRange == null || startElementRange.getStartOffset() < endElementRange.getEndOffset() || startElement instanceof PsiFile && endElement instanceof PsiFile)) {
            LOG.error("Empty PSI elements must not be passed to createDescriptor. Start: " + startElement + ", end: " + endElement + ", startContainingFile: " + startContainingFile);
        }
        if (rangeInElement != null && startElementRange != null && endElementRange != null) {
            TextRange.assertProperRange((Segment)rangeInElement);
            if (rangeInElement.getEndOffset() > endElementRange.getEndOffset() - startElementRange.getStartOffset()) {
                LOG.error("Argument rangeInElement " + rangeInElement + " endOffset must not exceed descriptor text range (" + startElementRange.getStartOffset() + ", " + endElementRange.getEndOffset() + ") length (" + (endElementRange.getEndOffset() - startElementRange.getStartOffset()) + ").");
            }
        }
        if (rangeInElement != null) {
            TextRange.assertProperRange((Segment)rangeInElement);
        }
        this.myHighlightType = highlightType;
        Project project = startContainingFile == null ? startElement.getProject() : startContainingFile.getProject();
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
        this.myStartSmartPointer = manager.createSmartPsiElementPointer(startElement, startContainingFile);
        this.myEndSmartPointer = startElement == endElement ? null : manager.createSmartPsiElementPointer(endElement, endContainingFile);
        this.myAfterEndOfLine = isAfterEndOfLine;
        this.myTextRangeInElement = rangeInElement;
        this.myCreationTrace = onTheFly ? null : ThrowableInterner.intern((Throwable)new Throwable());
    }

    @Nullable
    private static TextRange getAnnotationRange(@NotNull PsiElement startElement) {
        if (startElement == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(4);
        }
        return startElement instanceof ExternallyAnnotated ? ((ExternallyAnnotated)startElement).getAnnotationRegion() : startElement.getTextRange();
    }

    protected void assertPhysical(PsiElement element) {
        if (!element.isPhysical()) {
            LOG.error("Non-physical PsiElement. Physical element is required to be able to anchor the problem in the source tree: " + element + "; file: " + element.getContainingFile());
        }
    }

    @Nullable
    public Throwable getCreationTrace() {
        return this.myCreationTrace;
    }

    public PsiElement getPsiElement() {
        PsiElement startElement = this.getStartElement();
        if (this.myEndSmartPointer == null) {
            return startElement;
        }
        PsiElement endElement = this.getEndElement();
        if (startElement == endElement) {
            return startElement;
        }
        if (startElement == null || endElement == null) {
            return null;
        }
        return PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
    }

    @Nullable
    public TextRange getTextRangeInElement() {
        return this.myTextRangeInElement;
    }

    public PsiElement getStartElement() {
        return this.myStartSmartPointer.getElement();
    }

    public PsiElement getEndElement() {
        return this.myEndSmartPointer == null ? this.getStartElement() : this.myEndSmartPointer.getElement();
    }

    public int getLineNumber() {
        if (this.myLineNumber == -1) {
            int textLength;
            PsiElement psiElement = this.getPsiElement();
            if (psiElement == null) {
                return -1;
            }
            if (!psiElement.isValid()) {
                return -1;
            }
            LOG.assertTrue(psiElement.isPhysical());
            InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)psiElement.getProject());
            PsiFile containingFile = manager.getTopLevelFile(psiElement);
            Document document = PsiDocumentManager.getInstance((Project)psiElement.getProject()).getDocument(containingFile);
            if (document == null) {
                return -1;
            }
            TextRange textRange = this.getTextRange();
            if (textRange == null) {
                return -1;
            }
            int startOffset = (textRange = manager.injectedToHost(psiElement, textRange)).getStartOffset();
            LOG.assertTrue(startOffset <= (textLength = document.getTextLength()), (Object)(this.getDescriptionTemplate() + " at " + startOffset + ", " + textLength));
            this.myLineNumber = document.getLineNumber(startOffset);
        }
        return this.myLineNumber;
    }

    @NotNull
    public ProblemHighlightType getHighlightType() {
        ProblemHighlightType problemHighlightType = this.myHighlightType;
        if (problemHighlightType == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(5);
        }
        return problemHighlightType;
    }

    public boolean isAfterEndOfLine() {
        return this.myAfterEndOfLine;
    }

    public void setTextAttributes(TextAttributesKey key) {
        this.myEnforcedTextAttributes = key;
    }

    public TextAttributesKey getEnforcedTextAttributes() {
        return this.myEnforcedTextAttributes;
    }

    @Nullable
    public TextRange getTextRangeForNavigation() {
        TextRange textRange = this.getTextRange();
        if (textRange == null) {
            return null;
        }
        PsiElement element = this.getPsiElement();
        return InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, textRange);
    }

    @Nullable
    public TextRange getTextRange() {
        PsiElement endElement;
        PsiElement startElement = this.getStartElement();
        PsiElement psiElement = endElement = this.myEndSmartPointer == null ? startElement : this.getEndElement();
        if (startElement == null || endElement == null) {
            return null;
        }
        TextRange startRange = ProblemDescriptorBase.getAnnotationRange(startElement);
        if (startRange == null) {
            return null;
        }
        if (startElement != endElement) {
            TextRange endRange = ProblemDescriptorBase.getAnnotationRange(endElement);
            if (endRange == null) {
                return null;
            }
            startRange = startRange.union(endRange);
        } else if (this.myTextRangeInElement != null) {
            if (this.myTextRangeInElement.getEndOffset() > startRange.getLength()) {
                return null;
            }
            startRange = startRange.cutOut(this.myTextRangeInElement);
        }
        if (this.isAfterEndOfLine()) {
            int endOffset = startRange.getEndOffset();
            return new TextRange(endOffset, endOffset);
        }
        return startRange;
    }

    public Navigatable getNavigatable() {
        return this.myNavigatable;
    }

    public void setNavigatable(Navigatable navigatable) {
        this.myNavigatable = navigatable;
    }

    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
        this.myProblemGroup = problemGroup;
    }

    public boolean showTooltip() {
        return this.myShowTooltip;
    }

    @Override
    public String toString() {
        PsiElement element = this.getPsiElement();
        return ProblemDescriptorUtil.renderDescriptionMessage(this, element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionTemplate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ProblemDescriptorBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ProblemDescriptorBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationRange";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

