/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions.suppress;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.codeInspection.ui.actions.InspectionViewActionBase;
import com.intellij.codeInspection.ui.actions.KeyAwareInspectionViewAction;
import com.intellij.codeInspection.ui.actions.suppress.SuppressActionSequentialTask;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressActionWrapper
extends ActionGroup
implements CompactActionGroup {
    private static final Logger LOG = Logger.getInstance(SuppressActionWrapper.class);

    public SuppressActionWrapper() {
        super(InspectionsBundle.message((String)"suppress.inspection.problem", (Object[])new Object[0]), false);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        InspectionResultsView view = InspectionViewActionBase.getView(e);
        if (view == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                SuppressActionWrapper.$$$reportNull$$$0(0);
            }
            return AnAction.EMPTY_ARRAY;
        }
        InspectionToolWrapper wrapper = view.getTree().getSelectedToolWrapper(true);
        if (wrapper == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                SuppressActionWrapper.$$$reportNull$$$0(1);
            }
            return AnAction.EMPTY_ARRAY;
        }
        Set<SuppressIntentionAction> suppressActions = view.getSuppressActionHolder().getSuppressActions(wrapper);
        if (suppressActions.isEmpty()) {
            if (AnAction.EMPTY_ARRAY == null) {
                SuppressActionWrapper.$$$reportNull$$$0(2);
            }
            return AnAction.EMPTY_ARRAY;
        }
        AnAction[] actions = new AnAction[suppressActions.size() + 1];
        int i = 0;
        for (SuppressIntentionAction action : suppressActions) {
            actions[i++] = new SuppressTreeAction(action);
        }
        actions[suppressActions.size()] = Separator.getInstance();
        Arrays.sort(actions, Comparator.comparingInt(a -> a instanceof Separator ? 0 : (((SuppressTreeAction)((Object)a)).isSuppressAll() ? 1 : -1)));
        if (actions == null) {
            SuppressActionWrapper.$$$reportNull$$$0(3);
        }
        return actions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionWrapper", "getChildren"));
    }

    public static class SuppressTreeAction
    extends KeyAwareInspectionViewAction {
        private final SuppressIntentionAction mySuppressAction;

        public SuppressTreeAction(SuppressIntentionAction suppressAction) {
            super(suppressAction.getText());
            this.mySuppressAction = suppressAction;
        }

        @Override
        protected void actionPerformed(@NotNull InspectionResultsView view, @NotNull HighlightDisplayKey key) {
            if (view == null) {
                SuppressTreeAction.$$$reportNull$$$0(0);
            }
            if (key == null) {
                SuppressTreeAction.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (view == null) {
                    SuppressTreeAction.$$$reportNull$$$0(4);
                }
                Project project = view.getProject();
                String templatePresentationText = this.getTemplatePresentation().getText();
                LOG.assertTrue(templatePresentationText != null);
                InspectionToolWrapper wrapper = view.getTree().getSelectedToolWrapper(true);
                LOG.assertTrue(wrapper != null);
                Set<SuppressableInspectionTreeNode> nodesAsSet = this.getNodesToSuppress(view);
                SuppressableInspectionTreeNode[] nodes = nodesAsSet.toArray(new SuppressableInspectionTreeNode[0]);
                CommandProcessor.getInstance().executeCommand(project, () -> {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                    SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, templatePresentationText, true);
                    progressTask.setMinIterationTime(200L);
                    progressTask.setTask(new SuppressActionSequentialTask(nodes, this.mySuppressAction, wrapper));
                    ProgressManager.getInstance().run((Task)progressTask);
                }, templatePresentationText, null);
                Set<GlobalInspectionContextImpl> globalInspectionContexts = ((InspectionManagerEx)InspectionManager.getInstance((Project)project)).getRunningContexts();
                for (GlobalInspectionContextImpl context : globalInspectionContexts) {
                    context.refreshViews();
                }
                view.syncRightPanel();
            });
        }

        @Override
        protected boolean isEnabled(@NotNull InspectionResultsView view, AnActionEvent e) {
            Set<SuppressableInspectionTreeNode> nodesToSuppress;
            if (view == null) {
                SuppressTreeAction.$$$reportNull$$$0(2);
            }
            if ((nodesToSuppress = this.getNodesToSuppress(view)).isEmpty()) {
                return false;
            }
            if (nodesToSuppress.size() == 1) {
                PsiElement element = (PsiElement)((SuppressableInspectionTreeNode)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(nodesToSuppress))).getSuppressContent().getFirst();
                String text = this.mySuppressAction.getFamilyName();
                if (element != null) {
                    this.mySuppressAction.isAvailable(view.getProject(), null, element);
                    text = this.mySuppressAction.getText();
                }
                e.getPresentation().setText(text);
                return true;
            }
            e.getPresentation().setText(this.mySuppressAction.getFamilyName());
            return true;
        }

        public boolean isSuppressAll() {
            return this.mySuppressAction.isSuppressAll();
        }

        private Set<SuppressableInspectionTreeNode> getNodesToSuppress(@NotNull InspectionResultsView view) {
            TreePath[] paths;
            if (view == null) {
                SuppressTreeAction.$$$reportNull$$$0(3);
            }
            if ((paths = view.getTree().getSelectionPaths()) == null) {
                return Collections.emptySet();
            }
            HashSet<SuppressableInspectionTreeNode> result2 = new HashSet<SuppressableInspectionTreeNode>();
            for (TreePath path : paths) {
                Object node = path.getLastPathComponent();
                if (!(node instanceof TreeNode) || TreeUtil.treeNodeTraverser((TreeNode)((TreeNode)node)).traverse().processEach(node1 -> {
                    InspectionTreeNode n = (InspectionTreeNode)node1;
                    if (n instanceof SuppressableInspectionTreeNode && ((SuppressableInspectionTreeNode)n).canSuppress() && n.isValid()) {
                        if (((SuppressableInspectionTreeNode)n).getAvailableSuppressActions().contains(this.mySuppressAction)) {
                            result2.add((SuppressableInspectionTreeNode)n);
                        } else {
                            return false;
                        }
                    }
                    return true;
                })) continue;
                return Collections.emptySet();
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/ui/actions/suppress/SuppressActionWrapper$SuppressTreeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNodesToSuppress";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$actionPerformed$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

