/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.LightToolWindowContent;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.openapi.wm.impl.StripeButtonUI;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightToolWindow
extends JPanel {
    static final String LEFT_MIN_KEY = "left";
    static final String RIGHT_MIN_KEY = "right";
    static final int MINIMIZE_WIDTH = 25;
    private static final String IGNORE_WIDTH_KEY = "ignore_width";
    private final LightToolWindowContent myContent;
    private final JComponent myFocusedComponent;
    private final ThreeComponentsSplitter myContentSplitter;
    private ToolWindowAnchor myAnchor;
    private final Project myProject;
    private final LightToolWindowManager myManager;
    private final PropertiesComponent myPropertiesComponent;
    private boolean myShowContent;
    private final String myShowStateKey;
    private int myCurrentWidth;
    private final String myWidthKey;
    private final JPanel myMinimizeComponent;
    private final AnchoredButton myMinimizeButton;
    private final JPanel myActionPanel;
    private final TogglePinnedModeAction myToggleAutoHideModeAction;
    private final ToggleDockModeAction myToggleDockModeAction;
    private final ToggleFloatingModeAction myToggleFloatingModeAction;
    private final ToggleWindowedModeAction myToggleWindowedModeAction;
    private final ToggleSideModeAction myToggleSideModeAction;
    private final ComponentListener myWidthListener;

    public LightToolWindow(@NotNull LightToolWindowContent content, @NotNull String title, @NotNull Icon icon, @NotNull JComponent component, @NotNull JComponent focusedComponent, @NotNull ThreeComponentsSplitter contentSplitter, @Nullable ToolWindowAnchor anchor2, @NotNull LightToolWindowManager manager, @NotNull Project project, @NotNull PropertiesComponent propertiesComponent, @NotNull String key, int defaultWidth, @Nullable AnAction[] actions) {
        if (content == null) {
            LightToolWindow.$$$reportNull$$$0(0);
        }
        if (title == null) {
            LightToolWindow.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            LightToolWindow.$$$reportNull$$$0(2);
        }
        if (component == null) {
            LightToolWindow.$$$reportNull$$$0(3);
        }
        if (focusedComponent == null) {
            LightToolWindow.$$$reportNull$$$0(4);
        }
        if (contentSplitter == null) {
            LightToolWindow.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            LightToolWindow.$$$reportNull$$$0(6);
        }
        if (project == null) {
            LightToolWindow.$$$reportNull$$$0(7);
        }
        if (propertiesComponent == null) {
            LightToolWindow.$$$reportNull$$$0(8);
        }
        if (key == null) {
            LightToolWindow.$$$reportNull$$$0(9);
        }
        super(new BorderLayout());
        this.myToggleAutoHideModeAction = new TogglePinnedModeAction();
        this.myToggleDockModeAction = new ToggleDockModeAction();
        this.myToggleFloatingModeAction = new ToggleFloatingModeAction();
        this.myToggleWindowedModeAction = new ToggleWindowedModeAction();
        this.myToggleSideModeAction = new ToggleSideModeAction();
        this.myWidthListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int width;
                int n = width = LightToolWindow.this.isLeft() ? LightToolWindow.this.myContentSplitter.getFirstSize() : LightToolWindow.this.myContentSplitter.getLastSize();
                if (width > 0 && width != LightToolWindow.this.myCurrentWidth && LightToolWindow.this.myContentSplitter.getInnerComponent().getClientProperty(LightToolWindow.IGNORE_WIDTH_KEY) == null) {
                    LightToolWindow.this.myCurrentWidth = width;
                    LightToolWindow.this.myPropertiesComponent.setValue(LightToolWindow.this.myWidthKey, Integer.toString(width));
                }
            }
        };
        this.myContent = content;
        this.myFocusedComponent = focusedComponent;
        this.myContentSplitter = contentSplitter;
        this.myAnchor = anchor2;
        this.myProject = project;
        this.myManager = manager;
        this.myPropertiesComponent = propertiesComponent;
        this.myShowStateKey = "UI_DESIGNER_EDITOR_MODE." + key + ".SHOW";
        this.myWidthKey = "UI_DESIGNER_EDITOR_MODE." + key + ".WIDTH";
        HeaderPanel header = new HeaderPanel();
        header.setLayout(new BorderLayout());
        this.add((Component)header, "North");
        JLabel titleLabel = new JLabel(title);
        titleLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)5, (int)2, (int)10));
        titleLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        header.add((Component)titleLabel, "Center");
        this.myActionPanel = new JPanel(new FlowLayout(1, 5, 0));
        this.myActionPanel.setBorder((Border)JBUI.Borders.empty((int)3, (int)0, (int)2, (int)0));
        this.myActionPanel.setOpaque(false);
        header.add((Component)this.myActionPanel, "East");
        if (actions != null) {
            for (AnAction action : actions) {
                this.addAction(this.myActionPanel, action);
            }
            this.myActionPanel.add(new JLabel(AllIcons.General.Divider));
        }
        this.addAction(this.myActionPanel, new GearAction());
        this.addAction(this.myActionPanel, new HideAction());
        JPanel contentWrapper = new JPanel(new BorderLayout());
        contentWrapper.setBorder(IdeBorderFactory.createBorder((int)2));
        contentWrapper.add((Component)component, "Center");
        this.add((Component)contentWrapper, "Center");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                IdeFocusManager.getInstance((Project)LightToolWindow.this.myProject).requestFocus((Component)LightToolWindow.this.myFocusedComponent, true);
            }
        });
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component component, int x, int y) {
                LightToolWindow.this.showGearPopup(component, x, y);
            }
        });
        this.myMinimizeButton = new AnchoredButton(title, icon){

            @Override
            public void updateUI() {
                this.setUI(StripeButtonUI.createUI(this));
                this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            }

            @Override
            public int getMnemonic2() {
                return 0;
            }

            @Override
            public ToolWindowAnchor getAnchor() {
                return LightToolWindow.this.myAnchor;
            }
        };
        this.myMinimizeButton.addActionListener(e -> {
            this.myMinimizeButton.setSelected(false);
            this.updateContent(true, true);
        });
        this.myMinimizeButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.myMinimizeButton.setFocusable(false);
        this.myMinimizeButton.setRolloverEnabled(true);
        this.myMinimizeButton.setOpaque(false);
        this.myMinimizeComponent = new JPanel(){

            @Override
            public void doLayout() {
                Dimension size = LightToolWindow.this.myMinimizeButton.getPreferredSize();
                if (LightToolWindow.this.myAnchor == ToolWindowAnchor.BOTTOM) {
                    LightToolWindow.this.myMinimizeButton.setBounds(0, 1, size.width, 25);
                } else {
                    LightToolWindow.this.myMinimizeButton.setBounds(0, 0, this.getWidth(), size.height);
                }
            }
        };
        this.myMinimizeComponent.add(this.myMinimizeButton);
        this.configureBorder();
        this.configureWidth(defaultWidth);
        this.updateContent(this.myPropertiesComponent.getBoolean(this.myShowStateKey, true), false);
    }

    private void configureBorder() {
        int borderStyle;
        if (this.myAnchor == ToolWindowAnchor.LEFT) {
            borderStyle = 4;
        } else if (this.myAnchor == ToolWindowAnchor.RIGHT) {
            borderStyle = 1;
        } else if (this.myAnchor == ToolWindowAnchor.BOTTOM) {
            borderStyle = 2;
        } else {
            return;
        }
        this.setBorder(IdeBorderFactory.createBorder((int)borderStyle));
        this.myMinimizeComponent.setBorder(IdeBorderFactory.createBorder((int)borderStyle));
    }

    private void configureWidth(int defaultWidth) {
        this.myCurrentWidth = this.myPropertiesComponent.getInt(this.myWidthKey, defaultWidth);
        this.updateWidth();
        this.myContentSplitter.getInnerComponent().addComponentListener(this.myWidthListener);
    }

    private void updateWidth() {
        if (this.isLeft()) {
            this.myContentSplitter.setFirstSize(this.myCurrentWidth);
        } else {
            this.myContentSplitter.setLastSize(this.myCurrentWidth);
        }
    }

    void updateAnchor(ToolWindowAnchor newAnchor) {
        String key;
        JComponent minimizeParent = this.myContentSplitter.getInnerComponent();
        minimizeParent.putClientProperty(IGNORE_WIDTH_KEY, Boolean.TRUE);
        if (this.myShowContent) {
            JComponent oldWindow;
            JComponent jComponent = oldWindow = this.isLeft() ? this.myContentSplitter.getFirstComponent() : this.myContentSplitter.getLastComponent();
            if (oldWindow == this) {
                this.setContentComponent(null);
            }
        }
        if (minimizeParent.getClientProperty(key = this.getMinKey()) == this.myMinimizeComponent) {
            minimizeParent.putClientProperty(key, null);
        }
        minimizeParent.putClientProperty(this.isLeft() ? RIGHT_MIN_KEY : LEFT_MIN_KEY, this.myMinimizeComponent);
        minimizeParent.revalidate();
        this.myAnchor = newAnchor;
        this.updateHideIcons();
        this.configureBorder();
        this.updateWidth();
        if (this.myShowContent) {
            this.setContentComponent(this);
        }
        minimizeParent.putClientProperty(IGNORE_WIDTH_KEY, null);
    }

    private void updateHideIcons() {
        this.myActionPanel.remove(this.myActionPanel.getComponentCount() - 1);
        this.addAction(this.myActionPanel, new HideAction());
    }

    private void updateContent(boolean show, boolean flag) {
        this.myShowContent = show;
        String key = this.getMinKey();
        JComponent minimizeParent = this.myContentSplitter.getInnerComponent();
        if (show) {
            minimizeParent.putClientProperty(key, null);
            minimizeParent.remove(this.myMinimizeComponent);
        }
        this.setContentComponent(show ? this : null);
        if (!show) {
            minimizeParent.putClientProperty(key, this.myMinimizeComponent);
            minimizeParent.add(this.myMinimizeComponent);
        }
        minimizeParent.revalidate();
        if (flag) {
            this.myPropertiesComponent.setValue(this.myShowStateKey, Boolean.toString(show));
        }
    }

    private void setContentComponent(JComponent component) {
        if (this.isLeft()) {
            this.myContentSplitter.setFirstComponent(component);
        } else {
            this.myContentSplitter.setLastComponent(component);
        }
    }

    public void dispose() {
        JComponent minimizeParent = this.myContentSplitter.getInnerComponent();
        minimizeParent.removeComponentListener(this.myWidthListener);
        this.setContentComponent(null);
        this.myContent.dispose();
        if (!this.myShowContent) {
            minimizeParent.putClientProperty(this.getMinKey(), null);
            minimizeParent.remove(this.myMinimizeComponent);
            minimizeParent.revalidate();
        }
    }

    private String getMinKey() {
        return this.isLeft() ? LEFT_MIN_KEY : RIGHT_MIN_KEY;
    }

    public Object getContent() {
        return this.myContent;
    }

    private boolean isLeft() {
        return this.myAnchor == ToolWindowAnchor.LEFT;
    }

    private boolean isActive() {
        IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
        Component component = fm.getFocusedDescendantFor((Component)this);
        if (component != null) {
            return true;
        }
        Component owner = fm.getLastFocusedFor(WindowManager.getInstance().getIdeFrame(this.myProject));
        return owner != null && SwingUtilities.isDescendingFrom(owner, this);
    }

    private void addAction(JPanel actionPanel, AnAction action) {
        actionPanel.add((Component)((Object)new ActionButton(action)));
    }

    private DefaultActionGroup createGearPopupGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(this.myManager.createGearActions());
        group.addSeparator();
        ToolWindowType type = this.myManager.getToolWindow().getType();
        if (type == ToolWindowType.DOCKED) {
            group.add((AnAction)this.myToggleAutoHideModeAction);
            group.add((AnAction)this.myToggleDockModeAction);
            group.add((AnAction)this.myToggleFloatingModeAction);
            group.add((AnAction)this.myToggleWindowedModeAction);
            group.add((AnAction)this.myToggleSideModeAction);
        } else if (type == ToolWindowType.FLOATING || type == ToolWindowType.WINDOWED) {
            group.add((AnAction)this.myToggleAutoHideModeAction);
            group.add((AnAction)this.myToggleFloatingModeAction);
            group.add((AnAction)this.myToggleWindowedModeAction);
        } else if (type == ToolWindowType.SLIDING) {
            group.add((AnAction)this.myToggleDockModeAction);
            group.add((AnAction)this.myToggleFloatingModeAction);
            group.add((AnAction)this.myToggleWindowedModeAction);
        }
        return group;
    }

    private void showGearPopup(Component component, int x, int y) {
        ActionPopupMenu popupMenu = ((ActionManagerImpl)ActionManager.getInstance()).createActionPopupMenu("ToolwindowPopup", (ActionGroup)this.createGearPopupGroup(), new MenuItemPresentationFactory(true));
        popupMenu.getComponent().show(component, x, y);
    }

    public void minimize() {
        this.updateContent(false, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "content";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "icon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "focusedComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "contentSplitter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[0] = "propertiesComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[0] = "key";
                break;
            }
        }
        objectArray[1] = "com/intellij/designer/LightToolWindow";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HeaderPanel
    extends JPanel {
        private HeaderPanel() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(size.width, TabsUtil.getTabsHeight());
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension size = super.getMinimumSize();
            return new Dimension(size.width, TabsUtil.getTabsHeight());
        }
    }

    private class ActionButton
    extends Wrapper
    implements ActionListener {
        private final AnAction myAction;

        public ActionButton(AnAction action) {
            this.myAction = action;
            Presentation presentation = action.getTemplatePresentation();
            InplaceButton button = new InplaceButton(KeymapUtil.createTooltipText((String)presentation.getText(), (AnAction)action), EmptyIcon.ICON_16, this){

                public boolean isActive() {
                    return LightToolWindow.this.isActive();
                }
            };
            button.setHoveringEnabled(!SystemInfo.isMac);
            this.setContent((JComponent)button);
            Icon icon = presentation.getIcon();
            Icon hoveredIcon = presentation.getHoveredIcon();
            button.setIcons(icon, icon, hoveredIcon == null ? icon : hoveredIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InputEvent inputEvent = e.getSource() instanceof InputEvent ? (InputEvent)e.getSource() : null;
            this.myAction.actionPerformed(AnActionEvent.createFromInputEvent((AnAction)this.myAction, (InputEvent)inputEvent, (String)"unknown"));
        }
    }

    private class ToggleSideModeAction
    extends ToggleAction {
        public ToggleSideModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction("ToggleSideMode"));
        }

        public boolean isSelected(AnActionEvent e) {
            return LightToolWindow.this.myManager.getToolWindow().isSplitMode();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            LightToolWindow.this.myManager.getToolWindow().setSplitMode(state, null);
            LightToolWindow.this.myManager.setEditorMode(null);
        }
    }

    private class ToggleTypeModeAction
    extends ToggleAction {
        private final ToolWindowType myType;

        ToggleTypeModeAction(@NotNull ToolWindowType type, String id) {
            if (type == null) {
                ToggleTypeModeAction.$$$reportNull$$$0(0);
            }
            if (id == null) {
                ToggleTypeModeAction.$$$reportNull$$$0(1);
            }
            this.myType = type;
            this.copyFrom(ActionManager.getInstance().getAction(id));
        }

        public boolean isSelected(AnActionEvent e) {
            return LightToolWindow.this.myManager.getToolWindow().getType() == this.myType;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ToolWindow window = LightToolWindow.this.myManager.getToolWindow();
            ToolWindowType type = window.getType();
            if (type == this.myType) {
                window.setType(((ToolWindowEx)window).getInternalType(), null);
            } else {
                window.setType(this.myType, null);
            }
            LightToolWindow.this.myManager.setEditorMode(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
            }
            objectArray[1] = "com/intellij/designer/LightToolWindow$ToggleTypeModeAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ToggleWindowedModeAction
    extends ToggleTypeModeAction {
        ToggleWindowedModeAction() {
            super(ToolWindowType.WINDOWED, "ToggleWindowedMode");
        }
    }

    private class ToggleFloatingModeAction
    extends ToggleTypeModeAction {
        public ToggleFloatingModeAction() {
            super(ToolWindowType.FLOATING, "ToggleFloatingMode");
        }
    }

    private class ToggleDockModeAction
    extends ToggleTypeModeAction {
        public ToggleDockModeAction() {
            super(ToolWindowType.DOCKED, "ToggleDockMode");
        }

        @Override
        public void setSelected(AnActionEvent e, boolean state) {
            ToolWindow window = LightToolWindow.this.myManager.getToolWindow();
            ToolWindowType type = window.getType();
            if (type == ToolWindowType.DOCKED) {
                window.setType(ToolWindowType.SLIDING, null);
            } else if (type == ToolWindowType.SLIDING) {
                window.setType(ToolWindowType.DOCKED, null);
            }
            LightToolWindow.this.myManager.setEditorMode(null);
        }
    }

    private class TogglePinnedModeAction
    extends ToggleAction {
        public TogglePinnedModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction("TogglePinnedMode"));
        }

        public boolean isSelected(AnActionEvent e) {
            return !LightToolWindow.this.myManager.getToolWindow().isAutoHide();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ToolWindow window;
            window.setAutoHide(!(window = LightToolWindow.this.myManager.getToolWindow()).isAutoHide());
            LightToolWindow.this.myManager.setEditorMode(null);
        }
    }

    private class HideAction
    extends AnAction {
        public HideAction() {
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(UIBundle.message((String)"tool.window.hide.action.name", (Object[])new Object[0]));
            if (LightToolWindow.this.myAnchor == ToolWindowAnchor.LEFT) {
                presentation.setIcon(AllIcons.General.HideLeftPart);
                presentation.setHoveredIcon(AllIcons.General.HideLeftPartHover);
            } else if (LightToolWindow.this.myAnchor == ToolWindowAnchor.RIGHT) {
                presentation.setIcon(AllIcons.General.HideRightPart);
                presentation.setHoveredIcon(AllIcons.General.HideRightPartHover);
            } else if (LightToolWindow.this.myAnchor == ToolWindowAnchor.BOTTOM) {
                presentation.setIcon(AllIcons.General.HideDownPart);
                presentation.setHoveredIcon(AllIcons.General.HideDownPartHover);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            LightToolWindow.this.updateContent(false, true);
        }
    }

    private class GearAction
    extends AnAction {
        GearAction() {
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.General.Gear);
            presentation.setHoveredIcon(AllIcons.General.GearHover);
        }

        public void actionPerformed(AnActionEvent e) {
            int x = 0;
            int y = 0;
            InputEvent inputEvent = e.getInputEvent();
            if (inputEvent instanceof MouseEvent) {
                x = ((MouseEvent)inputEvent).getX();
                y = ((MouseEvent)inputEvent).getY();
            }
            LightToolWindow.this.showGearPopup(inputEvent.getComponent(), x, y);
        }
    }
}

