/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.LightToolWindowContent;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightToolWindowManager
implements Disposable {
    public static final String EDITOR_MODE = "UI_DESIGNER_EDITOR_MODE.";
    private final MergingUpdateQueue myWindowQueue = new MergingUpdateQueue(this.getComponentName(), 200, true, null, (Disposable)this);
    protected final Project myProject;
    protected final FileEditorManager myFileEditorManager;
    protected volatile ToolWindow myToolWindow;
    private final PropertiesComponent myPropertiesComponent;
    public final String myEditorModeKey;
    private ToggleEditorModeAction myLeftEditorModeAction;
    private ToggleEditorModeAction myRightEditorModeAction;
    private MessageBusConnection myConnection;
    private final Consumer<DesignerEditorPanelFacade> myCreateAction = designer -> designer.putClientProperty(this.getComponentName(), this.createContent((DesignerEditorPanelFacade)designer));
    private final Consumer<DesignerEditorPanelFacade> myUpdateAnchorAction = designer -> {
        LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty(this.getComponentName());
        if (toolWindow != null) {
            toolWindow.updateAnchor(this.getEditorMode());
        }
    };
    private final Consumer<DesignerEditorPanelFacade> myDisposeAction = designer -> this.disposeContent((DesignerEditorPanelFacade)designer);

    protected LightToolWindowManager(Project project, FileEditorManager fileEditorManager) {
        this.myProject = project;
        this.myFileEditorManager = fileEditorManager;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        this.myEditorModeKey = EDITOR_MODE + this.getComponentName() + ".STATE";
        ProjectUtil.runWhenProjectOpened((Project)project, () -> this.projectOpened());
    }

    protected void projectOpened() {
        this.initToolWindow();
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> {
            if (this.getEditorMode() == null) {
                this.initListeners();
                this.bindToDesigner(this.getActiveDesigner());
            }
        }));
    }

    private void initListeners() {
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                LightToolWindowManager.this.bindToDesigner(LightToolWindowManager.this.getActiveDesigner());
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                ApplicationManager.getApplication().invokeLater(() -> LightToolWindowManager.this.bindToDesigner(LightToolWindowManager.this.getActiveDesigner()));
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(4);
                }
                LightToolWindowManager.this.bindToDesigner(LightToolWindowManager.this.getDesigner(event.getNewEditor()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/designer/LightToolWindowManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void removeListeners() {
        this.myConnection.disconnect();
        this.myConnection = null;
    }

    @Nullable
    protected abstract DesignerEditorPanelFacade getDesigner(FileEditor var1);

    @Nullable
    public DesignerEditorPanelFacade getActiveDesigner() {
        for (FileEditor editor : this.myFileEditorManager.getSelectedEditors()) {
            DesignerEditorPanelFacade designer = this.getDesigner(editor);
            if (designer == null) continue;
            return designer;
        }
        return null;
    }

    private void bindToDesigner(final DesignerEditorPanelFacade designer) {
        this.myWindowQueue.cancelAllUpdates();
        this.myWindowQueue.queue(new Update("update"){

            public void run() {
                if (LightToolWindowManager.this.myToolWindow == null) {
                    if (designer == null) {
                        return;
                    }
                    LightToolWindowManager.this.initToolWindow();
                }
                LightToolWindowManager.this.updateToolWindow(designer);
            }
        });
    }

    protected abstract void initToolWindow();

    protected abstract void updateToolWindow(@Nullable DesignerEditorPanelFacade var1);

    protected final void initGearActions() {
        ToolWindowEx toolWindow = (ToolWindowEx)this.myToolWindow;
        toolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{this.createGearActions()}));
    }

    protected abstract ToolWindowAnchor getAnchor();

    public AnAction createGearActions() {
        DefaultActionGroup group = new DefaultActionGroup("In Editor Mode", true);
        if (this.myLeftEditorModeAction == null) {
            this.myLeftEditorModeAction = this.createToggleAction(ToolWindowAnchor.LEFT);
        }
        group.add((AnAction)this.myLeftEditorModeAction);
        if (this.myRightEditorModeAction == null) {
            this.myRightEditorModeAction = this.createToggleAction(ToolWindowAnchor.RIGHT);
        }
        group.add((AnAction)this.myRightEditorModeAction);
        return group;
    }

    protected abstract ToggleEditorModeAction createToggleAction(ToolWindowAnchor var1);

    public final void bind(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            LightToolWindowManager.$$$reportNull$$$0(0);
        }
        if (this.isEditorMode()) {
            this.myCreateAction.accept(designer);
        }
    }

    public final void dispose(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            LightToolWindowManager.$$$reportNull$$$0(1);
        }
        if (this.isEditorMode()) {
            this.disposeContent(designer);
        }
    }

    protected final Object getContent(@NotNull DesignerEditorPanelFacade designer) {
        LightToolWindow toolWindow;
        if (designer == null) {
            LightToolWindowManager.$$$reportNull$$$0(2);
        }
        return (toolWindow = (LightToolWindow)designer.getClientProperty(this.getComponentName())) == null ? null : toolWindow.getContent();
    }

    protected abstract LightToolWindow createContent(@NotNull DesignerEditorPanelFacade var1);

    protected final LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer, @NotNull LightToolWindowContent content, @NotNull String title, @NotNull Icon icon, @NotNull JComponent component, @NotNull JComponent focusedComponent, int defaultWidth, @Nullable AnAction[] actions) {
        if (designer == null) {
            LightToolWindowManager.$$$reportNull$$$0(3);
        }
        if (content == null) {
            LightToolWindowManager.$$$reportNull$$$0(4);
        }
        if (title == null) {
            LightToolWindowManager.$$$reportNull$$$0(5);
        }
        if (icon == null) {
            LightToolWindowManager.$$$reportNull$$$0(6);
        }
        if (component == null) {
            LightToolWindowManager.$$$reportNull$$$0(7);
        }
        if (focusedComponent == null) {
            LightToolWindowManager.$$$reportNull$$$0(8);
        }
        return new LightToolWindow(content, title, icon, component, focusedComponent, designer.getContentSplitter(), this.getEditorMode(), this, this.myProject, this.myPropertiesComponent, this.getComponentName(), defaultWidth, actions);
    }

    protected final void disposeContent(DesignerEditorPanelFacade designer) {
        String key = this.getComponentName();
        LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty(key);
        designer.putClientProperty(key, null);
        if (toolWindow != null) {
            toolWindow.dispose();
        }
    }

    private void runUpdateContent(Consumer<DesignerEditorPanelFacade> action) {
        for (FileEditor editor : this.myFileEditorManager.getAllEditors()) {
            DesignerEditorPanelFacade designer = this.getDesigner(editor);
            if (designer == null) continue;
            action.accept(designer);
        }
    }

    protected final boolean isEditorMode() {
        return this.getEditorMode() != null;
    }

    @Nullable
    public final ToolWindowAnchor getEditorMode() {
        String value = this.myPropertiesComponent.getValue(this.myEditorModeKey);
        if (value == null) {
            return this.getAnchor();
        }
        return value.equals("ToolWindow") ? null : ToolWindowAnchor.fromText((String)value);
    }

    protected final void setEditorMode(@Nullable ToolWindowAnchor newState) {
        ToolWindowAnchor oldState = this.getEditorMode();
        this.myPropertiesComponent.setValue(this.myEditorModeKey, newState == null ? "ToolWindow" : newState.toString());
        if (oldState != null && newState != null) {
            this.runUpdateContent(this.myUpdateAnchorAction);
        } else if (newState != null) {
            this.removeListeners();
            this.updateToolWindow(null);
            this.runUpdateContent(this.myCreateAction);
        } else {
            this.runUpdateContent(this.myDisposeAction);
            this.initListeners();
            this.bindToDesigner(this.getActiveDesigner());
        }
    }

    final ToolWindow getToolWindow() {
        return this.myToolWindow;
    }

    public void dispose() {
        this.myToolWindow = null;
    }

    @NotNull
    protected String getComponentName() {
        String string = this.getClass().getName();
        if (string == null) {
            LightToolWindowManager.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusedComponent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/LightToolWindowManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/LightToolWindowManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bind";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

