/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.InputStream;

class WinProcessManager {
    private static final Logger LOG = Logger.getInstance(WinProcessManager.class);

    private WinProcessManager() {
    }

    public static int getProcessId(Process process2) {
        String processClassName = process2.getClass().getName();
        if (processClassName.equals("java.lang.Win32Process") || processClassName.equals("java.lang.ProcessImpl")) {
            try {
                if (SystemInfo.IS_AT_LEAST_JAVA9) {
                    return ((Long)Process.class.getMethod("pid", new Class[0]).invoke((Object)process2, new Object[0])).intValue();
                }
                long handle = (Long)ObjectUtils.assertNotNull((Object)ReflectionUtil.getField(process2.getClass(), (Object)process2, Long.TYPE, (String)"handle"));
                return Kernel32.INSTANCE.GetProcessId(new WinNT.HANDLE(Pointer.createConstant((long)handle)));
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to get PID from instance of " + process2.getClass() + ", OS: " + SystemInfo.OS_NAME, t);
            }
        }
        throw new IllegalStateException("Unable to get PID from instance of " + process2.getClass() + ", OS: " + SystemInfo.OS_NAME);
    }

    public static boolean kill(Process process2, boolean tree) {
        return WinProcessManager.kill(-1, process2, tree);
    }

    public static boolean kill(int pid, boolean tree) {
        return WinProcessManager.kill(pid, null, tree);
    }

    private static boolean kill(int pid, Process process2, boolean tree) {
        LOG.assertTrue(pid > 0 || process2 != null);
        try {
            if (process2 != null) {
                pid = WinProcessManager.getProcessId(process2);
            }
            String[] cmdArray = new String[]{"taskkill", "/f", "/pid", String.valueOf(pid), tree ? "/t" : ""};
            if (LOG.isDebugEnabled()) {
                LOG.debug(StringUtil.join((String[])cmdArray, (String)" "));
            }
            Process p = new ProcessBuilder(cmdArray).redirectErrorStream(true).start();
            String output = FileUtil.loadTextAndClose((InputStream)p.getInputStream());
            int res = p.waitFor();
            if (res != 0 && (process2 == null || process2.isAlive())) {
                LOG.warn(StringUtil.join((String[])cmdArray, (String)" ") + " failed: " + output);
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(output);
            }
            return true;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    public static int getProcessPid(Process process2) {
        return WinProcessManager.getProcessId(process2);
    }
}

