/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.BaseStartedNodeEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralIdBasedToSMTRunnerEventsConvertor
extends GeneralTestEventsProcessor {
    private static final Logger LOG = Logger.getInstance(GeneralIdBasedToSMTRunnerEventsConvertor.class);
    private final HashMap<String, Node> myNodeByIdMap;
    private final Set<Node> myRunningTestNodes;
    private final Set<Node> myRunningSuiteNodes;
    private final Node myTestsRootNode;
    private boolean myIsTestingFinished;
    private TestProxyPrinterProvider myTestProxyPrinterProvider;

    public GeneralIdBasedToSMTRunnerEventsConvertor(Project project, @NotNull SMTestProxy.SMRootTestProxy testsRootProxy, @NotNull String testFrameworkName) {
        if (testsRootProxy == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(0);
        }
        if (testFrameworkName == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(1);
        }
        super(project, testFrameworkName, testsRootProxy);
        this.myNodeByIdMap = new HashMap();
        this.myRunningTestNodes = ContainerUtil.newHashSet();
        this.myRunningSuiteNodes = ContainerUtil.newHashSet();
        this.myIsTestingFinished = false;
        this.myTestProxyPrinterProvider = null;
        this.myTestsRootNode = new Node("0", null, testsRootProxy);
        this.myNodeByIdMap.put((Object)this.myTestsRootNode.getId(), (Object)this.myTestsRootNode);
    }

    @Override
    public void onStartTesting() {
        LOG.debug("onStartTesting");
        this.addToInvokeLater(() -> {
            LOG.debug("onStartTesting: invoked");
            this.myTestsRootNode.setState(State.RUNNING, this);
            this.myTestsRootProxy.setStarted();
            this.fireOnTestingStarted(this.myTestsRootProxy);
        });
    }

    @Override
    public void onTestsReporterAttached() {
        this.addToInvokeLater(() -> GeneralIdBasedToSMTRunnerEventsConvertor.fireOnTestsReporterAttached(this.myTestsRootProxy));
    }

    @Override
    public void onFinishTesting() {
        LOG.debug("onFinishTesting");
        this.addToInvokeLater(() -> {
            LOG.debug("onFinishTesting: invoked");
            if (this.myIsTestingFinished) {
                LOG.debug("has already been invoked");
                return;
            }
            this.myIsTestingFinished = true;
            boolean completeTree = GeneralIdBasedToSMTRunnerEventsConvertor.isTreeComplete(this.myRunningTestNodes, this.myTestsRootProxy);
            if (LOG.isDebugEnabled()) {
                LOG.debug("completeTree:" + completeTree);
            }
            if (completeTree) {
                this.myTestsRootProxy.setFinished();
            } else {
                this.myTestsRootProxy.setTerminated();
            }
            if (!this.myRunningTestNodes.isEmpty()) {
                this.logProblem("Unexpected running nodes: " + this.myRunningTestNodes);
            }
            this.myNodeByIdMap.clear();
            this.myRunningTestNodes.clear();
            this.myRunningSuiteNodes.clear();
            this.fireOnTestingFinished(this.myTestsRootProxy);
        });
        super.onFinishTesting();
    }

    @Override
    public void setPrinterProvider(@NotNull TestProxyPrinterProvider printerProvider) {
        if (printerProvider == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(2);
        }
        this.myTestProxyPrinterProvider = printerProvider;
    }

    @Override
    public void onTestStarted(@NotNull TestStartedEvent testStartedEvent) {
        if (testStartedEvent == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("onTestStarted " + testStartedEvent.getId());
        }
        this.addToInvokeLater(() -> {
            if (testStartedEvent == null) {
                GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(36);
            }
            this.doStartNode(testStartedEvent, false);
        });
    }

    @Override
    public void onSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        if (suiteStartedEvent == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(4);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("onSuiteStarted " + suiteStartedEvent.getId());
        }
        this.addToInvokeLater(() -> {
            if (suiteStartedEvent == null) {
                GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(35);
            }
            this.doStartNode(suiteStartedEvent, true);
        });
    }

    private void doStartNode(@NotNull BaseStartedNodeEvent startedNodeEvent, boolean suite) {
        Node node;
        if (startedNodeEvent == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(5);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("doStartNode " + startedNodeEvent.getId());
        }
        if ((node = this.findNode(startedNodeEvent)) != null) {
            if (node.getState() == State.NOT_RUNNING && startedNodeEvent.isRunning()) {
                this.setNodeAndAncestorsRunning(node);
            } else {
                this.logProblem(startedNodeEvent + " has been already started: " + node + "!");
            }
            return;
        }
        node = this.createNode(startedNodeEvent, suite);
        if (node == null) {
            return;
        }
        if (startedNodeEvent.isRunning()) {
            this.setNodeAndAncestorsRunning(node);
        }
    }

    private Node createNode(@NotNull BaseStartedNodeEvent startedNodeEvent, boolean suite) {
        Printer printer;
        Node parentNode;
        if (startedNodeEvent == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(6);
        }
        if ((parentNode = this.findValidParentNode(startedNodeEvent)) == null) {
            return null;
        }
        String nodeId = this.validateAndGetNodeId(startedNodeEvent);
        if (nodeId == null) {
            return null;
        }
        String nodeName = startedNodeEvent.getName();
        SMTestProxy childProxy = new SMTestProxy(nodeName, suite, startedNodeEvent.getLocationUrl(), startedNodeEvent.getMetainfo(), true);
        childProxy.putUserData(SMTestProxy.NODE_ID, startedNodeEvent.getId());
        childProxy.setTreeBuildBeforeStart();
        TestProxyPrinterProvider printerProvider = this.myTestProxyPrinterProvider;
        String nodeType = startedNodeEvent.getNodeType();
        if (printerProvider != null && nodeType != null && nodeName != null && (printer = printerProvider.getPrinterByType(nodeType, nodeName, startedNodeEvent.getNodeArgs())) != null) {
            childProxy.setPreferredPrinter(printer);
        }
        Node node = new Node(nodeId, parentNode, childProxy);
        this.myNodeByIdMap.put((Object)startedNodeEvent.getId(), (Object)node);
        if (this.myLocator != null) {
            childProxy.setLocator(this.myLocator);
        }
        parentNode.getProxy().addChild(childProxy);
        return node;
    }

    @Override
    protected SMTestProxy createSuite(String suiteName, String locationHint, String metaInfo, String id, String parentNodeId) {
        Node node = this.createNode(new TestSuiteStartedEvent(suiteName, id, parentNodeId, locationHint, metaInfo, null, null, false), true);
        return node.getProxy();
    }

    @Override
    protected SMTestProxy createProxy(String testName, String locationHint, String metaInfo, String id, String parentNodeId) {
        Node node = this.createNode(new TestStartedEvent(testName, id, parentNodeId, locationHint, metaInfo, null, null, false), false);
        return node.getProxy();
    }

    @Nullable
    private Node findValidParentNode(@NotNull BaseStartedNodeEvent startedNodeEvent) {
        String parentId;
        if (startedNodeEvent == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(7);
        }
        if ((parentId = startedNodeEvent.getParentId()) == null) {
            this.logProblem("Parent node id should be defined: " + startedNodeEvent + ".", true);
            return null;
        }
        Node parentNode = (Node)this.myNodeByIdMap.get((Object)parentId);
        if (parentNode == null) {
            this.logProblem("Parent node is undefined for " + startedNodeEvent + ".", true);
            return null;
        }
        if (parentNode.getState() != State.NOT_RUNNING && parentNode.getState() != State.RUNNING) {
            this.logProblem("Parent node should be registered or running: " + parentNode + ", " + startedNodeEvent);
            return null;
        }
        return parentNode;
    }

    @Override
    public void onTestFinished(@NotNull TestFinishedEvent testFinishedEvent) {
        if (testFinishedEvent == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(8);
        }
        LOG.debug("onTestFinished");
        this.addToInvokeLater(() -> {
            if (testFinishedEvent == null) {
                GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(34);
            }
            LOG.debug("onTestFinished: invoked");
            Node node = this.findNodeToTerminate(testFinishedEvent);
            if (node != null) {
                SMTestProxy testProxy = node.getProxy();
                Long duration = testFinishedEvent.getDuration();
                if (duration != null) {
                    testProxy.setDuration(duration);
                }
                testProxy.setFrameworkOutputFile(testFinishedEvent.getOutputFile());
                testProxy.setFinished();
                this.fireOnTestFinishedIfNeeded(testProxy, node);
                this.terminateNode(node, State.FINISHED);
            }
        });
    }

    private void fireOnTestFinishedIfNeeded(@NotNull SMTestProxy testProxy, @NotNull Node node) {
        if (testProxy == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(9);
        }
        if (node == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(10);
        }
        if (node.getState() != State.FINISHED && node.getState() != State.FAILED && node.getState() != State.IGNORED) {
            LOG.debug("onTestFinished: state != FINISHED && state != FAILED && state != IGNORED");
            this.fireOnTestFinished(testProxy);
        }
    }

    @Override
    public void onSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        if (suiteFinishedEvent == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(11);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("onSuiteFinished " + suiteFinishedEvent.getId());
        }
        this.addToInvokeLater(() -> {
            Node node;
            if (suiteFinishedEvent == null) {
                GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(33);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("onSuiteFinished invoked " + suiteFinishedEvent.getId());
            }
            if ((node = this.findNodeToTerminate(suiteFinishedEvent)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("finished:" + node.myId);
                }
                SMTestProxy suiteProxy = node.getProxy();
                suiteProxy.setFinished();
                this.fireOnSuiteFinished(suiteProxy);
                this.terminateNode(node, State.FINISHED);
            }
        });
    }

    @Nullable
    private Node findNodeToTerminate(@NotNull TreeNodeEvent treeNodeEvent) {
        Node node;
        if (treeNodeEvent == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(12);
        }
        if ((node = this.findNode(treeNodeEvent)) == null) {
            this.logProblem("Trying to finish nonexistent node: " + treeNodeEvent);
            return null;
        }
        return node;
    }

    @Override
    public void onUncapturedOutput(@NotNull String text, Key outputType) {
        if (text == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(13);
        }
        LOG.debug("onUncapturedOutput " + text);
        this.addToInvokeLater(() -> {
            if (text == null) {
                GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(32);
            }
            Node activeNode = this.findActiveNode();
            SMTestProxy activeProxy = activeNode.getProxy();
            activeProxy.addOutput(text, outputType);
        });
    }

    @Override
    public void onError(@NotNull String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        if (localizedMessage == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(14);
        }
        this.onError(null, localizedMessage, stackTrace, isCritical);
    }

    public void onError(@Nullable String nodeId, @NotNull String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        if (localizedMessage == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(15);
        }
        LOG.debug("onError " + localizedMessage);
        this.addToInvokeLater(() -> {
            if (localizedMessage == null) {
                GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(31);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("onError invoked " + localizedMessage);
            }
            SMTestProxy activeProxy = null;
            if (nodeId != null) {
                activeProxy = this.findProxyById(nodeId);
            }
            if (activeProxy == null) {
                Node activeNode = this.findActiveNode();
                activeProxy = activeNode.getProxy();
            }
            activeProxy.addError(localizedMessage, stackTrace, isCritical);
        });
    }

    @Override
    public void onTestFailure(@NotNull TestFailedEvent testFailedEvent) {
        if (testFailedEvent == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(16);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("onTestFailure " + testFailedEvent.getId());
        }
        this.addToInvokeLater(() -> {
            Node node;
            if (testFailedEvent == null) {
                GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(30);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("onTestFailure invoked " + testFailedEvent.getId());
            }
            if ((node = this.findNodeToTerminate(testFailedEvent)) == null) {
                return;
            }
            SMTestProxy testProxy = node.getProxy();
            String comparisonFailureActualText = testFailedEvent.getComparisonFailureActualText();
            String comparisonFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
            String failureMessage = testFailedEvent.getLocalizedFailureMessage();
            String stackTrace = testFailedEvent.getStacktrace();
            if (comparisonFailureActualText != null && comparisonFailureExpectedText != null) {
                testProxy.setTestComparisonFailed(failureMessage, stackTrace, comparisonFailureActualText, comparisonFailureExpectedText, testFailedEvent);
            } else if (comparisonFailureActualText == null && comparisonFailureExpectedText == null) {
                testProxy.setTestFailed(failureMessage, stackTrace, testFailedEvent.isTestError());
            } else {
                this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisonFailureExpectedText + "\nActual:\n" + comparisonFailureActualText);
            }
            long duration = testFailedEvent.getDurationMillis();
            if (duration >= 0L) {
                testProxy.setDuration(duration);
            }
            this.fireOnTestFailed(testProxy);
            this.fireOnTestFinishedIfNeeded(testProxy, node);
            this.terminateNode(node, State.FAILED);
        });
    }

    @Override
    public void onTestIgnored(@NotNull TestIgnoredEvent testIgnoredEvent) {
        if (testIgnoredEvent == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(17);
        }
        LOG.debug("onTestIgnored");
        this.addToInvokeLater(() -> {
            if (testIgnoredEvent == null) {
                GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(29);
            }
            LOG.debug("onTestIgnored invoked");
            Node node = this.findNodeToTerminate(testIgnoredEvent);
            if (node != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("onTestIgnored node " + node.myId);
                }
                SMTestProxy testProxy = node.getProxy();
                testProxy.setTestIgnored(testIgnoredEvent.getIgnoreComment(), testIgnoredEvent.getStacktrace());
                this.fireOnTestIgnored(testProxy);
                this.fireOnTestFinishedIfNeeded(testProxy, node);
                this.terminateNode(node, State.IGNORED);
            }
        });
    }

    @Override
    public void onTestOutput(@NotNull TestOutputEvent testOutputEvent) {
        if (testOutputEvent == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(18);
        }
        LOG.debug("onTestOutput");
        this.addToInvokeLater(() -> {
            if (testOutputEvent == null) {
                GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(28);
            }
            LOG.debug("onTestOutput invoke");
            Node node = this.findNode(testOutputEvent);
            if (node == null) {
                this.logProblem("Test wasn't started! But " + testOutputEvent + "!");
                return;
            }
            node.getProxy().addOutput(testOutputEvent.getText(), testOutputEvent.getOutputType());
        });
    }

    @Override
    public void onTestsCountInSuite(int count) {
        LOG.debug("onTestsCountInSuite");
        this.addToInvokeLater(() -> this.fireOnTestsCountInSuite(count));
    }

    @Nullable
    private String validateAndGetNodeId(@NotNull TreeNodeEvent treeNodeEvent) {
        String nodeId;
        if (treeNodeEvent == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(19);
        }
        if ((nodeId = treeNodeEvent.getId()) == null || nodeId.equals("0")) {
            this.logProblem((nodeId == null ? "Missing" : "Illegal") + " nodeId: " + treeNodeEvent, true);
        }
        return nodeId;
    }

    @Nullable
    private Node findNode(@NotNull TreeNodeEvent treeNodeEvent) {
        String nodeId;
        if (treeNodeEvent == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(20);
        }
        return (nodeId = this.validateAndGetNodeId(treeNodeEvent)) != null ? (Node)this.myNodeByIdMap.get((Object)nodeId) : null;
    }

    @Nullable
    public SMTestProxy findProxyById(@NotNull String id) {
        Node node;
        if (id == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(21);
        }
        return (node = (Node)this.myNodeByIdMap.get((Object)id)) != null ? node.getProxy() : null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.addToInvokeLater(() -> {
            Application application;
            this.disconnectListeners();
            if (!(this.myRunningTestNodes.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
                this.logProblem("Not all events were processed!");
            }
            this.myRunningTestNodes.clear();
            this.myRunningSuiteNodes.clear();
            this.myNodeByIdMap.clear();
        });
    }

    private void setNodeAndAncestorsRunning(@NotNull Node lowestNode) {
        if (lowestNode == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(22);
        }
        for (Node node = lowestNode; node != null && node != this.myTestsRootNode && node.getState() == State.NOT_RUNNING; node = node.getParentNode()) {
            node.setState(State.RUNNING, this);
            SMTestProxy proxy = node.getProxy();
            proxy.setStarted();
            if (proxy.isSuite()) {
                this.myRunningSuiteNodes.add(node);
                this.fireOnSuiteStarted(proxy);
                continue;
            }
            this.myRunningTestNodes.add(lowestNode);
            this.fireOnTestStarted(proxy);
        }
    }

    private void terminateNode(@NotNull Node node, @NotNull State terminateState) {
        if (node == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(23);
        }
        if (terminateState == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(24);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("terminateNode " + node.myId);
        }
        node.setState(terminateState, this);
        this.myRunningTestNodes.remove(node);
        this.myRunningSuiteNodes.remove(node);
    }

    @NotNull
    private Node findActiveNode() {
        if (!this.myRunningTestNodes.isEmpty()) {
            Node node = this.myRunningTestNodes.iterator().next();
            if (node == null) {
                GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(25);
            }
            return node;
        }
        if (!this.myRunningSuiteNodes.isEmpty()) {
            Node node = this.myRunningSuiteNodes.iterator().next();
            if (node == null) {
                GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(26);
            }
            return node;
        }
        Node node = this.myTestsRootNode;
        if (node == null) {
            GeneralIdBasedToSMTRunnerEventsConvertor.$$$reportNull$$$0(27);
        }
        return node;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsRootProxy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printerProvider";
                break;
            }
            case 3: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testStartedEvent";
                break;
            }
            case 4: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteStartedEvent";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startedNodeEvent";
                break;
            }
            case 8: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFinishedEvent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteFinishedEvent";
                break;
            }
            case 12: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeNodeEvent";
                break;
            }
            case 13: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: 
            case 15: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localizedMessage";
                break;
            }
            case 16: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFailedEvent";
                break;
            }
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testIgnoredEvent";
                break;
            }
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testOutputEvent";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lowestNode";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminateState";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findActiveNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPrinterProvider";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onTestStarted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onSuiteStarted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doStartNode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findValidParentNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onTestFinished";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fireOnTestFinishedIfNeeded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onSuiteFinished";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findNodeToTerminate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onUncapturedOutput";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onError";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onTestFailure";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "onTestIgnored";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onTestOutput";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "validateAndGetNodeId";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findNode";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findProxyById";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setNodeAndAncestorsRunning";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "terminateNode";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onTestOutput$11";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onTestIgnored$10";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onTestFailure$9";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onError$8";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onUncapturedOutput$7";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onSuiteFinished$6";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onTestFinished$5";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onSuiteStarted$4";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onTestStarted$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Node {
        private final String myId;
        private final Node myParentNode;
        private final SMTestProxy myProxy;
        private State myState;

        Node(@NotNull String id, @Nullable Node parentNode, @NotNull SMTestProxy proxy) {
            if (id == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (proxy == null) {
                Node.$$$reportNull$$$0(1);
            }
            this.myId = id;
            this.myParentNode = parentNode;
            this.myProxy = proxy;
            this.myState = State.NOT_RUNNING;
        }

        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                Node.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public Node getParentNode() {
            return this.myParentNode;
        }

        @NotNull
        public SMTestProxy getProxy() {
            SMTestProxy sMTestProxy = this.myProxy;
            if (sMTestProxy == null) {
                Node.$$$reportNull$$$0(3);
            }
            return sMTestProxy;
        }

        @NotNull
        public State getState() {
            State state = this.myState;
            if (state == null) {
                Node.$$$reportNull$$$0(4);
            }
            return state;
        }

        public void setState(@NotNull State newState, @NotNull GeneralIdBasedToSMTRunnerEventsConvertor convertor) {
            if (newState == null) {
                Node.$$$reportNull$$$0(5);
            }
            if (convertor == null) {
                Node.$$$reportNull$$$0(6);
            }
            if (this.myState == State.NOT_RUNNING && newState != State.RUNNING && newState != State.IGNORED || this.myState == State.RUNNING && newState != State.FINISHED && newState != State.FAILED && newState != State.IGNORED || this.myState == State.FINISHED && newState != State.FAILED || this.myState == State.FAILED && newState != State.FINISHED || this.myState == State.IGNORED && newState != State.FINISHED) {
                convertor.logProblem("Illegal state change [" + (Object)((Object)this.myState) + " -> " + (Object)((Object)newState) + "]: " + this.toString(), false);
            }
            if (this.myState.ordinal() < newState.ordinal()) {
                this.myState = newState;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.myId == node.myId;
        }

        public int hashCode() {
            return this.myId.hashCode();
        }

        public String toString() {
            return "{id=" + this.myId + ", parentId=" + (this.myParentNode != null ? String.valueOf(this.myParentNode.getId()) : "<undefined>") + ", name='" + this.myProxy.getName() + "', isSuite=" + this.myProxy.isSuite() + ", state=" + (Object)((Object)this.myState) + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "proxy";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor$Node";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newState";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "convertor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor$Node";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProxy";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum State {
        NOT_RUNNING,
        RUNNING,
        FINISHED,
        FAILED,
        IGNORED;

    }
}

