/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLDistributionLegacy;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLUtil {
    private static final ProcessListener INPUT_CLOSE_LISTENER = new ProcessAdapter(){

        public void startNotified(@NotNull ProcessEvent event) {
            OutputStream input;
            if (event == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((input = event.getProcessHandler().getProcessInput()) != null) {
                try {
                    input.flush();
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/wsl/WSLUtil$1", "startNotified"));
        }
    };
    private static final List<WSLDistribution> DISTRIBUTIONS = Arrays.asList(new WSLDistribution("UBUNTU", "Ubuntu", "ubuntu.exe", "Ubuntu"), new WSLDistribution("UBUNTU1604", "Ubuntu-16.04", "ubuntu1604.exe", "Ubuntu 16.04"), new WSLDistribution("UBUNTU1804", "Ubuntu-18.04", "ubuntu1804.exe", "Ubuntu 18.04"), new WSLDistribution("DEBIAN", "Debian", "debian.exe", "Debian GNU/Linux"), new WSLDistribution("KALI", "kali-linux", "kali.exe", "Kali Linux"), new WSLDistribution("OPENSUSE42", "openSUSE-42", "opensuse-42.exe", "openSUSE Leap 42"), new WSLDistribution("SLES12", "SLES-12", "sles-12.exe", "SUSE Linux Enterprise Server 12"), WSLDistributionLegacy.LEGACY_WSL);

    public static boolean hasAvailableDistributions() {
        return WSLUtil.getAvailableDistributions().size() > 0;
    }

    @NotNull
    public static List<WSLDistribution> getAvailableDistributions() {
        List list2 = ContainerUtil.filter(DISTRIBUTIONS, dist -> dist.isAvailable());
        if (list2 == null) {
            WSLUtil.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Nullable
    public static WSLDistribution getDistributionById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        for (WSLDistribution distribution : WSLUtil.getAvailableDistributions()) {
            if (!id.equals(distribution.getId())) continue;
            return distribution;
        }
        return null;
    }

    @NotNull
    public static <T extends ProcessHandler> T addInputCloseListener(@NotNull T processHandler2) {
        if (processHandler2 == null) {
            WSLUtil.$$$reportNull$$$0(1);
        }
        processHandler2.removeProcessListener(INPUT_CLOSE_LISTENER);
        processHandler2.addProcessListener(INPUT_CLOSE_LISTENER);
        T t = processHandler2;
        if (t == null) {
            WSLUtil.$$$reportNull$$$0(2);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WSLUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WSLUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addInputCloseListener";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addInputCloseListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

