/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetFromExternalSourcesStorage;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.impl.FacetLoadingErrorDescription;
import com.intellij.facet.impl.FacetModelBase;
import com.intellij.facet.impl.FacetModelImpl;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.invalid.InvalidFacetConfiguration;
import com.intellij.facet.impl.invalid.InvalidFacetManager;
import com.intellij.facet.impl.invalid.InvalidFacetType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.facet.FacetManagerState;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@State(name="FacetManager")
public class FacetManagerImpl
extends FacetManager
implements ModuleComponent,
PersistentStateComponent<FacetManagerState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.FacetManagerImpl");
    @NonNls
    public static final String COMPONENT_NAME = "FacetManager";
    private final Module myModule;
    private final FacetManagerModel myModel = new FacetManagerModel();
    private boolean myInsideCommit;
    private final MessageBus myMessageBus;
    private boolean myModuleAdded;
    private final FacetFromExternalSourcesStorage myExternalSourcesStorage;

    public FacetManagerImpl(Module module, MessageBus messageBus, FacetFromExternalSourcesStorage externalSourcesStorage) {
        this.myModule = module;
        this.myMessageBus = messageBus;
        this.myExternalSourcesStorage = externalSourcesStorage;
    }

    @NotNull
    public ModifiableFacetModel createModifiableModel() {
        FacetModelImpl model = new FacetModelImpl(this);
        model.addFacetsFromManager();
        FacetModelImpl facetModelImpl = model;
        if (facetModelImpl == null) {
            FacetManagerImpl.$$$reportNull$$$0(0);
        }
        return facetModelImpl;
    }

    @NotNull
    public Facet[] getAllFacets() {
        Facet[] facetArray = this.myModel.getAllFacets();
        if (facetArray == null) {
            FacetManagerImpl.$$$reportNull$$$0(1);
        }
        return facetArray;
    }

    @Nullable
    public <F extends Facet> F getFacetByType(FacetTypeId<F> typeId) {
        return this.myModel.getFacetByType(typeId);
    }

    @Nullable
    public <F extends Facet> F findFacet(FacetTypeId<F> type, String name) {
        return this.myModel.findFacet(type, name);
    }

    @Nullable
    public <F extends Facet> F getFacetByType(@NotNull Facet underlyingFacet, FacetTypeId<F> typeId) {
        if (underlyingFacet == null) {
            FacetManagerImpl.$$$reportNull$$$0(2);
        }
        return this.myModel.getFacetByType(underlyingFacet, typeId);
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(@NotNull Facet underlyingFacet, FacetTypeId<F> typeId) {
        if (underlyingFacet == null) {
            FacetManagerImpl.$$$reportNull$$$0(3);
        }
        Collection<F> collection = this.myModel.getFacetsByType(underlyingFacet, typeId);
        if (collection == null) {
            FacetManagerImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(FacetTypeId<F> typeId) {
        Collection<F> collection = this.myModel.getFacetsByType(typeId);
        if (collection == null) {
            FacetManagerImpl.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public Facet[] getSortedFacets() {
        Facet[] facetArray = this.myModel.getSortedFacets();
        if (facetArray == null) {
            FacetManagerImpl.$$$reportNull$$$0(6);
        }
        return facetArray;
    }

    @NotNull
    public String getFacetName(@NotNull Facet facet) {
        if (facet == null) {
            FacetManagerImpl.$$$reportNull$$$0(7);
        }
        String string = this.myModel.getFacetName(facet);
        if (string == null) {
            FacetManagerImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public <F extends Facet, C extends FacetConfiguration> F createFacet(@NotNull FacetType<F, C> type, @NotNull String name, @NotNull C configuration, @Nullable Facet underlying) {
        Facet facet;
        if (type == null) {
            FacetManagerImpl.$$$reportNull$$$0(9);
        }
        if (name == null) {
            FacetManagerImpl.$$$reportNull$$$0(10);
        }
        if (configuration == null) {
            FacetManagerImpl.$$$reportNull$$$0(11);
        }
        FacetManagerImpl.assertTrue((facet = type.createFacet(this.myModule, name, configuration, underlying)).getModule() == this.myModule, facet, "module");
        FacetManagerImpl.assertTrue(facet.getConfiguration() == configuration, facet, "configuration");
        FacetManagerImpl.assertTrue(Comparing.equal((String)facet.getName(), (String)name), facet, "name");
        FacetManagerImpl.assertTrue(facet.getUnderlyingFacet() == underlying, facet, "underlyingFacet");
        Facet facet2 = facet;
        if (facet2 == null) {
            FacetManagerImpl.$$$reportNull$$$0(12);
        }
        return (F)facet2;
    }

    @NotNull
    public <F extends Facet, C extends FacetConfiguration> F createFacet(@NotNull FacetType<F, C> type, @NotNull String name, @Nullable Facet underlying) {
        if (type == null) {
            FacetManagerImpl.$$$reportNull$$$0(13);
        }
        if (name == null) {
            FacetManagerImpl.$$$reportNull$$$0(14);
        }
        FacetConfiguration configuration = ProjectFacetManager.getInstance((Project)this.myModule.getProject()).createDefaultConfiguration(type);
        F f = this.createFacet(type, name, configuration, underlying);
        if (f == null) {
            FacetManagerImpl.$$$reportNull$$$0(15);
        }
        return f;
    }

    @NotNull
    public <F extends Facet, C extends FacetConfiguration> F addFacet(@NotNull FacetType<F, C> type, @NotNull String name, @Nullable Facet underlying) {
        if (type == null) {
            FacetManagerImpl.$$$reportNull$$$0(16);
        }
        if (name == null) {
            FacetManagerImpl.$$$reportNull$$$0(17);
        }
        ModifiableFacetModel model = this.createModifiableModel();
        F facet = this.createFacet(type, name, underlying);
        model.addFacet(facet);
        model.commit();
        F f = facet;
        if (f == null) {
            FacetManagerImpl.$$$reportNull$$$0(18);
        }
        return f;
    }

    private static void assertTrue(boolean value, Facet facet, String parameter) {
        if (!value) {
            LOG.error("Facet type " + facet.getType().getClass().getName() + " violates the contract of FacetType.createFacet method about '" + parameter + "' parameter");
        }
    }

    private void addFacets(List<FacetState> facetStates, Facet underlyingFacet, ModifiableFacetModel model) {
        FacetTypeRegistry registry = FacetTypeRegistry.getInstance();
        for (FacetState child : facetStates) {
            FacetType actualUnderlyingType;
            String typeId = child.getFacetType();
            if (typeId == null) {
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.facet.type.isn.t.specified", (Object[])new Object[0]));
                continue;
            }
            FacetType type = registry.findFacetType(typeId);
            if (type == null) {
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.unknown.facet.type.0", (Object[])new Object[]{typeId}), typeId);
                continue;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            if (!type.isSuitableModuleType(moduleType)) {
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.0.facets.are.not.allowed.in.1", (Object[])new Object[]{type.getPresentableName(), moduleType.getName()}));
                continue;
            }
            FacetType expectedUnderlyingType = null;
            FacetTypeId underlyingTypeId = type.getUnderlyingFacetType();
            if (underlyingTypeId != null) {
                expectedUnderlyingType = registry.findFacetType(underlyingTypeId);
            }
            FacetType facetType = actualUnderlyingType = underlyingFacet != null ? underlyingFacet.getType() : null;
            if (expectedUnderlyingType != null) {
                if (!expectedUnderlyingType.equals(actualUnderlyingType)) {
                    this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.0.facet.must.be.placed.under.1.facet", (Object[])new Object[]{type.getPresentableName(), expectedUnderlyingType.getPresentableName()}));
                    continue;
                }
            } else if (actualUnderlyingType != null) {
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.0.cannot.be.placed.under.1", (Object[])new Object[]{type.getPresentableName(), actualUnderlyingType.getPresentableName()}));
                continue;
            }
            try {
                this.addFacet(type, child, underlyingFacet, model);
            }
            catch (InvalidDataException e) {
                LOG.info((Throwable)e);
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.cannot.load.facet.configuration.0", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    private void addInvalidFacet(FacetState state, ModifiableFacetModel model, Facet underlyingFacet, String errorMessage) {
        this.addInvalidFacet(state, model, underlyingFacet, errorMessage, null);
    }

    private void addInvalidFacet(FacetState state, ModifiableFacetModel model, Facet underlyingFacet, String errorMessage, String typeId) {
        InvalidFacetManager invalidFacetManager = InvalidFacetManager.getInstance(this.myModule.getProject());
        InvalidFacetType type = InvalidFacetType.getInstance();
        InvalidFacetConfiguration configuration = new InvalidFacetConfiguration(state, errorMessage);
        InvalidFacet facet = this.createFacet(type, StringUtil.notNullize((String)state.getName()), configuration, underlyingFacet);
        model.addFacet((Facet)facet);
        if (!invalidFacetManager.isIgnored(facet)) {
            FacetLoadingErrorDescription description = new FacetLoadingErrorDescription(facet);
            ProjectLoadingErrorsNotifier.getInstance(this.myModule.getProject()).registerError(description);
            if (typeId != null) {
                UnknownFeaturesCollector.getInstance(this.myModule.getProject()).registerUnknownFeature("com.intellij.facetType", typeId, "Facet");
            }
        }
    }

    private <F extends Facet<C>, C extends FacetConfiguration> void addFacet(FacetType<F, C> type, FacetState state, Facet underlyingFacet, ModifiableFacetModel model) throws InvalidDataException {
        Element newConfiguration;
        Collection facetsOfThisType;
        Collection collection = facetsOfThisType = underlyingFacet == null ? model.getFacetsByType(type.getId()) : model.getFacetsByType(underlyingFacet, type.getId());
        if (type.isOnlyOneFacetAllowed() && !facetsOfThisType.isEmpty() && facetsOfThisType.stream().anyMatch(f -> !f.getName().equals(state.getName()))) {
            LOG.info("'" + state.getName() + "' facet removed from module " + this.myModule.getName() + ", because only one " + type.getPresentableName() + " facet allowed");
            return;
        }
        Object facet = null;
        if (!facetsOfThisType.isEmpty() && ProjectUtilCore.isExternalStorageEnabled((Project)this.myModule.getProject()) && (facet = (Facet)facetsOfThisType.stream().filter(f -> f.getName().equals(state.getName())).findFirst().orElse(null)) != null && (newConfiguration = state.getConfiguration()) != null) {
            FacetUtil.loadFacetConfiguration(facet.getConfiguration(), newConfiguration);
        }
        if (facet == null) {
            String externalSystemId;
            FacetConfiguration configuration = type.createDefaultConfiguration();
            Element config = state.getConfiguration();
            FacetUtil.loadFacetConfiguration(configuration, config);
            String name = state.getName();
            facet = this.createFacet(type, name, configuration, underlyingFacet);
            if (facet instanceof JDOMExternalizable) {
                ((JDOMExternalizable)facet).readExternal(config);
            }
            if ((externalSystemId = state.getExternalSystemId()) != null) {
                facet.setExternalSource(ExternalProjectSystemRegistry.getInstance().getSourceById(externalSystemId));
            }
            model.addFacet(facet);
        }
        this.addFacets(state.getSubFacets(), (Facet)facet, model);
    }

    public void noStateLoaded() {
        this.doLoadState(null);
    }

    public void loadState(@NotNull FacetManagerState state) {
        if (state == null) {
            FacetManagerImpl.$$$reportNull$$$0(19);
        }
        this.doLoadState(state);
    }

    protected void doLoadState(@Nullable FacetManagerState state) {
        FacetModelImpl model = new FacetModelImpl(this);
        FacetManagerState importedFacetsState = this.myExternalSourcesStorage.getLoadedState();
        this.addFacets(ContainerUtil.concat((List)(state == null ? Collections.emptyList() : state.getFacets()), (List)importedFacetsState.getFacets()), null, model);
        this.commit(model, false);
    }

    @NotNull
    public FacetManagerState getState() {
        FacetManagerState facetManagerState = this.saveState(FacetManagerImpl.getImportedFacetPredicate(this.myModule.getProject()).negate());
        if (facetManagerState == null) {
            FacetManagerImpl.$$$reportNull$$$0(20);
        }
        return facetManagerState;
    }

    @NotNull
    static Predicate<Facet> getImportedFacetPredicate(@NotNull Project project) {
        if (project == null) {
            FacetManagerImpl.$$$reportNull$$$0(21);
        }
        if (ProjectUtilCore.isExternalStorageEnabled((Project)project)) {
            Predicate<Facet> predicate = facet -> facet.getExternalSource() != null;
            if (predicate == null) {
                FacetManagerImpl.$$$reportNull$$$0(22);
            }
            return predicate;
        }
        Predicate<Facet> predicate = facet -> false;
        if (predicate == null) {
            FacetManagerImpl.$$$reportNull$$$0(23);
        }
        return predicate;
    }

    @NotNull
    FacetManagerState saveState(Predicate<Facet> filter2) {
        FacetManagerState managerState = new FacetManagerState();
        Facet[] facets = this.getSortedFacets();
        HashMap<Facet, List<FacetState>> states = new HashMap<Facet, List<FacetState>>();
        states.put(null, managerState.getFacets());
        for (Facet facet : facets) {
            if (!filter2.test(facet)) continue;
            Facet underlyingFacet = facet.getUnderlyingFacet();
            FacetState facetState = FacetManagerImpl.createFacetState(facet, this.myModule.getProject());
            if (!(facet instanceof InvalidFacet)) {
                Element config;
                block5: {
                    try {
                        FacetConfiguration configuration = facet.getConfiguration();
                        config = FacetUtil.saveFacetConfiguration(configuration);
                        if (!(facet instanceof JDOMExternalizable)) break block5;
                        ((JDOMExternalizable)facet).writeExternal(config);
                    }
                    catch (WriteExternalException e) {
                        continue;
                    }
                }
                facetState.setConfiguration(config);
            }
            FacetManagerImpl.getOrCreateTargetFacetList(underlyingFacet, states, this.myModule.getProject()).add(facetState);
            states.put(facet, facetState.getSubFacets());
        }
        FacetManagerState facetManagerState = managerState;
        if (facetManagerState == null) {
            FacetManagerImpl.$$$reportNull$$$0(24);
        }
        return facetManagerState;
    }

    private static List<FacetState> getOrCreateTargetFacetList(Facet underlyingFacet, Map<Facet, List<FacetState>> states, @NotNull Project project) {
        List facetStateList;
        if (project == null) {
            FacetManagerImpl.$$$reportNull$$$0(25);
        }
        if ((facetStateList = states.get(underlyingFacet)) == null) {
            FacetState state = FacetManagerImpl.createFacetState(underlyingFacet, project);
            FacetManagerImpl.getOrCreateTargetFacetList(underlyingFacet.getUnderlyingFacet(), states, project).add(state);
            facetStateList = state.getSubFacets();
            states.put(underlyingFacet, facetStateList);
        }
        return facetStateList;
    }

    private static FacetState createFacetState(@NotNull Facet facet, @NotNull Project project) {
        if (facet == null) {
            FacetManagerImpl.$$$reportNull$$$0(26);
        }
        if (project == null) {
            FacetManagerImpl.$$$reportNull$$$0(27);
        }
        if (facet instanceof InvalidFacet) {
            return ((InvalidFacetConfiguration)((InvalidFacet)facet).getConfiguration()).getFacetState();
        }
        FacetState facetState = new FacetState();
        ProjectModelExternalSource externalSource = facet.getExternalSource();
        if (externalSource != null && ProjectUtilCore.isExternalStorageEnabled((Project)project)) {
            facetState.setExternalSystemId(externalSource.getId());
        }
        facetState.setFacetType(facet.getType().getStringId());
        facetState.setName(facet.getName());
        return facetState;
    }

    public void commit(ModifiableFacetModel model) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.commit(model, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(ModifiableFacetModel model, boolean fireEvents) {
        LOG.assertTrue(!this.myInsideCommit, (Object)"Recursive commit");
        HashSet<Facet> toRemove2 = new HashSet<Facet>(Arrays.asList(this.getAllFacets()));
        ArrayList<Facet> toAdd = new ArrayList<Facet>();
        ArrayList<FacetRenameInfo> toRename = new ArrayList<FacetRenameInfo>();
        FacetManagerListener publisher = (FacetManagerListener)this.myMessageBus.syncPublisher(FACETS_TOPIC);
        try {
            this.myInsideCommit = true;
            for (Facet facet : model.getAllFacets()) {
                boolean isNew;
                boolean bl = isNew = !toRemove2.remove(facet);
                if (!isNew) continue;
                toAdd.add(facet);
            }
            ArrayList<Facet> newFacets = new ArrayList<Facet>();
            for (Facet facet : this.getAllFacets()) {
                if (toRemove2.contains(facet)) continue;
                newFacets.add(facet);
            }
            newFacets.addAll(toAdd);
            for (Facet facet : newFacets) {
                String newName = model.getNewName(facet);
                if (newName == null || newName.equals(facet.getName())) continue;
                toRename.add(new FacetRenameInfo(facet, facet.getName(), newName));
            }
            if (fireEvents) {
                for (Facet facet : toAdd) {
                    publisher.beforeFacetAdded(facet);
                }
                for (Facet facet : toRemove2) {
                    publisher.beforeFacetRemoved(facet);
                }
                for (FacetRenameInfo info : toRename) {
                    publisher.beforeFacetRenamed(info.myFacet);
                }
            }
            for (FacetRenameInfo info : toRename) {
                info.myFacet.setName(info.myNewName);
            }
            this.myModel.setAllFacets(newFacets.toArray(Facet.EMPTY_ARRAY));
        }
        finally {
            this.myInsideCommit = false;
        }
        if (this.myModuleAdded) {
            for (Facet facet : toAdd) {
                facet.initFacet();
            }
        }
        for (Facet facet : toRemove2) {
            Disposer.dispose((Disposable)facet);
        }
        if (fireEvents) {
            for (Facet facet : toAdd) {
                publisher.facetAdded(facet);
            }
            for (Facet facet : toRemove2) {
                publisher.facetRemoved(facet);
            }
            for (FacetRenameInfo info : toRename) {
                publisher.facetRenamed(info.myFacet, info.myOldName);
            }
        }
        for (Facet facet : toAdd) {
            FacetType type;
            Module module = facet.getModule();
            if (!module.equals(this.myModule)) {
                LOG.error(facet + " is created for module " + module + " but added to module " + this.myModule);
            }
            if (!(type = facet.getType()).isOnlyOneFacetAllowed()) continue;
            if (type.getUnderlyingFacetType() == null) {
                Collection facets = this.getFacetsByType(type.getId());
                if (facets.size() <= 1) continue;
                LOG.error("Only one '" + type.getPresentableName() + "' facet per module allowed, but " + facets.size() + " facets found in module '" + this.myModule.getName() + "'");
                continue;
            }
            Facet underlyingFacet = facet.getUnderlyingFacet();
            LOG.assertTrue(underlyingFacet != null, (Object)("Underlying facet is not specified for '" + facet.getName() + "'"));
            Collection facets = this.getFacetsByType(underlyingFacet, type.getId());
            if (facets.size() <= 1) continue;
            LOG.error("Only one '" + type.getPresentableName() + "' facet per parent facet allowed, but " + facets.size() + " sub-facets found in facet " + underlyingFacet.getName());
        }
    }

    public void setExternalSource(Facet facet, ProjectModelExternalSource externalSource) {
        facet.setExternalSource(externalSource);
    }

    Set<ProjectModelExternalSource> getExternalSources() {
        return this.myModel.myExternalSources;
    }

    public void moduleAdded() {
        if (this.myModuleAdded) {
            return;
        }
        for (Facet facet : this.getAllFacets()) {
            facet.initFacet();
        }
        this.myModuleAdded = true;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            FacetManagerImpl.$$$reportNull$$$0(28);
        }
        return COMPONENT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/FacetManagerImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingFacet";
                break;
            }
            case 7: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createModifiableModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFacets";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/FacetManagerImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetsByType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedFacets";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetName";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacet";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "addFacet";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedFacetPredicate";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "saveState";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFacetByType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFacetsByType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFacetName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFacet";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addFacet";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getImportedFacetPredicate";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateTargetFacetList";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createFacetState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FacetRenameInfo {
        private final Facet myFacet;
        private final String myOldName;
        private final String myNewName;

        FacetRenameInfo(Facet facet, String oldName, String newName) {
            this.myFacet = facet;
            this.myOldName = oldName;
            this.myNewName = newName;
        }
    }

    private static class FacetManagerModel
    extends FacetModelBase {
        private Facet[] myAllFacets = Facet.EMPTY_ARRAY;
        private final Set<ProjectModelExternalSource> myExternalSources = new LinkedHashSet<ProjectModelExternalSource>();

        private FacetManagerModel() {
        }

        @NotNull
        public Facet[] getAllFacets() {
            if (this.myAllFacets == null) {
                FacetManagerModel.$$$reportNull$$$0(0);
            }
            return this.myAllFacets;
        }

        void setAllFacets(Facet[] allFacets) {
            this.myExternalSources.clear();
            for (Facet facet : allFacets) {
                ContainerUtil.addIfNotNull(this.myExternalSources, (Object)facet.getExternalSource());
            }
            this.myAllFacets = allFacets;
            this.facetsChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl$FacetManagerModel", "getAllFacets"));
        }
    }
}

