/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.android.utils.DateProvider;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.intellij.ide.ExceptionRegistry;
import com.intellij.ide.StackTrace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002#$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160 2\b\b\u0002\u0010!\u001a\u00020\u0004J\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR$\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/ide/ExceptionRegistry;", "", "()V", "count", "", "getCount", "()I", "setCount", "(I)V", "dateProvider", "Lcom/android/utils/DateProvider;", "dateProvider$annotations", "getDateProvider", "()Lcom/android/utils/DateProvider;", "setDateProvider", "(Lcom/android/utils/DateProvider;)V", "leafNodes", "", "Lcom/intellij/ide/ExceptionRegistry$LeafNode;", "root", "Lcom/intellij/ide/ExceptionRegistry$StackFrame;", "addFrames", "Lcom/intellij/ide/StackTrace;", "throwable", "", "clear", "", "find", "md5", "", "getMostFrequent", "getStackTraces", "", "threshold", "register", "LeafNode", "StackFrame", "intellij.platform.ide.impl"})
public final class ExceptionRegistry {
    private static int count;
    private static final StackFrame root;
    private static final List<LeafNode> leafNodes;
    @NotNull
    private static DateProvider dateProvider;
    public static final ExceptionRegistry INSTANCE;

    public final int getCount() {
        return count;
    }

    public final void setCount(int n) {
        count = n;
    }

    public static /* synthetic */ void dateProvider$annotations() {
    }

    @NotNull
    public final DateProvider getDateProvider() {
        return dateProvider;
    }

    public final void setDateProvider(@NotNull DateProvider dateProvider) {
        Intrinsics.checkParameterIsNotNull((Object)dateProvider, (String)"<set-?>");
        ExceptionRegistry.dateProvider = dateProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final StackTrace register(@NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            int n = count;
            count = n + 1;
            StackTrace stackTrace = INSTANCE.addFrames(throwable);
            return stackTrace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int count() {
        int n;
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            n = count;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final StackTrace getMostFrequent() {
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            Object v0;
            block8: {
                if (!leafNodes.isEmpty()) break block8;
                StackTrace stackTrace = null;
                return stackTrace;
            }
            Iterable $receiver$iv = leafNodes;
            Iterator iterator$iv = $receiver$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                LeafNode it = (LeafNode)maxElem$iv;
                int maxValue$iv = it.getCount();
                while (iterator$iv.hasNext()) {
                    Object e$iv = iterator$iv.next();
                    LeafNode it2 = (LeafNode)e$iv;
                    int v$iv = it2.getCount();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                }
                v0 = maxElem$iv;
            }
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.StackTrace");
            }
            StackTrace stackTrace = v0;
            return stackTrace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            count = 0;
            root.setFirstChild(null);
            root.setNextSibling(null);
            leafNodes.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<StackTrace> getStackTraces(int threshold) {
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)leafNodes;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                LeafNode it = (LeafNode)element$iv$iv;
                if (!(it.getCount() >= threshold)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            CollectionsKt.sort((List)list2);
            List list3 = list2;
            return list3;
        }
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List getStackTraces$default(ExceptionRegistry exceptionRegistry, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return exceptionRegistry.getStackTraces(n);
    }

    /*
     * WARNING - void declaration
     */
    private final StackTrace addFrames(Throwable throwable) {
        StackFrame curr = root;
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull((Object)stackTrace, (String)"stackTrace");
        Object[] objectArray = stackTrace;
        if (objectArray.length == 0) {
            curr = curr.addChild(new StackTraceElement(throwable.getClass().getName(), "", "", 0));
        } else {
            int max;
            int n = max = ((Object[])stackTrace).length - 1;
            boolean bl = false;
            while (n >= 0) {
                void index;
                StackTraceElement element;
                StackTraceElement stackTraceElement = element = stackTrace[index];
                Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"element");
                curr = curr.addChild(stackTraceElement);
                --index;
            }
        }
        Class<Object> clazz = throwable.getClass();
        Date date = dateProvider.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"dateProvider.now()");
        LeafNode leaf = curr.addLeaf(clazz, date.getTime());
        if (leaf.getCount() == 1) {
            leafNodes.add(leaf);
        }
        return leaf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final StackTrace find(@NotNull String md5) {
        Intrinsics.checkParameterIsNotNull((Object)md5, (String)"md5");
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            Object v0;
            block4: {
                Iterable $receiver$iv = leafNodes;
                for (Object element$iv : $receiver$iv) {
                    LeafNode it = (LeafNode)element$iv;
                    if (!Intrinsics.areEqual((Object)md5, (Object)it.md5string())) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            StackTrace stackTrace = v0;
            return stackTrace;
        }
    }

    private ExceptionRegistry() {
    }

    static {
        ExceptionRegistry exceptionRegistry;
        INSTANCE = exceptionRegistry = new ExceptionRegistry();
        root = new StackFrame(new StackTraceElement("ROOT", "", "", 0), null);
        leafNodes = new ArrayList();
        DateProvider dateProvider = DateProvider.SYSTEM;
        if (dateProvider == null) {
            Intrinsics.throwNpe();
        }
        ExceptionRegistry.dateProvider = dateProvider;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u001c\u0010\u0018\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0000J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0002R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\b\"\u0004\b\u0015\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\b\u00a8\u0006#"}, d2={"Lcom/intellij/ide/ExceptionRegistry$StackFrame;", "", "frame", "Ljava/lang/StackTraceElement;", "parent", "(Ljava/lang/StackTraceElement;Lcom/intellij/ide/ExceptionRegistry$StackFrame;)V", "firstChild", "getFirstChild", "()Lcom/intellij/ide/ExceptionRegistry$StackFrame;", "setFirstChild", "(Lcom/intellij/ide/ExceptionRegistry$StackFrame;)V", "getFrame", "()Ljava/lang/StackTraceElement;", "leafNode", "Lcom/intellij/ide/ExceptionRegistry$LeafNode;", "getLeafNode", "()Lcom/intellij/ide/ExceptionRegistry$LeafNode;", "setLeafNode", "(Lcom/intellij/ide/ExceptionRegistry$LeafNode;)V", "nextSibling", "getNextSibling", "setNextSibling", "getParent", "addChild", "addLeaf", "cls", "Ljava/lang/Class;", "currentTimestampMs", "", "compareTo", "", "otherFrame", "matches", "", "element", "intellij.platform.ide.impl"})
    private static class StackFrame {
        @Nullable
        private StackFrame firstChild;
        @Nullable
        private StackFrame nextSibling;
        @Nullable
        private LeafNode leafNode;
        @NotNull
        private final StackTraceElement frame;
        @Nullable
        private final StackFrame parent;

        @Nullable
        public final StackFrame getFirstChild() {
            return this.firstChild;
        }

        public final void setFirstChild(@Nullable StackFrame stackFrame) {
            this.firstChild = stackFrame;
        }

        @Nullable
        public final StackFrame getNextSibling() {
            return this.nextSibling;
        }

        public final void setNextSibling(@Nullable StackFrame stackFrame) {
            this.nextSibling = stackFrame;
        }

        @Nullable
        public final LeafNode getLeafNode() {
            return this.leafNode;
        }

        public final void setLeafNode(@Nullable LeafNode leafNode) {
            this.leafNode = leafNode;
        }

        @NotNull
        public final StackFrame addChild(@NotNull StackTraceElement frame) {
            Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
            if (this.firstChild == null) {
                StackFrame child;
                this.firstChild = child = new StackFrame(frame, this);
                return child;
            }
            StackFrame prev2 = null;
            StackFrame curr = this.firstChild;
            while (curr != null) {
                if (curr.matches(frame)) {
                    return curr;
                }
                prev2 = curr;
                curr = curr.nextSibling;
            }
            StackFrame child = new StackFrame(frame, this);
            if (prev2 == null) {
                Intrinsics.throwNpe();
            }
            prev2.nextSibling = child;
            return child;
        }

        @NotNull
        public final LeafNode addLeaf(@NotNull Class<Object> cls, long currentTimestampMs) {
            Intrinsics.checkParameterIsNotNull(cls, (String)"cls");
            LeafNode localLeafFrame = this.leafNode;
            if (localLeafFrame == null) {
                this.leafNode = localLeafFrame = new LeafNode(cls, this, currentTimestampMs);
            } else {
                localLeafFrame.incrementCount();
            }
            return localLeafFrame;
        }

        private final boolean matches(StackTraceElement element) {
            return Intrinsics.areEqual((Object)element, (Object)this.frame);
        }

        public final int compareTo(@NotNull StackFrame otherFrame) {
            String string;
            String fileName;
            Intrinsics.checkParameterIsNotNull((Object)otherFrame, (String)"otherFrame");
            String string2 = this.frame.getClassName();
            String string3 = otherFrame.frame.getClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"otherFrame.frame.className");
            int delta = string2.compareTo(string3);
            if (delta != 0) {
                return delta;
            }
            String string4 = this.frame.getMethodName();
            String string5 = otherFrame.frame.getMethodName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"otherFrame.frame.methodName");
            delta = string4.compareTo(string5);
            if (delta != 0) {
                return delta;
            }
            String string6 = this.frame.getFileName();
            if (string6 == null) {
                string6 = fileName = "";
            }
            if ((string = otherFrame.frame.getFileName()) == null) {
                string = "";
            }
            String otherFileName = string;
            delta = fileName.compareTo(otherFileName);
            if (delta != 0) {
                return delta;
            }
            return this.frame.getLineNumber() - otherFrame.frame.getLineNumber();
        }

        @NotNull
        public final StackTraceElement getFrame() {
            return this.frame;
        }

        @Nullable
        public final StackFrame getParent() {
            return this.parent;
        }

        public StackFrame(@NotNull StackTraceElement frame, @Nullable StackFrame parent) {
            Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
            this.frame = frame;
            this.parent = parent;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0001H\u0096\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0014H\u0016J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\rH\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010'\u001a\u00020\u0014H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lcom/intellij/ide/ExceptionRegistry$LeafNode;", "Lcom/intellij/ide/StackTrace;", "cls", "Ljava/lang/Class;", "", "parent", "Lcom/intellij/ide/ExceptionRegistry$StackFrame;", "timeOfFirstHitMs", "", "(Ljava/lang/Class;Lcom/intellij/ide/ExceptionRegistry$StackFrame;J)V", "getCls", "()Ljava/lang/Class;", "<set-?>", "", "count", "getCount", "()I", "setCount", "(I)V", "md5String", "", "getParent", "()Lcom/intellij/ide/ExceptionRegistry$StackFrame;", "getTimeOfFirstHitMs", "()J", "compareTo", "other", "frameSequence", "Lkotlin/sequences/Sequence;", "incrementCount", "", "md5", "Lcom/google/common/hash/HashCode;", "md5string", "printStackTrace", "writer", "Ljava/io/PrintWriter;", "summarize", "maxWidth", "toStackTrace", "intellij.platform.ide.impl"})
    private static final class LeafNode
    implements StackTrace {
        private int count;
        private String md5String;
        @NotNull
        private final Class<Object> cls;
        @NotNull
        private final StackFrame parent;
        private final long timeOfFirstHitMs;

        @Override
        public int getCount() {
            return this.count;
        }

        private void setCount(int n) {
            this.count = n;
        }

        @Override
        public long timeOfFirstHitMs() {
            return this.timeOfFirstHitMs;
        }

        @Override
        @NotNull
        public String summarize(int maxWidth) {
            StringBuilder sb = new StringBuilder(maxWidth);
            String prevClass = "";
            String prevMethod = "";
            char arrow = '\u2190';
            sb.append(this.cls.getSimpleName()).append(": ");
            for (StackFrame curr : this.frameSequence()) {
                StackTraceElement stackTraceElement = curr.getFrame();
                StackTraceElement $receiver = stackTraceElement;
                if (Intrinsics.areEqual((Object)$receiver.getClassName(), (Object)prevClass) ^ true) {
                    String string = $receiver.getClassName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className");
                    sb.append(StringsKt.substringAfterLast((String)string, (char)'.', (String)""));
                }
                if (Intrinsics.areEqual((Object)$receiver.getMethodName(), (Object)prevMethod) ^ true) {
                    if (StringsKt.last((CharSequence)sb) != arrow) {
                        sb.append('.');
                    }
                    sb.append($receiver.getMethodName());
                }
                if ($receiver.getLineNumber() >= 1) {
                    if (StringsKt.last((CharSequence)sb) != arrow) {
                        sb.append(':');
                    }
                    sb.append(Integer.toString($receiver.getLineNumber()));
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)$receiver.getClassName(), (String)"className");
                Intrinsics.checkExpressionValueIsNotNull((Object)$receiver.getMethodName(), (String)"methodName");
                sb.append(arrow);
                if (sb.length() <= maxWidth) continue;
                break;
            }
            if (StringsKt.endsWith$default((CharSequence)sb, (char)arrow, (boolean)false, (int)2, null)) {
                StringsKt.trim((CharSequence)sb, (char[])new char[]{arrow});
            }
            if (sb.length() > maxWidth) {
                sb.setLength(maxWidth - 1);
                sb.append('\u2026');
            }
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        @Override
        @NotNull
        public HashCode md5() {
            HashFunction hf = Hashing.md5();
            Hasher hc = hf.newHasher();
            hc.putString((CharSequence)this.cls.getName(), Charsets.UTF_8);
            for (StackFrame curr : this.frameSequence()) {
                StackTraceElement stackTraceElement;
                StackTraceElement $receiver = stackTraceElement = curr.getFrame();
                hc.putString((CharSequence)$receiver.getClassName(), Charsets.UTF_8);
                hc.putString((CharSequence)$receiver.getMethodName(), Charsets.UTF_8);
                String string = $receiver.getFileName();
                hc.putString(string != null ? (CharSequence)string : (CharSequence)"", Charsets.UTF_8);
                hc.putInt($receiver.getLineNumber());
            }
            HashCode hashCode = hc.hash();
            Intrinsics.checkExpressionValueIsNotNull((Object)hashCode, (String)"hc.hash()");
            return hashCode;
        }

        @Override
        @NotNull
        public String md5string() {
            if (this.md5String == null) {
                HashCode hash = this.md5();
                byte[] bytes = hash.asBytes();
                this.md5String = BaseEncoding.base16().upperCase().encode(bytes);
            }
            String string = this.md5String;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }

        @Override
        @NotNull
        public String toStackTrace() {
            StringWriter writer = new StringWriter();
            this.printStackTrace(new PrintWriter(writer));
            String string = writer.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"writer.toString()");
            return string;
        }

        @Override
        public void printStackTrace(@NotNull PrintWriter writer) {
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            writer.print(this.cls.getName());
            writer.print(":\n");
            for (StackFrame curr : this.frameSequence()) {
                StackTraceElement stackTraceElement;
                writer.print("\tat ");
                StackTraceElement $receiver = stackTraceElement = curr.getFrame();
                writer.print($receiver.getClassName());
                writer.print('.');
                writer.print($receiver.getMethodName());
                if ($receiver.getLineNumber() == -2) {
                    writer.print("(Native Method)");
                } else if ($receiver.getFileName() != null) {
                    writer.print('(');
                    writer.print($receiver.getFileName());
                    writer.print(':');
                    writer.print($receiver.getMethodName());
                    writer.print(')');
                }
                writer.print("\n");
            }
        }

        @Override
        public int compareTo(@NotNull StackTrace other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            LeafNode otherLeaf = (LeafNode)other;
            int delta = Intrinsics.compare((int)otherLeaf.getCount(), (int)this.getCount());
            if (delta != 0) {
                return delta;
            }
            return this.parent.compareTo(otherLeaf.parent);
        }

        private final Sequence<StackFrame> frameSequence() {
            return SequencesKt.generateSequence((Object)this.parent, (Function1)frameSequence.1.INSTANCE);
        }

        public final void incrementCount() {
            LeafNode leafNode = this;
            int n = leafNode.getCount();
            leafNode.setCount(n + 1);
        }

        @NotNull
        public final Class<Object> getCls() {
            return this.cls;
        }

        @NotNull
        public final StackFrame getParent() {
            return this.parent;
        }

        public final long getTimeOfFirstHitMs() {
            return this.timeOfFirstHitMs;
        }

        public LeafNode(@NotNull Class<Object> cls, @NotNull StackFrame parent, long timeOfFirstHitMs) {
            Intrinsics.checkParameterIsNotNull(cls, (String)"cls");
            Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
            this.cls = cls;
            this.parent = parent;
            this.timeOfFirstHitMs = timeOfFirstHitMs;
            this.count = 1;
        }
    }
}

