/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.android.tools.analytics.UsageTracker;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.StudioCrash;
import com.google.wireless.android.sdk.stats.StudioExceptionDetails;
import com.google.wireless.android.sdk.stats.StudioPerformanceStats;
import com.google.wireless.android.sdk.stats.UIActionStats;
import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.diagnostic.VMOptions;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ExceptionRegistry;
import com.intellij.ide.HistogramUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.StackTrace;
import com.intellij.ide.ThreadDumpsDatabase;
import com.intellij.ide.actions.CopyAction;
import com.intellij.ide.actions.CutAction;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.ide.actions.EditCustomVmOptionsAction;
import com.intellij.ide.actions.NextOccurenceAction;
import com.intellij.ide.actions.PasteAction;
import com.intellij.ide.actions.PreviousOccurenceAction;
import com.intellij.ide.actions.SaveAllAction;
import com.intellij.ide.actions.UndoRedoAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.analytics.StudioCrashDetails;
import com.intellij.internal.statistic.analytics.StudioCrashDetection;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.jna.JnaLoader;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationFullContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JdkBundle;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.lang.JavaVersion;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.HdrHistogram.Histogram;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class SystemHealthMonitor
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance(SystemHealthMonitor.class);
    private static final NotificationGroup GROUP = new NotificationGroup("System Health", NotificationDisplayType.STICKY_BALLOON, true);
    private static final String SWITCH_JDK_ACTION = "SwitchBootJdk";
    private static final JavaVersion MIN_RECOMMENDED_JDK = JavaVersion.compose((int)8, (int)0, (int)144, (int)0, (boolean)false);
    public static final AtomicLong ourStudioActionCount = new AtomicLong(0L);
    private static final String STUDIO_ACTIVITY_COUNT = "studio.activity.count";
    private static final AtomicLong ourStudioExceptionCount = new AtomicLong(0L);
    private static final AtomicLong ourInitialPersistedExceptionCount = new AtomicLong(0L);
    private static final AtomicLong ourBundledPluginsExceptionCount = new AtomicLong(0L);
    private static final AtomicLong ourNonBundledPluginsExceptionCount = new AtomicLong(0L);
    private static final Object EXCEPTION_COUNT_LOCK = new Object();
    @NonNls
    private static final String STUDIO_EXCEPTION_COUNT_FILE = "studio.exc";
    @NonNls
    private static final String BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE = "studio.exb";
    @NonNls
    private static final String NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE = "studio.exp";
    private static final Histogram myEventDurationsMs = new Histogram(1);
    private static final long MAX_EVENT_DURATION_MS = 1800000L;
    private static final Histogram myWriteLockWaitTimesMs = new Histogram(1);
    private static final long MAX_WRITE_LOCK_WAIT_TIME_MS = 1800000L;
    private final ThreadDumpsDatabase myThreadDumpsDatabase;
    private static final Object ACTION_INVOCATIONS_LOCK = new Object();
    private static final Lock REPORT_EXCEPTIONS_LOCK = new ReentrantLock();
    private static Map<String, Multiset<UIActionStats.InvocationKind>> ourActionInvocations = new HashMap<String, Multiset<UIActionStats.InvocationKind>>();
    private final PropertiesComponent myProperties;
    private static final int INITIAL_DELAY_MINUTES = 1;
    private static final int INTERVAL_IN_MINUTES = 30;

    public SystemHealthMonitor(@NotNull PropertiesComponent properties) {
        if (properties == null) {
            SystemHealthMonitor.$$$reportNull$$$0(0);
        }
        this.myThreadDumpsDatabase = new ThreadDumpsDatabase(new File(PathManager.getTempPath(), "threads.dmp"));
        this.myProperties = properties;
    }

    public static void recordEventTime(int interval, long durationMs) {
        myEventDurationsMs.recordValueWithCount(Math.min(durationMs, 1800000L), (long)interval);
    }

    public static void recordWriteLockWaitTime(long durationMs) {
        myWriteLockWaitTimesMs.recordValueWithCount(Math.min(durationMs, 1800000L), 1L);
    }

    public void initComponent() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.checkRuntime();
            this.checkReservedCodeCacheSize();
            this.checkIBus();
            this.checkSignalBlocking();
            SystemHealthMonitor.startDiskSpaceMonitoring();
        });
        if (ApplicationManager.getApplication().isInternal() || StatisticsUploadAssistant.isSendAllowed()) {
            ourStudioActionCount.set(this.myProperties.getOrInitLong(STUDIO_ACTIVITY_COUNT, 0L) + 1L);
            ourStudioExceptionCount.set(SystemHealthMonitor.getPersistedExceptionCount(STUDIO_EXCEPTION_COUNT_FILE));
            ourInitialPersistedExceptionCount.set(ourStudioExceptionCount.get());
            ourBundledPluginsExceptionCount.set(SystemHealthMonitor.getPersistedExceptionCount(BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE));
            ourNonBundledPluginsExceptionCount.set(SystemHealthMonitor.getPersistedExceptionCount(NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE));
            StudioCrashDetection.updateRecordedVersionNumber((String)ApplicationInfo.getInstance().getStrictVersion());
            SystemHealthMonitor.startActivityMonitoring();
            SystemHealthMonitor.trackCrashes(StudioCrashDetection.reapCrashDescriptions());
            SystemHealthMonitor.trackPerfWatcherReports(this.myThreadDumpsDatabase.reapThreadDumps());
            Application application = ApplicationManager.getApplication();
            application.getMessageBus().connect((Disposable)application).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

                @Override
                public void appClosing() {
                    SystemHealthMonitor.this.myProperties.setValue(SystemHealthMonitor.STUDIO_ACTIVITY_COUNT, Long.toString(ourStudioActionCount.get()));
                    StudioCrashDetection.stop();
                    SystemHealthMonitor.reportExceptionsAndActionInvocations();
                }
            });
            application.getMessageBus().connect((Disposable)application).subscribe(IdePerformanceListener.TOPIC, (Object)new IdePerformanceListener.Adapter(){

                public void uiFreezeFinished(int lengthInSeconds) {
                    UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PERFORMANCE_STATS).setStudioPerformanceStats(StudioPerformanceStats.newBuilder().setUiFreezeTimeMs(lengthInSeconds * 1000)));
                }

                public void dumpedThreads(@NotNull File toFile, @NotNull ThreadDump dump) {
                    if (toFile == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (dump == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    try {
                        SystemHealthMonitor.this.myThreadDumpsDatabase.appendThreadDump(toFile.toPath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "toFile";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dump";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ide/SystemHealthMonitor$2";
                    objectArray[2] = "dumpedThreads";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reportExceptionsAndActionInvocations() {
        if (!REPORT_EXCEPTIONS_LOCK.tryLock()) {
            return;
        }
        try {
            long activityCount = ourStudioActionCount.getAndSet(0L);
            long exceptionCount = ourStudioExceptionCount.getAndSet(0L);
            long bundledPluginExceptionCount = ourBundledPluginsExceptionCount.getAndSet(0L);
            long nonBundledPluginExceptionCount = ourNonBundledPluginsExceptionCount.getAndSet(0L);
            SystemHealthMonitor.persistExceptionCount(0L, STUDIO_EXCEPTION_COUNT_FILE);
            SystemHealthMonitor.persistExceptionCount(0L, BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
            SystemHealthMonitor.persistExceptionCount(0L, NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
            if (ApplicationManager.getApplication().isInternal()) assert (SystemHealthMonitor.getPersistedExceptionCount(STUDIO_EXCEPTION_COUNT_FILE) < 5L);
            if (activityCount > 0L || exceptionCount > 0L) {
                List<StackTrace> traces = ExceptionRegistry.INSTANCE.getStackTraces(0);
                ExceptionRegistry.INSTANCE.clear();
                SystemHealthMonitor.trackExceptionsAndActivity(activityCount, exceptionCount, bundledPluginExceptionCount, nonBundledPluginExceptionCount, 0L, traces);
            }
            SystemHealthMonitor.reportActionInvocations();
        }
        finally {
            REPORT_EXCEPTIONS_LOCK.unlock();
        }
    }

    private void checkRuntime() {
        JdkBundle bootJdk;
        try {
            Class.forName("com.sun.jdi.Value");
        }
        catch (Throwable t) {
            this.showNotification("unsupported.jre", null, new Object[0]);
        }
        if (StringUtil.containsIgnoreCase((String)System.getProperty("java.vm.name", ""), (String)"OpenJDK") && !SystemInfo.isJetbrainsJvm && !SystemInfo.isStudioJvm) {
            this.showNotification("unsupported.jvm.openjdk.message", null, new Object[0]);
        }
        if (JavaVersion.current().ea) {
            this.showNotification("unsupported.jvm.ea.message", null, new Object[0]);
        }
        if (!(bootJdk = JdkBundle.createBoot()).isBundled()) {
            boolean outdatedRuntime;
            boolean bl = outdatedRuntime = bootJdk.getBundleVersion().compareTo(MIN_RECOMMENDED_JDK) < 0;
            if (!SystemInfo.isJetBrainsJvm || outdatedRuntime) {
                JdkBundle bundledJdk;
                boolean validBundledJdk = (SystemInfo.isWindows || SystemInfo.isMac || SystemInfo.isLinux) && (bundledJdk = JdkBundle.createBundled()) != null && bundledJdk.isOperational();
                NotificationAction switchAction = new NotificationAction("Switch"){

                    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                        if (e == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (notification == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        notification.expire();
                        ActionManager.getInstance().getAction(SystemHealthMonitor.SWITCH_JDK_ACTION).actionPerformed(null);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "e";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/SystemHealthMonitor$3";
                        objectArray[2] = "actionPerformed";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                String current = bootJdk.getBundleVersion().toString();
                if (!SystemInfo.isJetBrainsJvm) {
                    current = current + " by " + SystemInfo.JAVA_VENDOR;
                }
                if (outdatedRuntime && validBundledJdk) {
                    this.showNotification("outdated.jre.version.message1", switchAction, current, MIN_RECOMMENDED_JDK);
                } else if (outdatedRuntime) {
                    this.showNotification("outdated.jre.version.message2", null, current, MIN_RECOMMENDED_JDK);
                } else if (validBundledJdk) {
                    this.showNotification("bundled.jre.version.message", switchAction, current);
                }
            }
        }
        if (SystemInfoRt.isMac && !SystemInfo.isJetbrainsJvm && !SystemInfo.isStudioJvm && SystemInfo.isJavaVersionAtLeast((String)"1.8.0_60") && !SystemInfo.isJavaVersionAtLeast((String)"1.8.0_76")) {
            this.showNotification("unsupported.jvm.dragndrop.message", null, new Object[0]);
        }
    }

    private void checkReservedCodeCacheSize() {
        int minReservedCodeCacheSize = 240;
        int reservedCodeCacheSize = VMOptions.readOption(VMOptions.MemoryKind.CODE_CACHE, true);
        if (reservedCodeCacheSize > 0 && reservedCodeCacheSize < minReservedCodeCacheSize) {
            final EditCustomVmOptionsAction vmEditAction = new EditCustomVmOptionsAction();
            NotificationAction action = new NotificationAction(IdeBundle.message((String)"vmoptions.edit.action", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    notification.expire();
                    ActionUtil.performActionDumbAware((AnAction)vmEditAction, (AnActionEvent)e);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ide/SystemHealthMonitor$4";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.showNotification("vmoptions.warn.message", (NotificationAction)(vmEditAction.isEnabled() ? action : null), reservedCodeCacheSize, minReservedCodeCacheSize);
        }
    }

    private void checkIBus() {
        String fix;
        Matcher m;
        String version;
        String xim;
        if (SystemInfo.isXWindow && (xim = System.getenv("XMODIFIERS")) != null && xim.contains("im=ibus") && (version = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"ibus-daemon", "--version"}))) != null && (m = Pattern.compile("ibus-daemon - Version ([0-9.]+)").matcher(version)).find() && StringUtil.compareVersionNumbers((String)m.group(1), (String)"1.5.11") < 0 && ((fix = System.getenv("IBUS_ENABLE_SYNC_MODE")) == null || fix.isEmpty() || fix.equals("0") || fix.equalsIgnoreCase("false"))) {
            this.showNotification("ibus.blocking.warn.message", SystemHealthMonitor.detailsAction("https://youtrack.jetbrains.com/issue/IDEA-78860"), new Object[0]);
        }
    }

    private static void trackPerfWatcherReports(@NotNull List<Path> threadDumps) {
        if (threadDumps == null) {
            SystemHealthMonitor.$$$reportNull$$$0(1);
        }
        if (threadDumps.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (threadDumps == null) {
                SystemHealthMonitor.$$$reportNull$$$0(16);
            }
            threadDumps.stream().limit(10L).forEach(t -> {
                List<String> lines2;
                try {
                    lines2 = Files.readAllLines(t);
                }
                catch (IOException e) {
                    return;
                }
                SystemHealthMonitor.reportAnr(t.getFileName().toString(), lines2);
            });
        });
    }

    public static void trackCrashes(@NotNull List<StudioCrashDetails> descriptions) {
        if (descriptions == null) {
            SystemHealthMonitor.$$$reportNull$$$0(2);
        }
        if (descriptions.isEmpty()) {
            return;
        }
        SystemHealthMonitor.reportCrashes(descriptions);
        SystemHealthMonitor.trackExceptionsAndActivity(0L, 0L, 0L, 0L, descriptions.size(), Collections.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    public static void trackExceptionsAndActivity(long activityCount, long exceptionCount, long bundledPluginExceptionCount, long l, long l2, @NotNull List<StackTrace> list2) {
        void stackTraces;
        void fatalExceptionCount;
        void nonBundledPluginExceptionCount;
        if (list2 == null) {
            SystemHealthMonitor.$$$reportNull$$$0(3);
        }
        if (!StatisticsUploadAssistant.isSendAllowed()) {
            return;
        }
        AndroidStudioEvent.Builder eventBuilder = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PING).setKind(AndroidStudioEvent.EventKind.STUDIO_CRASH).setStudioCrash(StudioCrash.newBuilder().setActions(activityCount).setExceptions(exceptionCount).setBundledPluginExceptions(bundledPluginExceptionCount).setNonBundledPluginExceptions((long)nonBundledPluginExceptionCount).setCrashes((long)fatalExceptionCount));
        SystemHealthMonitor.logUsageOnlyIfNotInternalApplication(eventBuilder);
        for (StackTrace stackTrace : stackTraces) {
            AndroidStudioEvent.Builder crashEventBuilder = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PING).setKind(AndroidStudioEvent.EventKind.STUDIO_CRASH).setStudioCrash(StudioCrash.newBuilder().addDetails(StudioExceptionDetails.newBuilder().setHash(stackTrace.md5string()).setCount(stackTrace.getCount()).setSummary(stackTrace.summarize(20)).build()));
            SystemHealthMonitor.logUsageOnlyIfNotInternalApplication(stackTrace.timeOfFirstHitMs(), crashEventBuilder);
        }
    }

    private static void logUsageOnlyIfNotInternalApplication(AndroidStudioEvent.Builder eventBuilder) {
        if (!ApplicationManager.getApplication().isInternal()) {
            UsageTracker.getInstance().log(eventBuilder);
        } else {
            LOG.debug("SystemHealthMonitor would send following analytics event in the release build: " + eventBuilder.build());
        }
    }

    private static void logUsageOnlyIfNotInternalApplication(long eventTimeMs, AndroidStudioEvent.Builder eventBuilder) {
        if (!ApplicationManager.getApplication().isInternal()) {
            UsageTracker.getInstance().log(eventTimeMs, eventBuilder);
        } else {
            SystemHealthMonitor.logUsageOnlyIfNotInternalApplication(eventBuilder);
        }
    }

    private void checkSignalBlocking() {
        if (SystemInfo.isUnix && JnaLoader.isLoaded()) {
            try {
                LibC lib = (LibC)Native.loadLibrary((String)"c", LibC.class);
                Memory buf = new Memory(1024L);
                if (lib.sigaction(2, null, (Pointer)buf) == 0) {
                    long handler2;
                    long l = handler2 = Native.POINTER_SIZE == 8 ? buf.getLong(0L) : (long)buf.getInt(0L);
                    if (handler2 == 1L) {
                        this.showNotification("ide.sigint.ignored.message", SystemHealthMonitor.detailsAction("https://youtrack.jetbrains.com/issue/IDEA-157989"), new Object[0]);
                    }
                }
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }
    }

    private void showNotification(final @PropertyKey(resourceBundle="messages.IdeBundle") String key, @Nullable NotificationAction action, Object ... params) {
        boolean ignored = this.myProperties.isValueSet("ignore." + key);
        LOG.info("issue detected: " + key + (ignored ? " (ignored)" : ""));
        if (ignored) {
            return;
        }
        MyNotification notification = new MyNotification(IdeBundle.message((String)key, (Object[])params));
        if (action != null) {
            notification.addAction((AnAction)action);
        }
        notification.addAction((AnAction)new NotificationAction(IdeBundle.message((String)"sys.health.acknowledge.action", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    5.$$$reportNull$$$0(1);
                }
                notification.expire();
                SystemHealthMonitor.this.myProperties.setValue("ignore." + key, "true");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/SystemHealthMonitor$5";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.setImportant(true);
        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)notification));
    }

    private static NotificationAction detailsAction(String url) {
        return new BrowseNotificationAction(IdeBundle.message((String)"sys.health.details", (Object[])new Object[0]), url);
    }

    private static void startDiskSpaceMonitoring() {
        if (SystemProperties.getBooleanProperty((String)"idea.no.system.path.space.monitoring", (boolean)false)) {
            return;
        }
        final File file2 = new File(PathManager.getSystemPath());
        final AtomicBoolean reported = new AtomicBoolean();
        final ThreadLocal ourFreeSpaceCalculation = new ThreadLocal();
        JobScheduler.getScheduler().schedule(new Runnable(){
            private static final long LOW_DISK_SPACE_THRESHOLD = 0x3200000L;
            private static final long MAX_WRITE_SPEED_IN_BPS = 524288000L;

            @Override
            public void run() {
                if (!reported.get()) {
                    Future future2 = (Future)ourFreeSpaceCalculation.get();
                    if (future2 == null) {
                        future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            long fileUsableSpace = file2.getUsableSpace();
                            while (fileUsableSpace == 0L) {
                                TimeoutUtil.sleep((long)5000L);
                                fileUsableSpace = file2.getUsableSpace();
                            }
                            return fileUsableSpace;
                        });
                        ourFreeSpaceCalculation.set(future2);
                    }
                    if (!future2.isDone() || future2.isCancelled()) {
                        this.restart(1L);
                        return;
                    }
                    try {
                        long fileUsableSpace = (Long)future2.get();
                        long timeout = Math.min(3600L, Math.max(5L, (fileUsableSpace - 0x3200000L) / 524288000L));
                        ourFreeSpaceCalculation.set(null);
                        if (fileUsableSpace < 0x3200000L) {
                            if (ReadAction.compute(() -> NotificationsConfiguration.getNotificationsConfiguration()) == null) {
                                ourFreeSpaceCalculation.set(future2);
                                this.restart(1L);
                                return;
                            }
                            reported.compareAndSet(false, true);
                            SwingUtilities.invokeLater(() -> {
                                String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                                String message = IdeBundle.message((String)"low.disk.space.message", (Object[])new Object[]{productName});
                                if (fileUsableSpace < 102400L) {
                                    LOG.warn(message + " (" + fileUsableSpace + ")");
                                    Messages.showErrorDialog((String)message, (String)"Fatal Configuration Problem");
                                    reported.compareAndSet(true, false);
                                    this.restart(timeout);
                                } else {
                                    GROUP.createNotification(message, file2.getPath(), NotificationType.ERROR, null).whenExpired(() -> {
                                        reported.compareAndSet(true, false);
                                        this.restart(timeout);
                                    }).notify(null);
                                }
                            });
                        } else {
                            this.restart(timeout);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            }

            private void restart(long timeout) {
                JobScheduler.getScheduler().schedule(this, timeout, TimeUnit.SECONDS);
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private static void startActivityMonitoring() {
        JobScheduler.getScheduler().scheduleWithFixedDelay(SystemHealthMonitor::reportExceptionsAndActionInvocations, 1L, 30L, TimeUnit.MINUTES);
    }

    public static void incrementAndSaveExceptionCount() {
        SystemHealthMonitor.persistExceptionCount(ourStudioExceptionCount.incrementAndGet(), STUDIO_EXCEPTION_COUNT_FILE);
        if (ApplicationManager.getApplication().isInternal()) assert (Math.abs(SystemHealthMonitor.getPersistedExceptionCount(STUDIO_EXCEPTION_COUNT_FILE) - ourStudioExceptionCount.get()) < 5L);
    }

    public static void incrementAndSaveBundledPluginsExceptionCount() {
        SystemHealthMonitor.persistExceptionCount(ourBundledPluginsExceptionCount.incrementAndGet(), BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
    }

    public static void incrementAndSaveNonBundledPluginsExceptionCount() {
        SystemHealthMonitor.persistExceptionCount(ourNonBundledPluginsExceptionCount.incrementAndGet(), NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void persistExceptionCount(long count, @NotNull String string) {
        if (string == null) {
            SystemHealthMonitor.$$$reportNull$$$0(4);
        }
        Object object = EXCEPTION_COUNT_LOCK;
        synchronized (object) {
            try {
                void countFileName;
                File f = new File(PathManager.getTempPath(), (String)countFileName);
                com.google.common.io.Files.write((CharSequence)Long.toString(count), (File)f, (Charset)Charsets.UTF_8);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getPersistedExceptionCount(@NotNull String countFileName) {
        if (countFileName == null) {
            SystemHealthMonitor.$$$reportNull$$$0(5);
        }
        Object object = EXCEPTION_COUNT_LOCK;
        synchronized (object) {
            try {
                File f = new File(PathManager.getTempPath(), countFileName);
                String contents = com.google.common.io.Files.toString((File)f, (Charset)Charsets.UTF_8);
                return Long.parseLong(contents);
            }
            catch (Throwable t) {
                return 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void countActionInvocation(@NotNull Class actionClass, @NotNull Presentation templatePresentation, @NotNull AnActionEvent event) {
        if (actionClass == null) {
            SystemHealthMonitor.$$$reportNull$$$0(6);
        }
        if (templatePresentation == null) {
            SystemHealthMonitor.$$$reportNull$$$0(7);
        }
        if (event == null) {
            SystemHealthMonitor.$$$reportNull$$$0(8);
        }
        Object object = ACTION_INVOCATIONS_LOCK;
        synchronized (object) {
            String actionName = SystemHealthMonitor.getActionName(actionClass, templatePresentation);
            UIActionStats.InvocationKind invocationKind = SystemHealthMonitor.getInvocationKindFromEvent(event);
            if (SystemHealthMonitor.shouldAggregate(actionClass)) {
                LinkedHashMultiset invocations = ourActionInvocations.get(actionName);
                if (invocations == null) {
                    invocations = LinkedHashMultiset.create();
                    ourActionInvocations.put(actionName, (Multiset<UIActionStats.InvocationKind>)invocations);
                }
                invocations.add((Object)invocationKind);
            } else {
                UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.STUDIO_UI).setKind(AndroidStudioEvent.EventKind.STUDIO_UI_ACTION_STATS).setUiActionStats(UIActionStats.newBuilder().setActionClassName(actionName).setInvocationKind(invocationKind).setInvocations(1L).setDirect(true)));
            }
        }
    }

    private static boolean shouldAggregate(Class actionClass) {
        return EditorAction.class.isAssignableFrom(actionClass) || UndoRedoAction.class.isAssignableFrom(actionClass) || PasteAction.class.isAssignableFrom(actionClass) || CopyAction.class.isAssignableFrom(actionClass) || CutAction.class.isAssignableFrom(actionClass) || SaveAllAction.class.isAssignableFrom(actionClass) || DeleteAction.class.isAssignableFrom(actionClass) || NextOccurenceAction.class.isAssignableFrom(actionClass) || PreviousOccurenceAction.class.isAssignableFrom(actionClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reportActionInvocations() {
        Map<String, Multiset<UIActionStats.InvocationKind>> currentInvocations = null;
        Iterator<Map.Entry<String, Multiset<UIActionStats.InvocationKind>>> iterator = ACTION_INVOCATIONS_LOCK;
        synchronized (iterator) {
            currentInvocations = ourActionInvocations;
            ourActionInvocations = new HashMap<String, Multiset<UIActionStats.InvocationKind>>();
        }
        for (Map.Entry<String, Multiset<UIActionStats.InvocationKind>> actionEntry : currentInvocations.entrySet()) {
            for (Multiset.Entry invocationEntry : actionEntry.getValue().entrySet()) {
                UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.STUDIO_UI).setKind(AndroidStudioEvent.EventKind.STUDIO_UI_ACTION_STATS).setUiActionStats(UIActionStats.newBuilder().setActionClassName(actionEntry.getKey()).setInvocationKind((UIActionStats.InvocationKind)invocationEntry.getElement()).setInvocations((long)invocationEntry.getCount())));
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            StudioPerformanceStats.Builder statsProto = StudioPerformanceStats.newBuilder().setEventServiceTimeSamplePeriod(1).setEventServiceTimeMs(HistogramUtil.toProto(myEventDurationsMs)).setWriteLockWaitTimeMs(HistogramUtil.toProto(myWriteLockWaitTimesMs));
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.STUDIO_UI).setKind(AndroidStudioEvent.EventKind.STUDIO_PERFORMANCE_STATS).setStudioPerformanceStats(statsProto));
            myEventDurationsMs.reset();
            myWriteLockWaitTimesMs.reset();
        });
    }

    private static UIActionStats.InvocationKind getInvocationKindFromEvent(AnActionEvent event) {
        if (event.getInputEvent() instanceof KeyEvent) {
            return UIActionStats.InvocationKind.KEYBOARD_SHORTCUT;
        }
        String place = event.getPlace();
        if (place.contains("Menu")) {
            return UIActionStats.InvocationKind.MENU;
        }
        if (place.contains("Toolbar")) {
            return UIActionStats.InvocationKind.TOOLBAR;
        }
        if (event.getInputEvent() instanceof MouseEvent) {
            return UIActionStats.InvocationKind.MOUSE;
        }
        return UIActionStats.InvocationKind.UNKNOWN_INVOCATION_KIND;
    }

    static String getActionName(@NotNull Class actionClass, @NotNull Presentation templatePresentation) {
        if (actionClass == null) {
            SystemHealthMonitor.$$$reportNull$$$0(9);
        }
        if (templatePresentation == null) {
            SystemHealthMonitor.$$$reportNull$$$0(10);
        }
        Class<?> currentClass = actionClass;
        while (currentClass.isAnonymousClass()) {
            currentClass = currentClass.getEnclosingClass();
        }
        String packageName = currentClass.getPackage().getName();
        if (packageName.startsWith("com.android.") || packageName.startsWith("com.intellij.") || packageName.startsWith("org.jetbrains.") || packageName.startsWith("or.intellij.") || packageName.startsWith("com.jetbrains.") || packageName.startsWith("git4idea.")) {
            String actionName = currentClass.getSimpleName();
            if (actionName.equals("ExecutorAction")) {
                actionName = actionName + "#" + templatePresentation.getText();
            }
            return actionName;
        }
        return currentClass.getCanonicalName();
    }

    public static void reportException(@NotNull Throwable t, @NotNull StackTrace stackTrace) {
        if (t == null) {
            SystemHealthMonitor.$$$reportNull$$$0(11);
        }
        if (stackTrace == null) {
            SystemHealthMonitor.$$$reportNull$$$0(12);
        }
        if (!UsageTracker.getInstance().getAnalyticsSettings().hasOptedIn()) {
            return;
        }
        ErrorReportSubmitter reporter = IdeErrorsDialog.getAndroidErrorReporter();
        if (reporter != null) {
            AndroidStudioExceptionEvent e = new AndroidStudioExceptionEvent(t.getMessage(), t, stackTrace);
            reporter.submit(new IdeaLoggingEvent[]{e}, null, null, info -> {});
        }
    }

    private static void reportAnr(@NotNull String fileName, @NotNull List<String> threadDump) {
        if (fileName == null) {
            SystemHealthMonitor.$$$reportNull$$$0(13);
        }
        if (threadDump == null) {
            SystemHealthMonitor.$$$reportNull$$$0(14);
        }
        if (!UsageTracker.getInstance().getAnalyticsSettings().hasOptedIn()) {
            return;
        }
        ErrorReportSubmitter reporter = IdeErrorsDialog.getAndroidErrorReporter();
        if (reporter != null) {
            AndroidStudioAnrEvent e = new AndroidStudioAnrEvent(fileName, Joiner.on((char)'\n').join(threadDump));
            reporter.submit(new IdeaLoggingEvent[]{e}, null, null, info -> {});
        }
    }

    private static void reportCrashes(@NotNull List<StudioCrashDetails> descriptions) {
        if (descriptions == null) {
            SystemHealthMonitor.$$$reportNull$$$0(15);
        }
        if (!UsageTracker.getInstance().getAnalyticsSettings().hasOptedIn()) {
            return;
        }
        ErrorReportSubmitter reporter = IdeErrorsDialog.getAndroidErrorReporter();
        if (reporter != null) {
            AndroidStudioCrashEvents e = new AndroidStudioCrashEvents(descriptions);
            reporter.submit(new IdeaLoggingEvent[]{e}, null, null, info -> {});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadDumps";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTraces";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "countFileName";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionClass";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatePresentation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTrace";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadDump";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/SystemHealthMonitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "trackPerfWatcherReports";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "trackCrashes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "trackExceptionsAndActivity";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "persistExceptionCount";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getPersistedExceptionCount";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "countActionInvocation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "reportException";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "reportAnr";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "reportCrashes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$trackPerfWatcherReports$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AndroidStudioCrashEvents
    extends IdeaLoggingEvent {
        private List<StudioCrashDetails> myCrashDetails;

        public AndroidStudioCrashEvents(@NotNull List<StudioCrashDetails> crashDetails) {
            if (crashDetails == null) {
                AndroidStudioCrashEvents.$$$reportNull$$$0(0);
            }
            super("", null);
            this.myCrashDetails = crashDetails;
        }

        @Nullable
        public Object getData() {
            return ImmutableMap.of((Object)"Type", (Object)"Crashes", (Object)"crashDetails", this.myCrashDetails);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "crashDetails", "com/intellij/ide/SystemHealthMonitor$AndroidStudioCrashEvents", "<init>"));
        }
    }

    private static class AndroidStudioAnrEvent
    extends IdeaLoggingEvent {
        private final String myFileName;
        private final String myThreadDump;

        public AndroidStudioAnrEvent(@NotNull String fileName, @NotNull String threadDump) {
            if (fileName == null) {
                AndroidStudioAnrEvent.$$$reportNull$$$0(0);
            }
            if (threadDump == null) {
                AndroidStudioAnrEvent.$$$reportNull$$$0(1);
            }
            super("", null);
            this.myFileName = fileName;
            this.myThreadDump = threadDump;
        }

        @Nullable
        public Object getData() {
            return ImmutableMap.of((Object)"Type", (Object)"ANR", (Object)"file", (Object)this.myFileName, (Object)"threadDump", (Object)this.myThreadDump);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "threadDump";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/SystemHealthMonitor$AndroidStudioAnrEvent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AndroidStudioExceptionEvent
    extends IdeaLoggingEvent {
        private final StackTrace myStackTrace;

        public AndroidStudioExceptionEvent(String message, Throwable throwable, @NotNull StackTrace stackTrace) {
            if (stackTrace == null) {
                AndroidStudioExceptionEvent.$$$reportNull$$$0(0);
            }
            super(message, throwable);
            this.myStackTrace = stackTrace;
        }

        @Nullable
        public Object getData() {
            return ImmutableMap.of((Object)"Type", (Object)"Exception", (Object)"md5", (Object)this.myStackTrace.md5string(), (Object)"summary", (Object)this.myStackTrace.summarize(50));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackTrace", "com/intellij/ide/SystemHealthMonitor$AndroidStudioExceptionEvent", "<init>"));
        }
    }

    private static interface LibC
    extends Library {
        public static final int SIGINT = 2;
        public static final long SIG_IGN = 1L;

        public int sigaction(int var1, Pointer var2, Pointer var3);
    }

    private static final class MyNotification
    extends Notification
    implements NotificationFullContent {
        public MyNotification(@NotNull String content) {
            if (content == null) {
                MyNotification.$$$reportNull$$$0(0);
            }
            super(GROUP.getDisplayId(), "", content, NotificationType.WARNING);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/SystemHealthMonitor$MyNotification", "<init>"));
        }
    }
}

