/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadDumpsDatabase {
    private final Object myDbLock;
    private final Path myDb;

    public ThreadDumpsDatabase(@NotNull File databaseFile) {
        if (databaseFile == null) {
            ThreadDumpsDatabase.$$$reportNull$$$0(0);
        }
        this.myDbLock = new Object();
        this.myDb = databaseFile.toPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendThreadDump(@NotNull Path threadDumpPath) throws IOException {
        if (threadDumpPath == null) {
            ThreadDumpsDatabase.$$$reportNull$$$0(1);
        }
        String content = threadDumpPath.toString() + "\n";
        Object object = this.myDbLock;
        synchronized (object) {
            Files.write(this.myDb, content.getBytes(Charsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<Path> reapThreadDumps() {
        List<String> lines2;
        Object object = this.myDbLock;
        synchronized (object) {
            try {
                lines2 = Files.readAllLines(this.myDb);
                Files.write(this.myDb, new byte[0], StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                ImmutableList immutableList = ImmutableList.of();
                // MONITOREXIT @DISABLED, blocks:[3, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var2_1
                if (immutableList == null) {
                    ThreadDumpsDatabase.$$$reportNull$$$0(2);
                }
                return immutableList;
            }
        }
        List<Path> list2 = lines2.stream().map(String::trim).filter(line -> !line.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0])).map(ThreadDumpsDatabase::fixDirectoryPathAndCheckIfReadable).filter(Objects::nonNull).collect(Collectors.toList());
        if (list2 == null) {
            ThreadDumpsDatabase.$$$reportNull$$$0(3);
        }
        return list2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Path fixDirectoryPathAndCheckIfReadable(@NotNull Path path) {
        if (path == null) {
            ThreadDumpsDatabase.$$$reportNull$$$0(4);
        }
        if (Files.isReadable(path)) {
            return path;
        }
        Path directory = path.getParent();
        try {
            String prefix = directory.getFileName() + "-";
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(directory.getParent(), entry -> entry.getFileName().toString().startsWith(prefix));){
                Iterator<Path> iterator = paths.iterator();
                if (!iterator.hasNext()) {
                    Path path3 = null;
                    return path3;
                }
                Path newDirectory = iterator.next();
                Path newFile = newDirectory.resolve(path.getFileName());
                Path path2 = Files.isReadable(newFile) ? newFile : null;
                return path2;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadDumpPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ThreadDumpsDatabase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ThreadDumpsDatabase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "reapThreadDumps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "appendThreadDump";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fixDirectoryPathAndCheckIfReadable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

